/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.viewfs.ViewFsBaseTest;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestViewFsWithAuthorityLocalFs
extends ViewFsBaseTest {
    URI schemeWithAuthority;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        this.fcTarget = FileContext.getLocalFSFileContext();
        super.setUp();
        this.schemeWithAuthority = new URI("viewfs", "mycluster", "/", null, null);
        this.fcView = FileContext.getFileContext((URI)this.schemeWithAuthority, (Configuration)this.conf);
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Override
    @Test
    public void testBasicPaths() {
        Assertions.assertEquals((Object)this.schemeWithAuthority, (Object)this.fcView.getDefaultFileSystem().getUri());
        Assertions.assertEquals((Object)this.fcView.makeQualified(new Path("/user/" + System.getProperty("user.name"))), (Object)this.fcView.getWorkingDirectory());
        Assertions.assertEquals((Object)this.fcView.makeQualified(new Path("/user/" + System.getProperty("user.name"))), (Object)this.fcView.getHomeDirectory());
        Assertions.assertEquals((Object)new Path("/foo/bar").makeQualified(this.schemeWithAuthority, null), (Object)this.fcView.makeQualified(new Path("/foo/bar")));
    }
}

