/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.viewfs.ViewFileSystemOverloadScheme;
import org.apache.hadoop.fs.viewfs.ViewFsTestSetup;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestViewFileSystemOverloadSchemeLocalFileSystem {
    private static final String FILE = "file";
    private static final Logger LOG = LoggerFactory.getLogger(TestViewFileSystemOverloadSchemeLocalFileSystem.class);
    private FileSystem fsTarget;
    private Configuration conf;
    private Path targetTestRoot;
    private FileSystemTestHelper fileSystemTestHelper = new FileSystemTestHelper();

    @BeforeEach
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.conf.set(String.format("fs.%s.impl", FILE), ViewFileSystemOverloadScheme.class.getName());
        this.conf.set(String.format("fs.viewfs.overload.scheme.target.%s.impl", FILE), LocalFileSystem.class.getName());
        this.fsTarget = new LocalFileSystem();
        this.fsTarget.initialize(new URI("file:///"), this.conf);
        this.targetTestRoot = this.fileSystemTestHelper.getAbsoluteTestRootPath(this.fsTarget);
        this.fsTarget.delete(this.targetTestRoot, true);
        this.fsTarget.mkdirs(this.targetTestRoot);
    }

    void addMountLinks(String mountTable, String[] sources, String[] targets, Configuration config) throws IOException, URISyntaxException {
        ViewFsTestSetup.addMountLinksToConf(mountTable, sources, targets, config);
    }

    @Test
    public void testLocalTargetLinkWriteSimple() throws IOException, URISyntaxException {
        LOG.info("Starting testLocalTargetLinkWriteSimple");
        String testString = "Hello Local!...";
        Path lfsRoot = new Path("/lfsRoot");
        this.addMountLinks(null, new String[]{lfsRoot.toString()}, new String[]{this.targetTestRoot + "/local"}, this.conf);
        try (FileSystem lViewFs = FileSystem.get((URI)URI.create("file:///"), (Configuration)this.conf);){
            Path testPath = new Path(lfsRoot, "test.txt");
            try (FSDataOutputStream fsDos = lViewFs.create(testPath);){
                fsDos.writeUTF("Hello Local!...");
            }
            try (FSDataInputStream lViewIs = lViewFs.open(testPath);){
                Assertions.assertEquals((Object)"Hello Local!...", (Object)lViewIs.readUTF());
            }
        }
    }

    @Test
    public void testLocalFsCreateAndDelete() throws Exception {
        LOG.info("Starting testLocalFsCreateAndDelete");
        this.addMountLinks("mt", new String[]{"/lfsroot"}, new String[]{this.targetTestRoot + "/wd2"}, this.conf);
        URI mountURI = URI.create("file://mt/");
        try (FileSystem lViewFS = FileSystem.get((URI)mountURI, (Configuration)this.conf);){
            Path testPath = new Path(mountURI.toString() + "/lfsroot/test");
            lViewFS.createNewFile(testPath);
            Assertions.assertTrue((boolean)lViewFS.exists(testPath));
            lViewFS.delete(testPath, true);
            Assertions.assertFalse((boolean)lViewFS.exists(testPath));
        }
    }

    @Test
    public void testLocalFsLinkSlashMerge() throws Exception {
        LOG.info("Starting testLocalFsLinkSlashMerge");
        this.addMountLinks("mt", new String[]{"linkMergeSlash"}, new String[]{this.targetTestRoot + "/wd2"}, this.conf);
        URI mountURI = URI.create("file://mt/");
        try (FileSystem lViewFS = FileSystem.get((URI)mountURI, (Configuration)this.conf);){
            Path fileOnRoot = new Path(mountURI.toString() + "/NewFile");
            lViewFS.createNewFile(fileOnRoot);
            Assertions.assertTrue((boolean)lViewFS.exists(fileOnRoot));
        }
    }

    @Test
    public void testLocalFsLinkSlashMergeWithOtherMountLinks() throws Exception {
        Assertions.assertThrows(IOException.class, () -> {
            LOG.info("Starting testLocalFsLinkSlashMergeWithOtherMountLinks");
            this.addMountLinks("mt", new String[]{"/lfsroot", "linkMergeSlash"}, new String[]{this.targetTestRoot + "/wd2", this.targetTestRoot + "/wd2"}, this.conf);
            URI mountURI = URI.create("file://mt/");
            FileSystem.get((URI)mountURI, (Configuration)this.conf);
            Assertions.fail((String)"A merge slash cannot be configured with other mount links.");
        });
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (null != this.fsTarget) {
            this.fsTarget.delete(this.fileSystemTestHelper.getTestRootPath(this.fsTarget), true);
            this.fsTarget.close();
        }
    }

    public Path getTestRoot() {
        return this.targetTestRoot;
    }

    public Configuration getConf() {
        return this.conf;
    }
}

