/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.net.URI;
import java.util.List;
import java.util.function.Function;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.viewfs.ConfigUtil;
import org.apache.hadoop.fs.viewfs.InodeTree;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestNestedMountPoint {
    private InodeTree inodeTree;
    private Configuration conf;
    private String mtName;
    private URI fsUri;
    private static final URI LINKFALLBACK_TARGET = URI.create("hdfs://nn00");
    private static final URI NN1_TARGET = URI.create("hdfs://nn01/a/b");
    private static final URI NN2_TARGET = URI.create("hdfs://nn02/a/b/e");
    private static final URI NN3_TARGET = URI.create("hdfs://nn03/a/b/c/d");
    private static final URI NN4_TARGET = URI.create("hdfs://nn04/a/b/c/d/e");
    private static final URI NN5_TARGET = URI.create("hdfs://nn05/b/c/d/e");
    private static final URI NN6_TARGET = URI.create("hdfs://nn06/b/c/d/e/f");

    @BeforeEach
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.mtName = TestNestedMountPoint.class.getName();
        ConfigUtil.setIsNestedMountPointSupported((Configuration)this.conf, (boolean)true);
        ConfigUtil.addLink((Configuration)this.conf, (String)this.mtName, (String)"/a/b", (URI)NN1_TARGET);
        ConfigUtil.addLink((Configuration)this.conf, (String)this.mtName, (String)"/a/b/e", (URI)NN2_TARGET);
        ConfigUtil.addLink((Configuration)this.conf, (String)this.mtName, (String)"/a/b/c/d", (URI)NN3_TARGET);
        ConfigUtil.addLink((Configuration)this.conf, (String)this.mtName, (String)"/a/b/c/d/e", (URI)NN4_TARGET);
        ConfigUtil.addLink((Configuration)this.conf, (String)this.mtName, (String)"/b/c/d/e", (URI)NN5_TARGET);
        ConfigUtil.addLink((Configuration)this.conf, (String)this.mtName, (String)"/b/c/d/e/f", (URI)NN6_TARGET);
        ConfigUtil.addLinkFallback((Configuration)this.conf, (String)this.mtName, (URI)LINKFALLBACK_TARGET);
        this.fsUri = new URI("viewfs", this.mtName, "/", null, null);
        this.inodeTree = new InodeTree<TestNestMountPointFileSystem>(this.conf, this.mtName, this.fsUri, false){

            protected Function<URI, TestNestMountPointFileSystem> initAndGetTargetFs() {
                return new Function<URI, TestNestMountPointFileSystem>(){

                    @Override
                    public TestNestMountPointFileSystem apply(URI uri) {
                        return new TestNestMountPointFileSystem(uri);
                    }
                };
            }

            protected TestNestMountPointInternalFileSystem getTargetFileSystem(InodeTree.INodeDir<TestNestMountPointFileSystem> dir) {
                return new TestNestMountPointInternalFileSystem(TestNestedMountPoint.this.fsUri);
            }

            protected TestNestMountPointInternalFileSystem getTargetFileSystem(String settings, URI[] mergeFsURIList) {
                return new TestNestMountPointInternalFileSystem(null);
            }
        };
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.inodeTree = null;
    }

    @Test
    public void testPathResolveToLink() throws Exception {
        InodeTree.ResolveResult resolveResult = this.inodeTree.resolve("/a/b/c/d/e/f", true);
        Assertions.assertEquals((Object)InodeTree.ResultKind.EXTERNAL_DIR, (Object)resolveResult.kind);
        Assertions.assertEquals((Object)"/a/b/c/d/e", (Object)resolveResult.resolvedPath);
        Assertions.assertEquals((Object)new Path("/f"), (Object)resolveResult.remainingPath);
        Assertions.assertTrue((boolean)(resolveResult.targetFileSystem instanceof TestNestMountPointFileSystem));
        Assertions.assertEquals((Object)NN4_TARGET, (Object)((TestNestMountPointFileSystem)resolveResult.targetFileSystem).getUri());
        Assertions.assertTrue((boolean)resolveResult.isLastInternalDirLink());
        InodeTree.ResolveResult resolveResult2 = this.inodeTree.resolve("/a/b/c/d/e", true);
        Assertions.assertEquals((Object)InodeTree.ResultKind.EXTERNAL_DIR, (Object)resolveResult2.kind);
        Assertions.assertEquals((Object)"/a/b/c/d/e", (Object)resolveResult2.resolvedPath);
        Assertions.assertEquals((Object)new Path("/"), (Object)resolveResult2.remainingPath);
        Assertions.assertTrue((boolean)(resolveResult2.targetFileSystem instanceof TestNestMountPointFileSystem));
        Assertions.assertEquals((Object)NN4_TARGET, (Object)((TestNestMountPointFileSystem)resolveResult2.targetFileSystem).getUri());
        Assertions.assertTrue((boolean)resolveResult2.isLastInternalDirLink());
        InodeTree.ResolveResult resolveResult3 = this.inodeTree.resolve("/a/b/c/d/e/f/g/h/i", true);
        Assertions.assertEquals((Object)InodeTree.ResultKind.EXTERNAL_DIR, (Object)resolveResult3.kind);
        Assertions.assertEquals((Object)"/a/b/c/d/e", (Object)resolveResult3.resolvedPath);
        Assertions.assertEquals((Object)new Path("/f/g/h/i"), (Object)resolveResult3.remainingPath);
        Assertions.assertTrue((boolean)(resolveResult3.targetFileSystem instanceof TestNestMountPointFileSystem));
        Assertions.assertEquals((Object)NN4_TARGET, (Object)((TestNestMountPointFileSystem)resolveResult3.targetFileSystem).getUri());
        Assertions.assertTrue((boolean)resolveResult3.isLastInternalDirLink());
    }

    @Test
    public void testPathResolveToLinkNotResolveLastComponent() throws Exception {
        InodeTree.ResolveResult resolveResult = this.inodeTree.resolve("/a/b/c/d/e/f", false);
        Assertions.assertEquals((Object)InodeTree.ResultKind.EXTERNAL_DIR, (Object)resolveResult.kind);
        Assertions.assertEquals((Object)"/a/b/c/d/e", (Object)resolveResult.resolvedPath);
        Assertions.assertEquals((Object)new Path("/f"), (Object)resolveResult.remainingPath);
        Assertions.assertTrue((boolean)(resolveResult.targetFileSystem instanceof TestNestMountPointFileSystem));
        Assertions.assertEquals((Object)NN4_TARGET, (Object)((TestNestMountPointFileSystem)resolveResult.targetFileSystem).getUri());
        Assertions.assertTrue((boolean)resolveResult.isLastInternalDirLink());
        InodeTree.ResolveResult resolveResult2 = this.inodeTree.resolve("/a/b/c/d/e", false);
        Assertions.assertEquals((Object)InodeTree.ResultKind.EXTERNAL_DIR, (Object)resolveResult2.kind);
        Assertions.assertEquals((Object)"/a/b/c/d", (Object)resolveResult2.resolvedPath);
        Assertions.assertEquals((Object)new Path("/e"), (Object)resolveResult2.remainingPath);
        Assertions.assertTrue((boolean)(resolveResult2.targetFileSystem instanceof TestNestMountPointFileSystem));
        Assertions.assertEquals((Object)NN3_TARGET, (Object)((TestNestMountPointFileSystem)resolveResult2.targetFileSystem).getUri());
        Assertions.assertTrue((boolean)resolveResult2.isLastInternalDirLink());
        InodeTree.ResolveResult resolveResult3 = this.inodeTree.resolve("/a/b/c/d/e/f/g/h/i", false);
        Assertions.assertEquals((Object)InodeTree.ResultKind.EXTERNAL_DIR, (Object)resolveResult3.kind);
        Assertions.assertEquals((Object)"/a/b/c/d/e", (Object)resolveResult3.resolvedPath);
        Assertions.assertEquals((Object)new Path("/f/g/h/i"), (Object)resolveResult3.remainingPath);
        Assertions.assertTrue((boolean)(resolveResult3.targetFileSystem instanceof TestNestMountPointFileSystem));
        Assertions.assertEquals((Object)NN4_TARGET, (Object)((TestNestMountPointFileSystem)resolveResult3.targetFileSystem).getUri());
        Assertions.assertTrue((boolean)resolveResult3.isLastInternalDirLink());
    }

    @Test
    public void testPathResolveToDirLink() throws Exception {
        InodeTree.ResolveResult resolveResult = this.inodeTree.resolve("/a/b/c/d/f", true);
        Assertions.assertEquals((Object)InodeTree.ResultKind.EXTERNAL_DIR, (Object)resolveResult.kind);
        Assertions.assertEquals((Object)"/a/b/c/d", (Object)resolveResult.resolvedPath);
        Assertions.assertEquals((Object)new Path("/f"), (Object)resolveResult.remainingPath);
        Assertions.assertTrue((boolean)(resolveResult.targetFileSystem instanceof TestNestMountPointFileSystem));
        Assertions.assertEquals((Object)NN3_TARGET, (Object)((TestNestMountPointFileSystem)resolveResult.targetFileSystem).getUri());
        Assertions.assertTrue((boolean)resolveResult.isLastInternalDirLink());
        InodeTree.ResolveResult resolveResult2 = this.inodeTree.resolve("/a/b/c/d", true);
        Assertions.assertEquals((Object)InodeTree.ResultKind.EXTERNAL_DIR, (Object)resolveResult2.kind);
        Assertions.assertEquals((Object)"/a/b/c/d", (Object)resolveResult2.resolvedPath);
        Assertions.assertEquals((Object)new Path("/"), (Object)resolveResult2.remainingPath);
        Assertions.assertTrue((boolean)(resolveResult2.targetFileSystem instanceof TestNestMountPointFileSystem));
        Assertions.assertEquals((Object)NN3_TARGET, (Object)((TestNestMountPointFileSystem)resolveResult2.targetFileSystem).getUri());
        Assertions.assertTrue((boolean)resolveResult2.isLastInternalDirLink());
        InodeTree.ResolveResult resolveResult3 = this.inodeTree.resolve("/a/b/c/d/f/g/h/i", true);
        Assertions.assertEquals((Object)InodeTree.ResultKind.EXTERNAL_DIR, (Object)resolveResult3.kind);
        Assertions.assertEquals((Object)"/a/b/c/d", (Object)resolveResult3.resolvedPath);
        Assertions.assertEquals((Object)new Path("/f/g/h/i"), (Object)resolveResult3.remainingPath);
        Assertions.assertTrue((boolean)(resolveResult3.targetFileSystem instanceof TestNestMountPointFileSystem));
        Assertions.assertEquals((Object)NN3_TARGET, (Object)((TestNestMountPointFileSystem)resolveResult3.targetFileSystem).getUri());
        Assertions.assertTrue((boolean)resolveResult3.isLastInternalDirLink());
    }

    @Test
    public void testPathResolveToDirLinkNotResolveLastComponent() throws Exception {
        InodeTree.ResolveResult resolveResult = this.inodeTree.resolve("/a/b/c/d/f", false);
        Assertions.assertEquals((Object)InodeTree.ResultKind.EXTERNAL_DIR, (Object)resolveResult.kind);
        Assertions.assertEquals((Object)"/a/b/c/d", (Object)resolveResult.resolvedPath);
        Assertions.assertEquals((Object)new Path("/f"), (Object)resolveResult.remainingPath);
        Assertions.assertTrue((boolean)(resolveResult.targetFileSystem instanceof TestNestMountPointFileSystem));
        Assertions.assertEquals((Object)NN3_TARGET, (Object)((TestNestMountPointFileSystem)resolveResult.targetFileSystem).getUri());
        Assertions.assertTrue((boolean)resolveResult.isLastInternalDirLink());
        InodeTree.ResolveResult resolveResult2 = this.inodeTree.resolve("/a/b/c/d", false);
        Assertions.assertEquals((Object)InodeTree.ResultKind.EXTERNAL_DIR, (Object)resolveResult2.kind);
        Assertions.assertEquals((Object)"/a/b", (Object)resolveResult2.resolvedPath);
        Assertions.assertEquals((Object)new Path("/c/d"), (Object)resolveResult2.remainingPath);
        Assertions.assertTrue((boolean)(resolveResult2.targetFileSystem instanceof TestNestMountPointFileSystem));
        Assertions.assertEquals((Object)NN1_TARGET, (Object)((TestNestMountPointFileSystem)resolveResult2.targetFileSystem).getUri());
        Assertions.assertTrue((boolean)resolveResult2.isLastInternalDirLink());
        InodeTree.ResolveResult resolveResult3 = this.inodeTree.resolve("/a/b/c/d/f/g/h/i", false);
        Assertions.assertEquals((Object)InodeTree.ResultKind.EXTERNAL_DIR, (Object)resolveResult3.kind);
        Assertions.assertEquals((Object)"/a/b/c/d", (Object)resolveResult3.resolvedPath);
        Assertions.assertEquals((Object)new Path("/f/g/h/i"), (Object)resolveResult3.remainingPath);
        Assertions.assertTrue((boolean)(resolveResult3.targetFileSystem instanceof TestNestMountPointFileSystem));
        Assertions.assertEquals((Object)NN3_TARGET, (Object)((TestNestMountPointFileSystem)resolveResult3.targetFileSystem).getUri());
        Assertions.assertTrue((boolean)resolveResult3.isLastInternalDirLink());
    }

    @Test
    public void testMultiNestedMountPointsPathResolveToDirLink() throws Exception {
        InodeTree.ResolveResult resolveResult = this.inodeTree.resolve("/a/b/f", true);
        Assertions.assertEquals((Object)InodeTree.ResultKind.EXTERNAL_DIR, (Object)resolveResult.kind);
        Assertions.assertEquals((Object)"/a/b", (Object)resolveResult.resolvedPath);
        Assertions.assertEquals((Object)new Path("/f"), (Object)resolveResult.remainingPath);
        Assertions.assertTrue((boolean)(resolveResult.targetFileSystem instanceof TestNestMountPointFileSystem));
        Assertions.assertEquals((Object)NN1_TARGET, (Object)((TestNestMountPointFileSystem)resolveResult.targetFileSystem).getUri());
        Assertions.assertTrue((boolean)resolveResult.isLastInternalDirLink());
        InodeTree.ResolveResult resolveResult2 = this.inodeTree.resolve("/a/b", true);
        Assertions.assertEquals((Object)InodeTree.ResultKind.EXTERNAL_DIR, (Object)resolveResult2.kind);
        Assertions.assertEquals((Object)"/a/b", (Object)resolveResult2.resolvedPath);
        Assertions.assertEquals((Object)new Path("/"), (Object)resolveResult2.remainingPath);
        Assertions.assertTrue((boolean)(resolveResult2.targetFileSystem instanceof TestNestMountPointFileSystem));
        Assertions.assertEquals((Object)NN1_TARGET, (Object)((TestNestMountPointFileSystem)resolveResult2.targetFileSystem).getUri());
        Assertions.assertTrue((boolean)resolveResult2.isLastInternalDirLink());
    }

    @Test
    public void testMultiNestedMountPointsPathResolveToDirLinkNotResolveLastComponent() throws Exception {
        InodeTree.ResolveResult resolveResult = this.inodeTree.resolve("/a/b/f", false);
        Assertions.assertEquals((Object)InodeTree.ResultKind.EXTERNAL_DIR, (Object)resolveResult.kind);
        Assertions.assertEquals((Object)"/a/b", (Object)resolveResult.resolvedPath);
        Assertions.assertEquals((Object)new Path("/f"), (Object)resolveResult.remainingPath);
        Assertions.assertTrue((boolean)(resolveResult.targetFileSystem instanceof TestNestMountPointFileSystem));
        Assertions.assertEquals((Object)NN1_TARGET, (Object)((TestNestMountPointFileSystem)resolveResult.targetFileSystem).getUri());
        Assertions.assertTrue((boolean)resolveResult.isLastInternalDirLink());
        InodeTree.ResolveResult resolveResult2 = this.inodeTree.resolve("/a/b", false);
        Assertions.assertEquals((Object)InodeTree.ResultKind.INTERNAL_DIR, (Object)resolveResult2.kind);
        Assertions.assertEquals((Object)"/a", (Object)resolveResult2.resolvedPath);
        Assertions.assertEquals((Object)new Path("/b"), (Object)resolveResult2.remainingPath);
        Assertions.assertTrue((boolean)(resolveResult2.targetFileSystem instanceof TestNestMountPointInternalFileSystem));
        Assertions.assertEquals((Object)this.fsUri, (Object)((TestNestMountPointInternalFileSystem)resolveResult2.targetFileSystem).getUri());
        Assertions.assertFalse((boolean)resolveResult2.isLastInternalDirLink());
    }

    @Test
    public void testPathResolveToDirLinkLastComponentInternalDir() throws Exception {
        InodeTree.ResolveResult resolveResult = this.inodeTree.resolve("/a/b/c", true);
        Assertions.assertEquals((Object)InodeTree.ResultKind.EXTERNAL_DIR, (Object)resolveResult.kind);
        Assertions.assertEquals((Object)"/a/b", (Object)resolveResult.resolvedPath);
        Assertions.assertEquals((Object)new Path("/c"), (Object)resolveResult.remainingPath);
        Assertions.assertTrue((boolean)(resolveResult.targetFileSystem instanceof TestNestMountPointFileSystem));
        Assertions.assertEquals((Object)NN1_TARGET, (Object)((TestNestMountPointFileSystem)resolveResult.targetFileSystem).getUri());
        Assertions.assertTrue((boolean)resolveResult.isLastInternalDirLink());
    }

    @Test
    public void testPathResolveToDirLinkLastComponentInternalDirNotResolveLastComponent() throws Exception {
        InodeTree.ResolveResult resolveResult = this.inodeTree.resolve("/a/b/c", false);
        Assertions.assertEquals((Object)InodeTree.ResultKind.EXTERNAL_DIR, (Object)resolveResult.kind);
        Assertions.assertEquals((Object)"/a/b", (Object)resolveResult.resolvedPath);
        Assertions.assertEquals((Object)new Path("/c"), (Object)resolveResult.remainingPath);
        Assertions.assertTrue((boolean)(resolveResult.targetFileSystem instanceof TestNestMountPointFileSystem));
        Assertions.assertEquals((Object)NN1_TARGET, (Object)((TestNestMountPointFileSystem)resolveResult.targetFileSystem).getUri());
        Assertions.assertTrue((boolean)resolveResult.isLastInternalDirLink());
    }

    @Test
    public void testPathResolveToLinkFallBack() throws Exception {
        InodeTree.ResolveResult resolveResult = this.inodeTree.resolve("/a/e", true);
        Assertions.assertEquals((Object)InodeTree.ResultKind.EXTERNAL_DIR, (Object)resolveResult.kind);
        Assertions.assertEquals((Object)"/", (Object)resolveResult.resolvedPath);
        Assertions.assertEquals((Object)new Path("/a/e"), (Object)resolveResult.remainingPath);
        Assertions.assertTrue((boolean)(resolveResult.targetFileSystem instanceof TestNestMountPointFileSystem));
        Assertions.assertEquals((Object)LINKFALLBACK_TARGET, (Object)((TestNestMountPointFileSystem)resolveResult.targetFileSystem).getUri());
        Assertions.assertFalse((boolean)resolveResult.isLastInternalDirLink());
    }

    @Test
    public void testPathNotResolveToLinkFallBackNotResolveLastComponent() throws Exception {
        InodeTree.ResolveResult resolveResult = this.inodeTree.resolve("/a/e", false);
        Assertions.assertEquals((Object)InodeTree.ResultKind.INTERNAL_DIR, (Object)resolveResult.kind);
        Assertions.assertEquals((Object)"/a", (Object)resolveResult.resolvedPath);
        Assertions.assertEquals((Object)new Path("/e"), (Object)resolveResult.remainingPath);
        Assertions.assertTrue((boolean)(resolveResult.targetFileSystem instanceof TestNestMountPointInternalFileSystem));
        Assertions.assertEquals((Object)this.fsUri, (Object)((TestNestMountPointInternalFileSystem)resolveResult.targetFileSystem).getUri());
        Assertions.assertFalse((boolean)resolveResult.isLastInternalDirLink());
    }

    @Test
    public void testPathResolveToInternalDir() throws Exception {
        InodeTree.ResolveResult resolveResult = this.inodeTree.resolve("/b/c", true);
        Assertions.assertEquals((Object)InodeTree.ResultKind.INTERNAL_DIR, (Object)resolveResult.kind);
        Assertions.assertEquals((Object)"/b/c", (Object)resolveResult.resolvedPath);
        Assertions.assertEquals((Object)new Path("/"), (Object)resolveResult.remainingPath);
        Assertions.assertTrue((boolean)(resolveResult.targetFileSystem instanceof TestNestMountPointInternalFileSystem));
        Assertions.assertEquals((Object)this.fsUri, (Object)((TestNestMountPointInternalFileSystem)resolveResult.targetFileSystem).getUri());
        Assertions.assertFalse((boolean)resolveResult.isLastInternalDirLink());
    }

    @Test
    public void testPathResolveToInternalDirNotResolveLastComponent() throws Exception {
        InodeTree.ResolveResult resolveResult = this.inodeTree.resolve("/b/c", false);
        Assertions.assertEquals((Object)InodeTree.ResultKind.INTERNAL_DIR, (Object)resolveResult.kind);
        Assertions.assertEquals((Object)"/b", (Object)resolveResult.resolvedPath);
        Assertions.assertEquals((Object)new Path("/c"), (Object)resolveResult.remainingPath);
        Assertions.assertTrue((boolean)(resolveResult.targetFileSystem instanceof TestNestMountPointInternalFileSystem));
        Assertions.assertEquals((Object)this.fsUri, (Object)((TestNestMountPointInternalFileSystem)resolveResult.targetFileSystem).getUri());
        Assertions.assertFalse((boolean)resolveResult.isLastInternalDirLink());
    }

    @Test
    public void testSlashResolveToInternalDir() throws Exception {
        InodeTree.ResolveResult resolveResult = this.inodeTree.resolve("/", true);
        Assertions.assertEquals((Object)InodeTree.ResultKind.INTERNAL_DIR, (Object)resolveResult.kind);
        Assertions.assertEquals((Object)"/", (Object)resolveResult.resolvedPath);
        Assertions.assertEquals((Object)new Path("/"), (Object)resolveResult.remainingPath);
        Assertions.assertTrue((boolean)(resolveResult.targetFileSystem instanceof TestNestMountPointInternalFileSystem));
        Assertions.assertFalse((boolean)resolveResult.isLastInternalDirLink());
    }

    @Test
    public void testInodeTreeMountPoints() throws Exception {
        List mountPoints = this.inodeTree.getMountPoints();
        Assertions.assertEquals((int)6, (int)mountPoints.size());
    }

    static class TestNestMountPointFileSystem {
        private URI uri;

        public URI getUri() {
            return this.uri;
        }

        TestNestMountPointFileSystem(URI uri) {
            this.uri = uri;
        }
    }

    static class TestNestMountPointInternalFileSystem
    extends TestNestMountPointFileSystem {
        TestNestMountPointInternalFileSystem(URI uri) {
            super(uri);
        }
    }
}

