/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.viewfs.HCFSMountTableConfigLoader;
import org.apache.hadoop.fs.viewfs.MountTableConfigLoader;
import org.apache.hadoop.fs.viewfs.ViewFsTestSetup;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestHCFSMountTableConfigLoader {
    private static final String DOT = ".";
    private static final String TARGET_TWO = "/tar2";
    private static final String TARGET_ONE = "/tar1";
    private static final String SRC_TWO = "/src2";
    private static final String SRC_ONE = "/src1";
    private static final String TABLE_NAME = "test";
    private MountTableConfigLoader loader = new HCFSMountTableConfigLoader();
    private static FileSystem fsTarget;
    private static Configuration conf;
    private static Path targetTestRoot;
    private static FileSystemTestHelper fileSystemTestHelper;
    private static File oldVersionMountTableFile;
    private static File newVersionMountTableFile;
    private static final String MOUNT_LINK_KEY_SRC_ONE;
    private static final String MOUNT_LINK_KEY_SRC_TWO;

    @BeforeAll
    public static void init() throws Exception {
        fsTarget = new LocalFileSystem();
        fsTarget.initialize(new URI("file:///"), new Configuration());
        targetTestRoot = fileSystemTestHelper.getAbsoluteTestRootPath(fsTarget);
        fsTarget.delete(targetTestRoot, true);
        fsTarget.mkdirs(targetTestRoot);
    }

    @BeforeEach
    public void setUp() throws Exception {
        conf = new Configuration();
        conf.set(String.format("fs.viewfs.overload.scheme.target.%s.impl", "file"), LocalFileSystem.class.getName());
        oldVersionMountTableFile = new File(new URI(targetTestRoot.toString() + "/table.1.xml"));
        oldVersionMountTableFile.createNewFile();
        newVersionMountTableFile = new File(new URI(targetTestRoot.toString() + "/table.2.xml"));
        newVersionMountTableFile.createNewFile();
    }

    @Test
    public void testMountTableFileLoadingWhenMultipleFilesExist() throws Exception {
        ViewFsTestSetup.addMountLinksToFile(TABLE_NAME, new String[]{SRC_ONE, SRC_TWO}, new String[]{TARGET_ONE, TARGET_TWO}, new Path(newVersionMountTableFile.toURI()), conf);
        this.loader.load(targetTestRoot.toString(), conf);
        Assertions.assertEquals((Object)conf.get(MOUNT_LINK_KEY_SRC_TWO), (Object)TARGET_TWO);
        Assertions.assertEquals((Object)conf.get(MOUNT_LINK_KEY_SRC_ONE), (Object)TARGET_ONE);
    }

    @Test
    public void testMountTableFileWithInvalidFormat() throws Exception {
        Path path = new Path(new URI(targetTestRoot.toString() + "/testMountTableFileWithInvalidFormat/"));
        fsTarget.mkdirs(path);
        File invalidMountFileName = new File(new URI(path.toString() + "/table.InvalidVersion.xml"));
        invalidMountFileName.createNewFile();
        ViewFsTestSetup.addMountLinksToFile(TABLE_NAME, new String[]{SRC_ONE, SRC_TWO}, new String[]{TARGET_ONE, TARGET_TWO}, new Path(invalidMountFileName.toURI()), conf);
        this.loader.load(path.toString(), conf);
        Assertions.assertEquals(null, (Object)conf.get(MOUNT_LINK_KEY_SRC_TWO));
        Assertions.assertEquals(null, (Object)conf.get(MOUNT_LINK_KEY_SRC_ONE));
        invalidMountFileName.delete();
    }

    @Test
    public void testMountTableFileWithInvalidFormatWithNoDotsInName() throws Exception {
        Path path = new Path(new URI(targetTestRoot.toString() + "/testMountTableFileWithInvalidFormatWithNoDots/"));
        fsTarget.mkdirs(path);
        File invalidMountFileName = new File(new URI(path.toString() + "/tableInvalidVersionxml"));
        invalidMountFileName.createNewFile();
        this.loader.load(path.toString(), conf);
        Assertions.assertEquals(null, (Object)conf.get(MOUNT_LINK_KEY_SRC_TWO));
        Assertions.assertEquals(null, (Object)conf.get(MOUNT_LINK_KEY_SRC_ONE));
        invalidMountFileName.delete();
    }

    @Test
    public void testLoadWithMountFile() throws Exception {
        Assertions.assertThrows(FileNotFoundException.class, () -> this.loader.load(new URI(targetTestRoot.toString() + "/Non-Existent-File.xml").toString(), conf));
    }

    @Test
    public void testLoadWithNonExistentMountFile() throws Exception {
        ViewFsTestSetup.addMountLinksToFile(TABLE_NAME, new String[]{SRC_ONE, SRC_TWO}, new String[]{TARGET_ONE, TARGET_TWO}, new Path(oldVersionMountTableFile.toURI()), conf);
        this.loader.load(oldVersionMountTableFile.toURI().toString(), conf);
        Assertions.assertEquals((Object)conf.get(MOUNT_LINK_KEY_SRC_TWO), (Object)TARGET_TWO);
        Assertions.assertEquals((Object)conf.get(MOUNT_LINK_KEY_SRC_ONE), (Object)TARGET_ONE);
    }

    @AfterAll
    public static void tearDown() throws IOException {
        fsTarget.delete(targetTestRoot, true);
    }

    static {
        fileSystemTestHelper = new FileSystemTestHelper();
        MOUNT_LINK_KEY_SRC_ONE = "fs.viewfs.mounttable" + DOT + TABLE_NAME + DOT + "link" + DOT + SRC_ONE;
        MOUNT_LINK_KEY_SRC_TWO = "fs.viewfs.mounttable" + DOT + TABLE_NAME + DOT + "link" + DOT + SRC_TWO;
    }
}

