/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.store;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.fs.store.EtagChecksum;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestEtagChecksum
extends Assertions {
    private final EtagChecksum empty1 = this.tag("");
    private final EtagChecksum empty2 = this.tag("");
    private final EtagChecksum valid1 = this.tag("valid");
    private final EtagChecksum valid2 = this.tag("valid");

    @Test
    public void testEmptyTagsEqual() {
        TestEtagChecksum.assertEquals((Object)this.empty1, (Object)this.empty2);
    }

    @Test
    public void testEmptyTagRoundTrip() throws Throwable {
        TestEtagChecksum.assertEquals((Object)this.empty1, (Object)this.roundTrip(this.empty1));
    }

    @Test
    public void testValidTagsEqual() {
        TestEtagChecksum.assertEquals((Object)this.valid1, (Object)this.valid2);
    }

    @Test
    public void testValidTagRoundTrip() throws Throwable {
        TestEtagChecksum.assertEquals((Object)this.valid1, (Object)this.roundTrip(this.valid1));
    }

    @Test
    public void testValidAndEmptyTagsDontMatch() {
        TestEtagChecksum.assertNotEquals((Object)this.valid1, (Object)this.empty1);
        TestEtagChecksum.assertNotEquals((Object)this.valid1, (Object)this.tag("other valid one"));
    }

    @Test
    public void testDifferentTagsDontMatch() {
        TestEtagChecksum.assertNotEquals((Object)this.valid1, (Object)this.tag("other valid one"));
    }

    private EtagChecksum tag(String t) {
        return new EtagChecksum(t);
    }

    private EtagChecksum roundTrip(EtagChecksum tag) throws IOException {
        try (DataOutputBuffer dob = new DataOutputBuffer();){
            EtagChecksum etagChecksum;
            try (DataInputBuffer dib = new DataInputBuffer();){
                tag.write((DataOutput)dob);
                dib.reset(dob.getData(), dob.getLength());
                EtagChecksum t2 = new EtagChecksum();
                t2.readFields((DataInput)dib);
                etagChecksum = t2;
            }
            return etagChecksum;
        }
    }
}

