/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.statistics;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.LongAdder;
import org.apache.hadoop.fs.statistics.IOStatisticAssertions;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsSnapshot;
import org.apache.hadoop.fs.statistics.IOStatisticsSupport;
import org.apache.hadoop.fs.statistics.MeanStatistic;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsBinding;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsStore;
import org.apache.hadoop.test.AbstractHadoopTestBase;
import org.apache.hadoop.util.JsonSerialization;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestIOStatisticsStore
extends AbstractHadoopTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(TestIOStatisticsStore.class);
    private static final String COUNT = "count";
    private static final String GAUGE = "gauge";
    private static final String MIN = "min";
    private static final String MAX = "max";
    private static final String MEAN = "mean";
    public static final String UNKNOWN = "unknown";
    private IOStatisticsStore stats;

    @BeforeEach
    public void setup() {
        this.stats = IOStatisticsBinding.iostatisticsStore().withCounters(new String[]{COUNT}).withGauges(new String[]{GAUGE}).withMinimums(new String[]{MIN}).withMaximums(new String[]{MAX}).withMeanStatistics(new String[]{MEAN}).build();
    }

    @AfterEach
    public void teardown() {
        LOG.info("stats {}", (Object)this.stats);
    }

    @Test
    public void testGauges() throws Throwable {
        this.stats.setGauge(GAUGE, 1L);
        IOStatisticAssertions.verifyStatisticGaugeValue((IOStatistics)this.stats, GAUGE, 1L);
        this.stats.incrementGauge(GAUGE, 1L);
        IOStatisticAssertions.verifyStatisticGaugeValue((IOStatistics)this.stats, GAUGE, 2L);
        this.stats.setGauge(GAUGE, -1L);
        IOStatisticAssertions.verifyStatisticGaugeValue((IOStatistics)this.stats, GAUGE, -1L);
        Assertions.assertThat((long)this.stats.incrementGauge(GAUGE, -1L)).isEqualTo(-2L);
        IOStatisticAssertions.verifyStatisticGaugeValue((IOStatistics)this.stats, GAUGE, -2L);
        Assertions.assertThat((long)this.stats.getGaugeReference(GAUGE).get()).isEqualTo(-2L);
        this.stats.setGauge(UNKNOWN, 1L);
        Assertions.assertThat((long)this.stats.incrementGauge(UNKNOWN, 1L)).isEqualTo(0L);
    }

    @Test
    public void testMinimums() throws Throwable {
        this.stats.setMinimum(MIN, 100L);
        IOStatisticAssertions.verifyStatisticMinimumValue((IOStatistics)this.stats, MIN, 100L);
        this.stats.setMinimum(MIN, 100L);
        this.stats.addMinimumSample(MIN, 200L);
        IOStatisticAssertions.verifyStatisticMinimumValue((IOStatistics)this.stats, MIN, 100L);
        this.stats.addMinimumSample(MIN, 10L);
        IOStatisticAssertions.verifyStatisticMinimumValue((IOStatistics)this.stats, MIN, 10L);
        this.stats.setMinimum(UNKNOWN, 100L);
        this.stats.addMinimumSample(UNKNOWN, 200L);
    }

    @Test
    public void testMaximums() throws Throwable {
        this.stats.setMaximum(MAX, 100L);
        IOStatisticAssertions.verifyStatisticMaximumValue((IOStatistics)this.stats, MAX, 100L);
        this.stats.setMaximum(MAX, 100L);
        this.stats.addMaximumSample(MAX, 200L);
        IOStatisticAssertions.verifyStatisticMaximumValue((IOStatistics)this.stats, MAX, 200L);
        this.stats.addMaximumSample(MAX, 10L);
        IOStatisticAssertions.verifyStatisticMaximumValue((IOStatistics)this.stats, MAX, 200L);
        this.stats.setMaximum(UNKNOWN, 100L);
        this.stats.addMaximumSample(UNKNOWN, 200L);
    }

    @Test
    public void testMeans() throws Throwable {
        this.stats.setMeanStatistic(MEAN, new MeanStatistic(1L, 1L));
        IOStatisticAssertions.assertThatStatisticMeanMatches((IOStatistics)this.stats, MEAN, 1L, 1L).matches(p -> p.mean() == 1.0, MEAN);
        this.stats.addMeanStatisticSample(MEAN, 9L);
        IOStatisticAssertions.assertThatStatisticMeanMatches((IOStatistics)this.stats, MEAN, 2L, 10L).matches(p -> p.mean() == 5.0, MEAN);
    }

    @Test
    public void testRoundTrip() throws Throwable {
        JsonSerialization serializer = IOStatisticsSnapshot.serializer();
        this.stats.incrementCounter(COUNT);
        this.stats.setGauge(GAUGE, -1L);
        this.stats.addMaximumSample(MAX, 200L);
        this.stats.addMinimumSample(MIN, -100L);
        this.stats.addMeanStatisticSample(MEAN, 1L);
        this.stats.addMeanStatisticSample(MEAN, 9L);
        String json = serializer.toJson((Object)IOStatisticsSupport.snapshotIOStatistics((IOStatistics)this.stats));
        LOG.info("serialized form\n{}", (Object)json);
        IOStatisticsSnapshot deser = (IOStatisticsSnapshot)serializer.fromJson(json);
        LOG.info("deserialized {}", (Object)deser);
        IOStatisticAssertions.verifyStatisticCounterValue((IOStatistics)deser, COUNT, 1L);
        IOStatisticAssertions.verifyStatisticGaugeValue((IOStatistics)deser, GAUGE, -1L);
        IOStatisticAssertions.verifyStatisticMaximumValue((IOStatistics)deser, MAX, 200L);
        IOStatisticAssertions.verifyStatisticMinimumValue((IOStatistics)deser, MIN, -100L);
        IOStatisticAssertions.assertThatStatisticMeanMatches((IOStatistics)deser, MEAN, 2L, 10L).matches(p -> p.mean() == 5.0, MEAN);
    }

    @Test
    public void testUnknownCounter() throws Throwable {
        Assertions.assertThat((long)this.stats.incrementCounter(UNKNOWN, -10L)).isEqualTo(0L);
    }

    @Test
    public void testNegativeCounterIncrementIgnored() throws Throwable {
        Assertions.assertThat((long)this.stats.incrementCounter(COUNT, 2L)).isEqualTo(2L);
        Assertions.assertThat((long)this.stats.incrementCounter(COUNT, -10L)).isEqualTo(2L);
    }

    @Test
    public void testForeach() throws Throwable {
        IOStatisticsStore store = IOStatisticsBinding.iostatisticsStore().withCounters(new String[]{COUNT, "c1", "c2"}).withGauges(new String[]{GAUGE}).withMinimums(new String[]{MIN}).withMaximums(new String[]{MAX}).withMeanStatistics(new String[]{MEAN}).build();
        store.setCounter(COUNT, 10L);
        store.setCounter("c1", 1L);
        store.setCounter("c2", 2L);
        Map counters = store.counters();
        LongAdder entryCount = new LongAdder();
        LongAdder sum = new LongAdder();
        counters.forEach((k, v) -> {
            entryCount.increment();
            sum.add((long)v);
        });
        ((AbstractLongAssert)Assertions.assertThat((long)entryCount.longValue()).describedAs("entry count", new Object[0])).isEqualTo(3L);
        ((AbstractLongAssert)Assertions.assertThat((long)sum.longValue()).describedAs("sum of values", new Object[0])).isEqualTo(13L);
        Set keys = counters.keySet();
        ((IterableAssert)((IterableAssert)Assertions.assertThat(keys).describedAs("keys", new Object[0])).hasSize(3)).contains((Object[])new String[]{"c1", "c2", COUNT});
        Collection values = counters.values();
        ((IterableAssert)((IterableAssert)Assertions.assertThat(values).describedAs("values", new Object[0])).hasSize(3)).contains((Object[])new Long[]{10L, 1L, 2L});
        Set entries = counters.entrySet();
        entryCount.reset();
        sum.reset();
        entries.forEach(e -> {
            entryCount.increment();
            sum.add((Long)e.getValue());
        });
    }
}

