/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.statistics;

import org.apache.hadoop.fs.statistics.IOStatisticAssertions;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsLogging;
import org.apache.hadoop.fs.statistics.IOStatisticsSnapshot;
import org.apache.hadoop.fs.statistics.IOStatisticsSource;
import org.apache.hadoop.fs.statistics.IOStatisticsSupport;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsBinding;
import org.apache.hadoop.test.AbstractHadoopTestBase;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.junit.jupiter.api.Test;

public class TestEmptyIOStatistics
extends AbstractHadoopTestBase {
    private final IOStatistics empty = IOStatisticsBinding.emptyStatistics();

    @Test
    public void testUnknownStatistic() throws Throwable {
        IOStatisticAssertions.assertStatisticCounterIsUntracked(this.empty, "anything");
    }

    @Test
    public void testStatisticsTrackedAssertion() throws Throwable {
        Assertions.assertThatThrownBy(() -> IOStatisticAssertions.assertStatisticCounterIsTracked(this.empty, "anything")).isInstanceOf(AssertionError.class);
    }

    @Test
    public void testStatisticsValueAssertion() throws Throwable {
        Assertions.assertThatThrownBy(() -> IOStatisticAssertions.verifyStatisticCounterValue(this.empty, "anything", 0L)).isInstanceOf(AssertionError.class);
    }

    @Test
    public void testEmptySnapshot() throws Throwable {
        IOStatisticsSnapshot stat = IOStatisticsSupport.snapshotIOStatistics((IOStatistics)this.empty);
        ((IterableAssert)Assertions.assertThat(stat.counters().keySet()).describedAs("keys of snapshot", new Object[0])).isEmpty();
        IOStatistics deser = IOStatisticAssertions.statisticsJavaRoundTrip((IOStatistics)stat);
        ((IterableAssert)Assertions.assertThat(deser.counters().keySet()).describedAs("keys of deserialized snapshot", new Object[0])).isEmpty();
    }

    @Test
    public void testStringification() throws Throwable {
        Assertions.assertThat((String)IOStatisticsLogging.ioStatisticsToString((IOStatistics)this.empty)).isNotBlank();
    }

    @Test
    public void testWrap() throws Throwable {
        IOStatisticsSource statisticsSource = IOStatisticsBinding.wrap((IOStatistics)this.empty);
        Assertions.assertThat((Object)statisticsSource.getIOStatistics()).isSameAs((Object)this.empty);
    }

    @Test
    public void testStringifyNullSource() throws Throwable {
        Assertions.assertThat((String)IOStatisticsLogging.ioStatisticsSourceToString(null)).isEmpty();
    }

    @Test
    public void testStringifyNullStats() throws Throwable {
        Assertions.assertThat((String)IOStatisticsLogging.ioStatisticsSourceToString((Object)IOStatisticsBinding.wrap(null))).isEmpty();
    }

    @Test
    public void testStringificationNull() throws Throwable {
        ((AbstractStringAssert)Assertions.assertThat((String)IOStatisticsLogging.ioStatisticsToString(null)).describedAs("Null statistics should stringify to \"\"", new Object[0])).isEmpty();
    }
}

