/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell.find;

import org.apache.hadoop.fs.shell.find.Result;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=10L)
public class TestResult {
    @Test
    public void testPass() {
        Result result = Result.PASS;
        Assertions.assertTrue((boolean)result.isPass());
        Assertions.assertTrue((boolean)result.isDescend());
    }

    @Test
    public void testFail() {
        Result result = Result.FAIL;
        Assertions.assertFalse((boolean)result.isPass());
        Assertions.assertTrue((boolean)result.isDescend());
    }

    @Test
    public void testStop() {
        Result result = Result.STOP;
        Assertions.assertTrue((boolean)result.isPass());
        Assertions.assertFalse((boolean)result.isDescend());
    }

    @Test
    public void combinePassPass() {
        Result result = Result.PASS.combine(Result.PASS);
        Assertions.assertTrue((boolean)result.isPass());
        Assertions.assertTrue((boolean)result.isDescend());
    }

    @Test
    public void combinePassFail() {
        Result result = Result.PASS.combine(Result.FAIL);
        Assertions.assertFalse((boolean)result.isPass());
        Assertions.assertTrue((boolean)result.isDescend());
    }

    @Test
    public void combineFailPass() {
        Result result = Result.FAIL.combine(Result.PASS);
        Assertions.assertFalse((boolean)result.isPass());
        Assertions.assertTrue((boolean)result.isDescend());
    }

    @Test
    public void combineFailFail() {
        Result result = Result.FAIL.combine(Result.FAIL);
        Assertions.assertFalse((boolean)result.isPass());
        Assertions.assertTrue((boolean)result.isDescend());
    }

    @Test
    public void combinePassStop() {
        Result result = Result.PASS.combine(Result.STOP);
        Assertions.assertTrue((boolean)result.isPass());
        Assertions.assertFalse((boolean)result.isDescend());
    }

    @Test
    public void combineStopFail() {
        Result result = Result.STOP.combine(Result.FAIL);
        Assertions.assertFalse((boolean)result.isPass());
        Assertions.assertFalse((boolean)result.isDescend());
    }

    @Test
    public void combineStopPass() {
        Result result = Result.STOP.combine(Result.PASS);
        Assertions.assertTrue((boolean)result.isPass());
        Assertions.assertFalse((boolean)result.isDescend());
    }

    @Test
    public void combineFailStop() {
        Result result = Result.FAIL.combine(Result.STOP);
        Assertions.assertFalse((boolean)result.isPass());
        Assertions.assertFalse((boolean)result.isDescend());
    }

    @Test
    public void negatePass() {
        Result result = Result.PASS.negate();
        Assertions.assertFalse((boolean)result.isPass());
        Assertions.assertTrue((boolean)result.isDescend());
    }

    @Test
    public void negateFail() {
        Result result = Result.FAIL.negate();
        Assertions.assertTrue((boolean)result.isPass());
        Assertions.assertTrue((boolean)result.isDescend());
    }

    @Test
    public void negateStop() {
        Result result = Result.STOP.negate();
        Assertions.assertFalse((boolean)result.isPass());
        Assertions.assertFalse((boolean)result.isDescend());
    }

    @Test
    public void equalsPass() {
        Result one = Result.PASS;
        Result two = Result.PASS.combine(Result.PASS);
        Assertions.assertEquals((Object)one, (Object)two);
    }

    @Test
    public void equalsFail() {
        Result one = Result.FAIL;
        Result two = Result.FAIL.combine(Result.FAIL);
        Assertions.assertEquals((Object)one, (Object)two);
    }

    @Test
    public void equalsStop() {
        Result one = Result.STOP;
        Result two = Result.STOP.combine(Result.STOP);
        Assertions.assertEquals((Object)one, (Object)two);
    }

    @Test
    public void notEquals() {
        Assertions.assertFalse((boolean)Result.PASS.equals((Object)Result.FAIL));
        Assertions.assertFalse((boolean)Result.PASS.equals((Object)Result.STOP));
        Assertions.assertFalse((boolean)Result.FAIL.equals((Object)Result.PASS));
        Assertions.assertFalse((boolean)Result.FAIL.equals((Object)Result.STOP));
        Assertions.assertFalse((boolean)Result.STOP.equals((Object)Result.PASS));
        Assertions.assertFalse((boolean)Result.STOP.equals((Object)Result.FAIL));
    }
}

