/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.IOException;
import java.net.URI;
import java.util.LinkedList;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.shell.CopyCommandWithMultiThread;
import org.apache.hadoop.fs.shell.CopyCommands;
import org.apache.hadoop.fs.shell.PathData;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestCopyToLocal {
    private static final String FROM_DIR_NAME = "fromDir";
    private static final String TO_DIR_NAME = "toDir";
    private static FileSystem fs;
    private static Path testDir;
    private static Configuration conf;
    private Path dir = null;
    private int numFiles = 0;

    private static int initialize(Path dir) throws Exception {
        fs.mkdirs(dir);
        Path fromDirPath = new Path(dir, FROM_DIR_NAME);
        fs.mkdirs(fromDirPath);
        Path toDirPath = new Path(dir, TO_DIR_NAME);
        fs.mkdirs(toDirPath);
        int numTotalFiles = 0;
        int numDirs = RandomUtils.nextInt((int)0, (int)5);
        for (int dirCount = 0; dirCount < numDirs; ++dirCount) {
            Path subDirPath = new Path(fromDirPath, "subdir" + dirCount);
            fs.mkdirs(subDirPath);
            int numFiles = RandomUtils.nextInt((int)0, (int)10);
            for (int fileCount = 0; fileCount < numFiles; ++fileCount) {
                ++numTotalFiles;
                Path subFile = new Path(subDirPath, "file" + fileCount);
                fs.createNewFile(subFile);
                FSDataOutputStream output = fs.create(subFile, true);
                for (int i = 0; i < 100; ++i) {
                    output.writeInt(i);
                    output.writeChar(10);
                }
                output.close();
            }
        }
        return numTotalFiles;
    }

    @BeforeAll
    public static void init() throws Exception {
        conf = new Configuration(false);
        conf.set("fs.file.impl", LocalFileSystem.class.getName());
        fs = FileSystem.getLocal((Configuration)conf);
        testDir = new FileSystemTestHelper().getTestRootPath(fs);
        testDir = new Path(fs.makeQualified(testDir).toUri().getPath());
        FileSystem.setDefaultUri((Configuration)conf, (URI)fs.getUri());
        fs.setWorkingDirectory(testDir);
    }

    @AfterAll
    public static void cleanup() throws Exception {
        fs.delete(testDir, true);
        fs.close();
    }

    private void run(CopyCommandWithMultiThread cmd, String ... args) {
        cmd.setConf(conf);
        Assertions.assertEquals((int)0, (int)cmd.run(args));
    }

    @BeforeEach
    public void initDirectory() throws Exception {
        this.dir = new Path("dir" + RandomStringUtils.randomNumeric((int)4));
        this.numFiles = TestCopyToLocal.initialize(this.dir);
    }

    @Test
    @Timeout(value=10L)
    public void testCopy() throws Exception {
        MultiThreadedCopy copy = new MultiThreadedCopy(1, 1024, 0);
        this.run((CopyCommandWithMultiThread)copy, new Path(this.dir, FROM_DIR_NAME).toString(), new Path(this.dir, TO_DIR_NAME).toString());
        assert (copy.getExecutor() == null);
    }

    @Test
    @Timeout(value=10L)
    public void testCopyWithThreads() {
        this.run((CopyCommandWithMultiThread)new MultiThreadedCopy(5, 1024, this.numFiles), "-t", "5", new Path(this.dir, FROM_DIR_NAME).toString(), new Path(this.dir, TO_DIR_NAME).toString());
    }

    @Test
    @Timeout(value=10L)
    public void testCopyWithThreadWrong() {
        this.run((CopyCommandWithMultiThread)new MultiThreadedCopy(1, 1024, 0), "-t", "0", new Path(this.dir, FROM_DIR_NAME).toString(), new Path(this.dir, TO_DIR_NAME).toString());
    }

    @Test
    @Timeout(value=10L)
    public void testCopyWithThreadsAndQueueSize() {
        int queueSize = 256;
        this.run((CopyCommandWithMultiThread)new MultiThreadedCopy(5, queueSize, this.numFiles), "-t", "5", "-q", Integer.toString(queueSize), new Path(this.dir, FROM_DIR_NAME).toString(), new Path(this.dir, TO_DIR_NAME).toString());
    }

    @Test
    @Timeout(value=10L)
    public void testCopyWithThreadsAndQueueSizeWrong() {
        int queueSize = 0;
        this.run((CopyCommandWithMultiThread)new MultiThreadedCopy(5, 1024, this.numFiles), "-t", "5", "-q", Integer.toString(queueSize), new Path(this.dir, FROM_DIR_NAME).toString(), new Path(this.dir, TO_DIR_NAME).toString());
    }

    @Test
    @Timeout(value=10L)
    public void testCopySingleFile() throws Exception {
        Path fromDirPath = new Path(this.dir, FROM_DIR_NAME);
        Path subFile = new Path(fromDirPath, "file0");
        fs.createNewFile(subFile);
        FSDataOutputStream output = fs.create(subFile, true);
        for (int i = 0; i < 100; ++i) {
            output.writeInt(i);
            output.writeChar(10);
        }
        output.close();
        MultiThreadedCopy copy = new MultiThreadedCopy(5, 1024, 0);
        this.run((CopyCommandWithMultiThread)copy, "-t", "5", subFile.toString(), new Path(this.dir, TO_DIR_NAME).toString());
        assert (copy.getExecutor() == null);
    }

    private static class MultiThreadedCopy
    extends CopyCommands.CopyToLocal {
        public static final String NAME = "multiThreadCopy";
        private final int expectedThreads;
        private final int expectedQueuePoolSize;
        private final int expectedCompletedTaskCount;

        MultiThreadedCopy(int expectedThreads, int expectedQueuePoolSize, int expectedCompletedTaskCount) {
            this.expectedThreads = expectedThreads;
            this.expectedQueuePoolSize = expectedQueuePoolSize;
            this.expectedCompletedTaskCount = expectedCompletedTaskCount;
        }

        protected void processArguments(LinkedList<PathData> args) throws IOException {
            Assertions.assertEquals((int)this.expectedThreads, (int)this.getThreadCount());
            Assertions.assertEquals((int)this.expectedQueuePoolSize, (int)this.getThreadPoolQueueSize());
            super.processArguments(args);
            if (this.isMultiThreadNecessary(args)) {
                ThreadPoolExecutor executor = this.getExecutor();
                Assertions.assertEquals((long)this.expectedCompletedTaskCount, (long)executor.getCompletedTaskCount());
                Assertions.assertEquals((int)0, (int)executor.getActiveCount());
                Assertions.assertTrue((boolean)executor.isTerminated());
            } else assert (this.getExecutor() == null);
        }
    }
}

