/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.shell.CommandWithDestination;
import org.apache.hadoop.fs.shell.CopyCommands;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestCopyPreserveFlag {
    private static final int MODIFICATION_TIME = 12345000;
    private static final int ACCESS_TIME = 23456000;
    private static final Path DIR_FROM = new Path("d0");
    private static final Path DIR_FROM_SPL = new Path("d0 space");
    private static final Path DIR_TO1 = new Path("d1");
    private static final Path DIR_TO2 = new Path("d2");
    private static final Path FROM = new Path(DIR_FROM, "f0");
    private static final Path FROM_SPL = new Path(DIR_FROM_SPL, "f0");
    private static final Path TO = new Path(DIR_TO1, "f1");
    private static final FsPermission PERMISSIONS = new FsPermission(FsAction.ALL, FsAction.EXECUTE, FsAction.READ_WRITE);
    private FileSystem fs;
    private Path testDir;
    private Configuration conf;

    @BeforeEach
    public void initialize() throws Exception {
        this.conf = new Configuration(false);
        this.conf.set("fs.file.impl", LocalFileSystem.class.getName());
        this.fs = FileSystem.getLocal((Configuration)this.conf);
        this.testDir = new FileSystemTestHelper().getTestRootPath(this.fs);
        this.testDir = new Path(this.fs.makeQualified(this.testDir).toUri().getPath());
        FileSystem.setDefaultUri((Configuration)this.conf, (URI)this.fs.getUri());
        this.fs.setWorkingDirectory(this.testDir);
        this.fs.mkdirs(DIR_FROM);
        this.fs.mkdirs(DIR_TO1);
        this.fs.createNewFile(FROM);
        FSDataOutputStream output = this.fs.create(FROM, true);
        for (int i = 0; i < 100; ++i) {
            output.writeInt(i);
            output.writeChar(10);
        }
        output.close();
        this.fs.setPermission(FROM, PERMISSIONS);
        this.fs.setTimes(FROM, 12345000L, 23456000L);
        this.fs.setPermission(DIR_FROM, PERMISSIONS);
        this.fs.setTimes(DIR_FROM, 12345000L, 23456000L);
    }

    @AfterEach
    public void cleanup() throws Exception {
        this.fs.delete(this.testDir, true);
        this.fs.close();
    }

    private void assertAttributesPreserved(Path to) throws IOException {
        FileStatus status = this.fs.getFileStatus(to);
        Assertions.assertEquals((long)12345000L, (long)status.getModificationTime());
        Assertions.assertEquals((long)23456000L, (long)status.getAccessTime());
        Assertions.assertEquals((Object)PERMISSIONS, (Object)status.getPermission());
    }

    private void assertAttributesChanged(Path to) throws IOException {
        FileStatus status = this.fs.getFileStatus(to);
        Assertions.assertNotEquals((long)12345000L, (long)status.getModificationTime());
        Assertions.assertNotEquals((long)23456000L, (long)status.getAccessTime());
        Assertions.assertNotEquals((Object)PERMISSIONS, (Object)status.getPermission());
    }

    private void run(CommandWithDestination cmd, String ... args) {
        cmd.setConf(this.conf);
        Assertions.assertEquals((int)0, (int)cmd.run(args));
    }

    @Test
    @Timeout(value=10L)
    public void testPutWithP() throws Exception {
        this.run((CommandWithDestination)new CopyCommands.Put(), "-p", FROM.toString(), TO.toString());
        this.assertAttributesPreserved(TO);
    }

    @Test
    @Timeout(value=10L)
    public void testPutWithoutP() throws Exception {
        this.run((CommandWithDestination)new CopyCommands.Put(), FROM.toString(), TO.toString());
        this.assertAttributesChanged(TO);
    }

    @Test
    @Timeout(value=10L)
    public void testPutWithPQ() throws Exception {
        CopyCommands.Put put = new CopyCommands.Put();
        this.run((CommandWithDestination)put, "-p", "-q", "100", FROM.toString(), TO.toString());
        Assertions.assertEquals((int)put.getThreadPoolQueueSize(), (int)100);
        this.assertAttributesPreserved(TO);
    }

    @Test
    @Timeout(value=10L)
    public void testPutWithQ() throws Exception {
        CopyCommands.Put put = new CopyCommands.Put();
        this.run((CommandWithDestination)put, "-q", "100", FROM.toString(), TO.toString());
        Assertions.assertEquals((int)put.getThreadPoolQueueSize(), (int)100);
        this.assertAttributesChanged(TO);
    }

    @Test
    @Timeout(value=10L)
    public void testPutWithSplCharacter() throws Exception {
        this.fs.mkdirs(DIR_FROM_SPL);
        this.fs.createNewFile(FROM_SPL);
        this.run((CommandWithDestination)new CopyCommands.Put(), FROM_SPL.toString(), TO.toString());
        this.assertAttributesChanged(TO);
    }

    @Test
    @Timeout(value=10L)
    public void testCopyFromLocal() throws Exception {
        this.run((CommandWithDestination)new CopyCommands.CopyFromLocal(), FROM.toString(), TO.toString());
        this.assertAttributesChanged(TO);
    }

    @Test
    @Timeout(value=10L)
    public void testCopyFromLocalWithThreads() throws Exception {
        this.run((CommandWithDestination)new CopyCommands.CopyFromLocal(), "-t", "10", FROM.toString(), TO.toString());
        this.assertAttributesChanged(TO);
    }

    @Test
    @Timeout(value=10L)
    public void testCopyFromLocalWithThreadsPreserve() throws Exception {
        this.run((CommandWithDestination)new CopyCommands.CopyFromLocal(), "-p", "-t", "10", FROM.toString(), TO.toString());
        this.assertAttributesPreserved(TO);
    }

    @Test
    @Timeout(value=10L)
    public void testGetWithP() throws Exception {
        this.run((CommandWithDestination)new CopyCommands.Get(), "-p", FROM.toString(), TO.toString());
        this.assertAttributesPreserved(TO);
    }

    @Test
    @Timeout(value=10L)
    public void testGetWithoutP() throws Exception {
        this.run((CommandWithDestination)new CopyCommands.Get(), FROM.toString(), TO.toString());
        this.assertAttributesChanged(TO);
    }

    @Test
    @Timeout(value=10L)
    public void testGetWithPQ() throws Exception {
        CopyCommands.Get get = new CopyCommands.Get();
        this.run((CommandWithDestination)get, "-p", "-q", "100", FROM.toString(), TO.toString());
        Assertions.assertEquals((int)get.getThreadPoolQueueSize(), (int)100);
        this.assertAttributesPreserved(TO);
    }

    @Test
    @Timeout(value=10L)
    public void testGetWithQ() throws Exception {
        CopyCommands.Get get = new CopyCommands.Get();
        this.run((CommandWithDestination)get, "-q", "100", FROM.toString(), TO.toString());
        Assertions.assertEquals((int)get.getThreadPoolQueueSize(), (int)100);
        this.assertAttributesChanged(TO);
    }

    @Test
    @Timeout(value=10L)
    public void testGetWithThreads() throws Exception {
        this.run((CommandWithDestination)new CopyCommands.Get(), "-t", "10", FROM.toString(), TO.toString());
        this.assertAttributesChanged(TO);
    }

    @Test
    @Timeout(value=10L)
    public void testGetWithThreadsPreserve() throws Exception {
        this.run((CommandWithDestination)new CopyCommands.Get(), "-p", "-t", "10", FROM.toString(), TO.toString());
        this.assertAttributesPreserved(TO);
    }

    @Test
    @Timeout(value=10L)
    public void testCpWithP() throws Exception {
        this.run((CommandWithDestination)new CopyCommands.Cp(), "-p", FROM.toString(), TO.toString());
        this.assertAttributesPreserved(TO);
    }

    @Test
    @Timeout(value=10L)
    public void testCpWithoutP() throws Exception {
        this.run((CommandWithDestination)new CopyCommands.Cp(), FROM.toString(), TO.toString());
        this.assertAttributesChanged(TO);
    }

    @Test
    @Timeout(value=10L)
    public void testDirectoryCpWithP() throws Exception {
        this.run((CommandWithDestination)new CopyCommands.Cp(), "-p", DIR_FROM.toString(), DIR_TO2.toString());
        this.assertAttributesPreserved(DIR_TO2);
    }

    @Test
    @Timeout(value=10L)
    public void testDirectoryCpWithoutP() throws Exception {
        this.run((CommandWithDestination)new CopyCommands.Cp(), DIR_FROM.toString(), DIR_TO2.toString());
        this.assertAttributesChanged(DIR_TO2);
    }
}

