/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.protocolPB;

import java.io.DataInput;
import java.io.DataOutput;
import org.apache.hadoop.fs.FSProtos;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.protocolPB.PBHelper;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestFSSerialization {
    @Test
    public void testWritableFlagSerialization() throws Exception {
        Path p = new Path("hdfs://yaks:4344/dingos/f");
        for (int i = 0; i < 8; ++i) {
            boolean acl = 0 != (i & 1);
            boolean crypt = 0 != (i & 2);
            boolean ec = 0 != (i & 4);
            FileStatus stat = new FileStatus(1024L, false, 3, 0x80000000L, 12345678L, 87654321L, FsPermission.getFileDefault(), "hadoop", "unqbbc", null, p, acl, crypt, ec);
            DataOutputBuffer dob = new DataOutputBuffer();
            stat.write((DataOutput)dob);
            DataInputBuffer dib = new DataInputBuffer();
            dib.reset(dob.getData(), 0, dob.getLength());
            FileStatus fstat = new FileStatus();
            fstat.readFields((DataInput)dib);
            Assertions.assertEquals((Object)stat, (Object)fstat);
            TestFSSerialization.checkFields(stat, fstat);
        }
    }

    @Test
    public void testUtilitySerialization() throws Exception {
        Path p = new Path("hdfs://yaks:4344/dingos/f");
        FileStatus stat = new FileStatus(1024L, false, 3, 0x80000000L, 12345678L, 87654321L, FsPermission.createImmutable((short)73), "hadoop", "unqbbc", null, p);
        FSProtos.FileStatusProto fsp = PBHelper.convert((FileStatus)stat);
        FileStatus stat2 = PBHelper.convert((FSProtos.FileStatusProto)fsp);
        Assertions.assertEquals((Object)stat, (Object)stat2);
        TestFSSerialization.checkFields(stat, stat2);
    }

    private static void checkFields(FileStatus expected, FileStatus actual) {
        Assertions.assertEquals((Object)expected.getPath(), (Object)actual.getPath());
        Assertions.assertEquals((Object)expected.isDirectory(), (Object)actual.isDirectory());
        Assertions.assertEquals((long)expected.getLen(), (long)actual.getLen());
        Assertions.assertEquals((Object)expected.getPermission(), (Object)actual.getPermission());
        Assertions.assertEquals((Object)expected.getOwner(), (Object)actual.getOwner());
        Assertions.assertEquals((Object)expected.getGroup(), (Object)actual.getGroup());
        Assertions.assertEquals((long)expected.getModificationTime(), (long)actual.getModificationTime());
        Assertions.assertEquals((long)expected.getAccessTime(), (long)actual.getAccessTime());
        Assertions.assertEquals((short)expected.getReplication(), (short)actual.getReplication());
        Assertions.assertEquals((long)expected.getBlockSize(), (long)actual.getBlockSize());
        Assertions.assertEquals((Object)expected.hasAcl(), (Object)actual.hasAcl());
        Assertions.assertEquals((Object)expected.isEncrypted(), (Object)actual.isEncrypted());
        Assertions.assertEquals((Object)expected.isErasureCoded(), (Object)actual.isErasureCoded());
    }
}

