/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.impl.prefetch;

import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.apache.hadoop.fs.impl.prefetch.BufferData;
import org.apache.hadoop.fs.impl.prefetch.ExceptionAsserts;
import org.apache.hadoop.test.AbstractHadoopTestBase;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestBufferData
extends AbstractHadoopTestBase {
    static final List<BufferData.State> ALL_STATES = Arrays.asList(BufferData.State.UNKNOWN, BufferData.State.BLANK, BufferData.State.PREFETCHING, BufferData.State.CACHING, BufferData.State.READY);

    @Test
    public void testArgChecks() throws Exception {
        ByteBuffer buffer = ByteBuffer.allocate(1);
        BufferData data = new BufferData(1, buffer);
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'blockNumber' must not be negative", () -> new BufferData(-1, buffer));
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'buffer' must not be null", () -> new BufferData(1, null));
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'actionFuture' must not be null", () -> data.setPrefetch(null));
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'actionFuture' must not be null", () -> data.setCaching(null));
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'states' must not be null", () -> data.throwIfStateIncorrect((BufferData.State[])null));
        LambdaTestUtils.intercept(IllegalStateException.class, "Expected buffer state to be 'READY or CACHING' but found", () -> data.throwIfStateIncorrect(new BufferData.State[]{BufferData.State.READY, BufferData.State.CACHING}));
    }

    @Test
    public void testValidStateUpdates() {
        ByteBuffer buffer = ByteBuffer.allocate(1);
        BufferData data = new BufferData(1, buffer);
        Assertions.assertEquals((Object)BufferData.State.BLANK, (Object)data.getState());
        CompletableFuture<Object> actionFuture = new CompletableFuture<Object>();
        actionFuture.complete(null);
        data.setPrefetch(actionFuture);
        Assertions.assertEquals((Object)BufferData.State.PREFETCHING, (Object)data.getState());
        Assertions.assertNotNull((Object)data.getActionFuture());
        Assertions.assertSame(actionFuture, (Object)data.getActionFuture());
        CompletableFuture actionFuture2 = new CompletableFuture();
        data.setCaching(actionFuture2);
        Assertions.assertEquals((Object)BufferData.State.CACHING, (Object)data.getState());
        Assertions.assertNotNull((Object)data.getActionFuture());
        Assertions.assertSame(actionFuture2, (Object)data.getActionFuture());
        Assertions.assertNotSame(actionFuture, actionFuture2);
        List<BufferData.State> states = Arrays.asList(BufferData.State.BLANK, BufferData.State.PREFETCHING, BufferData.State.CACHING, BufferData.State.READY);
        BufferData data2 = new BufferData(1, buffer);
        BufferData.State prevState = null;
        for (BufferData.State state : states) {
            if (prevState != null) {
                Assertions.assertEquals((Object)prevState, (Object)data2.getState());
                data2.updateState(state, new BufferData.State[]{prevState});
                Assertions.assertEquals((Object)state, (Object)data2.getState());
            }
            prevState = state;
        }
    }

    @Test
    public void testInvalidStateUpdates() throws Exception {
        CompletableFuture<Object> actionFuture = new CompletableFuture<Object>();
        actionFuture.complete(null);
        this.testInvalidStateUpdatesHelper(d -> d.setPrefetch((Future)actionFuture), BufferData.State.BLANK, BufferData.State.READY);
        this.testInvalidStateUpdatesHelper(d -> d.setCaching((Future)actionFuture), BufferData.State.PREFETCHING, BufferData.State.READY);
    }

    @Test
    public void testSetReady() throws Exception {
        byte[] bytes1 = new byte[5];
        this.initBytes(bytes1);
        ByteBuffer buffer = ByteBuffer.allocate(10);
        buffer.put(bytes1);
        buffer.limit(bytes1.length);
        BufferData data = new BufferData(1, buffer);
        Assertions.assertNotEquals((Object)BufferData.State.READY, (Object)data.getState());
        Assertions.assertEquals((long)0L, (long)data.getChecksum());
        data.setReady(new BufferData.State[]{BufferData.State.BLANK});
        Assertions.assertEquals((Object)BufferData.State.READY, (Object)data.getState());
        Assertions.assertNotEquals((long)0L, (long)data.getChecksum());
        ExceptionAsserts.assertThrows(ReadOnlyBufferException.class, null, () -> data.getBuffer().put(bytes1));
        ExceptionAsserts.assertThrows(IllegalStateException.class, "Checksum cannot be changed once set", () -> data.setReady(new BufferData.State[]{BufferData.State.BLANK}));
        buffer.array()[2] = 42;
        ExceptionAsserts.assertThrows(IllegalStateException.class, "checksum changed after setReady()", () -> data.setDone());
    }

    @Test
    public void testChecksum() {
        byte[] bytes1 = new byte[5];
        byte[] bytes2 = new byte[10];
        this.initBytes(bytes1);
        this.initBytes(bytes2);
        ByteBuffer buffer1 = ByteBuffer.wrap(bytes1);
        ByteBuffer buffer2 = ByteBuffer.wrap(bytes2);
        buffer2.limit(bytes1.length);
        long checksum1 = BufferData.getChecksum((ByteBuffer)buffer1);
        long checksum2 = BufferData.getChecksum((ByteBuffer)buffer2);
        Assertions.assertEquals((long)checksum1, (long)checksum2);
    }

    private void initBytes(byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)i;
        }
    }

    private void testInvalidStateUpdatesHelper(StateChanger changeState, BufferData.State ... validFromState) throws Exception {
        ByteBuffer buffer = ByteBuffer.allocate(1);
        BufferData data = new BufferData(1, buffer);
        data.updateState(validFromState[0], new BufferData.State[]{BufferData.State.BLANK});
        List<BufferData.State> states = this.getStatesExcept(validFromState);
        BufferData.State prevState = validFromState[0];
        String expectedMessage = String.format("Expected buffer state to be '%s", validFromState[0]);
        for (BufferData.State s : states) {
            data.updateState(s, new BufferData.State[]{prevState});
            ExceptionAsserts.assertThrows(IllegalStateException.class, expectedMessage, () -> changeState.run(data));
            Assertions.assertEquals((Object)s, (Object)data.getState());
            prevState = s;
        }
    }

    private List<BufferData.State> getStatesExcept(BufferData.State ... states) {
        ArrayList<BufferData.State> result = new ArrayList<BufferData.State>();
        for (BufferData.State s : ALL_STATES) {
            boolean found = false;
            for (BufferData.State ss : states) {
                if (s != ss) continue;
                found = true;
            }
            if (found) continue;
            result.add(s);
        }
        return result;
    }

    @FunctionalInterface
    public static interface StateChanger {
        public void run(BufferData var1) throws Exception;
    }
}

