/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.contract.localfs;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.contract.AbstractContractCreateTest;
import org.apache.hadoop.fs.contract.AbstractFSContract;
import org.apache.hadoop.fs.contract.localfs.LocalFSContract;
import org.junit.jupiter.api.Test;

public class TestLocalFSContractCreate
extends AbstractContractCreateTest {
    @Override
    protected AbstractFSContract createContract(Configuration conf) {
        return new LocalFSContract(conf);
    }

    @Test
    public void testSyncablePassthroughIfChecksumDisabled() throws Throwable {
        this.describe("Create an instance of the local fs, disable the checksum and verify that Syncable now works");
        LocalFileSystem fs = (LocalFileSystem)this.getFileSystem();
        try (LocalFileSystem lfs = new LocalFileSystem(fs.getRawFileSystem());){
            lfs.setWriteChecksum(false);
            this.validateSyncableSemantics((FileSystem)lfs, true, true, true);
        }
    }
}

