/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.contract;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.hadoop.fs.BBUploadHandle;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.MultipartUploader;
import org.apache.hadoop.fs.PartHandle;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathHandle;
import org.apache.hadoop.fs.UploadHandle;
import org.apache.hadoop.fs.contract.AbstractFSContractTestBase;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.fs.statistics.IOStatisticsLogging;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.util.DurationInfo;
import org.apache.hadoop.util.functional.FutureIO;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractByteArrayAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractContractMultipartUploaderTest
extends AbstractFSContractTestBase {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractContractMultipartUploaderTest.class);
    protected static final int SMALL_FILE = 100;
    protected static final int CONSISTENCY_INTERVAL = 1000;
    private MultipartUploader uploader0;
    private MultipartUploader uploader1;
    private final Random random = new Random();
    private UploadHandle activeUpload;
    private Path activeUploadPath;

    @Override
    @BeforeEach
    public void setup() throws Exception {
        super.setup();
        FileSystem fs = this.getFileSystem();
        Path testPath = this.getContract().getTestPath();
        Assumptions.assumeTrue((boolean)fs.hasPathCapability(testPath, "fs.capability.multipart.uploader"), (String)"Multipart uploader is not supported");
        this.uploader0 = fs.createMultipartUploader(testPath).build();
        this.uploader1 = fs.createMultipartUploader(testPath).build();
    }

    @Override
    @AfterEach
    public void teardown() throws Exception {
        MultipartUploader uploader = this.getUploader(1);
        if (uploader != null) {
            if (this.activeUpload != null) {
                this.abortUploadQuietly(this.activeUpload, this.activeUploadPath);
            }
            try {
                Path teardown = this.getContract().getTestPath();
                LOG.info("Teardown: aborting outstanding uploads under {}", (Object)teardown);
                CompletableFuture f = uploader.abortUploadsUnderPath(teardown);
                f.get();
                LOG.info("Statistics {}", (Object)IOStatisticsLogging.ioStatisticsSourceToString((Object)uploader));
            }
            catch (Exception e) {
                LOG.warn("Exeception in teardown", (Throwable)e);
            }
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.uploader0, this.uploader1});
        super.teardown();
    }

    @Override
    protected Path methodPath() throws IOException {
        return this.path(this.getMethodName());
    }

    private byte[] generatePayload(int partNumber) {
        return this.generatePayload(partNumber, this.partSizeInBytes());
    }

    private byte[] generatePayload(int partNumber, int size) {
        ByteBuffer buffer = ByteBuffer.allocate(size);
        for (int i = 0; i < size / 4; ++i) {
            buffer.putInt(partNumber);
        }
        return buffer.array();
    }

    /*
     * Loose catch block
     */
    protected byte[] digest(Path path) throws IOException {
        byte[] byArray;
        FSDataInputStream in;
        ContractTestUtils.NanoTimer timer;
        block8: {
            byte[] digest;
            timer = new ContractTestUtils.NanoTimer();
            in = this.getFileSystem().open(path);
            byte[] fdData = org.apache.commons.io.IOUtils.toByteArray((InputStream)in);
            MessageDigest newDigest = DigestUtils.getMd5Digest();
            byArray = digest = newDigest.digest(fdData);
            if (in == null) break block8;
            in.close();
        }
        timer.end("Download and digest of path %s", path);
        return byArray;
        {
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    timer.end("Download and digest of path %s", path);
                    throw throwable3;
                }
            }
        }
    }

    protected abstract int partSizeInBytes();

    protected int getTestPayloadCount() {
        return 10;
    }

    protected int timeToBecomeConsistentMillis() {
        return 0;
    }

    protected abstract boolean finalizeConsumesUploadIdImmediately();

    protected abstract boolean supportsConcurrentUploadsToSamePath();

    protected MultipartUploader getUploader(int index) {
        return index % 2 == 0 ? this.uploader0 : this.uploader1;
    }

    protected MultipartUploader getRandomUploader() {
        return this.getUploader(this.random.nextInt(10));
    }

    @Test
    public void testSingleUpload() throws Exception {
        Path file = this.methodPath();
        UploadHandle uploadHandle = this.startUpload(file);
        HashMap<Integer, PartHandle> partHandles = new HashMap<Integer, PartHandle>();
        MessageDigest origDigest = DigestUtils.getMd5Digest();
        int size = 100;
        byte[] payload = this.generatePayload(1, size);
        origDigest.update(payload);
        MultipartUploader completer = this.uploader0;
        PartHandle partHandle = this.putPart(file, uploadHandle, 1, true, payload);
        partHandles.put(1, partHandle);
        PathHandle fd = this.complete(completer, uploadHandle, file, partHandles);
        this.validateUpload(file, origDigest, size);
        if (this.finalizeConsumesUploadIdImmediately()) {
            LambdaTestUtils.intercept(FileNotFoundException.class, () -> this.complete(completer, uploadHandle, file, partHandles));
        } else {
            PathHandle fd2 = this.complete(completer, uploadHandle, file, partHandles);
            AbstractContractMultipartUploaderTest.assertArrayEquals((byte[])fd.toByteArray(), (byte[])fd2.toByteArray(), (String)"Path handles differ");
        }
    }

    protected PathHandle complete(MultipartUploader uploader, UploadHandle uploadHandle, Path file, Map<Integer, PartHandle> partHandles) throws IOException {
        try (DurationInfo d = new DurationInfo(LOG, "Complete upload to %s", new Object[]{file});){
            PathHandle pathHandle = (PathHandle)FutureIO.awaitFuture((Future)uploader.complete(uploadHandle, file, partHandles));
            return pathHandle;
        }
    }

    protected UploadHandle startUpload(Path dest) throws IOException {
        this.activeUploadPath = dest;
        this.activeUpload = (UploadHandle)FutureIO.awaitFuture((Future)this.getRandomUploader().startUpload(dest));
        return this.activeUpload;
    }

    protected PartHandle buildAndPutPart(Path file, UploadHandle uploadHandle, int index, boolean isLastPart, MessageDigest origDigest) throws IOException {
        byte[] payload = this.generatePayload(index);
        if (origDigest != null) {
            origDigest.update(payload);
        }
        return this.putPart(file, uploadHandle, index, isLastPart, payload);
    }

    protected PartHandle putPart(Path file, UploadHandle uploadHandle, int index, boolean isLastPart, byte[] payload) throws IOException {
        PartHandle partHandle;
        ContractTestUtils.NanoTimer timer = new ContractTestUtils.NanoTimer();
        try (DurationInfo d = new DurationInfo(LOG, "Put part %d (size %s) %s", new Object[]{index, payload.length, file});){
            partHandle = (PartHandle)FutureIO.awaitFuture((Future)this.getUploader(index).putPart(uploadHandle, index, isLastPart, file, (InputStream)new ByteArrayInputStream(payload), (long)payload.length));
        }
        timer.end("Uploaded part %s", index);
        LOG.info("Upload bandwidth {} MB/s", (Object)timer.bandwidthDescription(payload.length));
        return partHandle;
    }

    private PathHandle completeUpload(Path file, UploadHandle uploadHandle, Map<Integer, PartHandle> partHandles, MessageDigest origDigest, int expectedLength) throws IOException {
        PathHandle fd = this.complete(file, uploadHandle, partHandles);
        this.validateUpload(file, origDigest, expectedLength);
        return fd;
    }

    private void validateUpload(Path file, MessageDigest origDigest, int expectedLength) throws IOException {
        ContractTestUtils.verifyPathExists(this.getFileSystem(), "Completed file", file);
        this.verifyFileLength(file, expectedLength);
        if (origDigest != null) {
            this.verifyContents(file, origDigest, expectedLength);
        }
    }

    protected void verifyContents(Path file, MessageDigest origDigest, int expectedLength) throws IOException {
        ContractTestUtils.NanoTimer timer2 = new ContractTestUtils.NanoTimer();
        ((AbstractByteArrayAssert)Assertions.assertThat((byte[])this.digest(file)).describedAs("digest of uploaded file %s", new Object[]{file})).isEqualTo((Object)origDigest.digest());
        timer2.end("Completed digest", file);
        LOG.info("Download bandwidth {} MB/s", (Object)timer2.bandwidthDescription(expectedLength));
    }

    private void verifyFileLength(Path file, long expectedLength) throws IOException {
        FileStatus st = this.getFileSystem().getFileStatus(file);
        ((AbstractComparableAssert)((AbstractComparableAssert)Assertions.assertThat((Comparable)st).describedAs("Uploaded file %s", new Object[]{st})).matches(FileStatus::isFile)).extracting(FileStatus::getLen).isEqualTo((Object)expectedLength);
    }

    private PathHandle complete(Path file, UploadHandle uploadHandle, Map<Integer, PartHandle> partHandles) throws IOException {
        return this.complete(this.getRandomUploader(), uploadHandle, file, partHandles);
    }

    private void abortUpload(UploadHandle uploadHandle, Path file) throws IOException {
        try (DurationInfo d = new DurationInfo(LOG, "Abort upload to %s", new Object[]{file});){
            FutureIO.awaitFuture((Future)this.getRandomUploader().abort(uploadHandle, file));
        }
    }

    private void abortUploadQuietly(UploadHandle uploadHandle, Path file) {
        try {
            this.abortUpload(uploadHandle, file);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception e) {
            LOG.info("aborting {}: {}", (Object)file, (Object)e.toString());
        }
    }

    @Test
    public void testMultipartUpload() throws Exception {
        Path file = this.methodPath();
        UploadHandle uploadHandle = this.startUpload(file);
        HashMap<Integer, PartHandle> partHandles = new HashMap<Integer, PartHandle>();
        MessageDigest origDigest = DigestUtils.getMd5Digest();
        int payloadCount = this.getTestPayloadCount();
        for (int i = 1; i <= payloadCount; ++i) {
            PartHandle partHandle = this.buildAndPutPart(file, uploadHandle, i, i == payloadCount, origDigest);
            partHandles.put(i, partHandle);
        }
        this.completeUpload(file, uploadHandle, partHandles, origDigest, payloadCount * this.partSizeInBytes());
    }

    @Test
    public void testMultipartUploadEmptyPart() throws Exception {
        FileSystem fs = this.getFileSystem();
        Path file = this.path("testMultipartUploadEmptyPart");
        try (MultipartUploader uploader = fs.createMultipartUploader(file).build();){
            UploadHandle uploadHandle = (UploadHandle)uploader.startUpload(file).get();
            HashMap<Integer, PartHandle> partHandles = new HashMap<Integer, PartHandle>();
            MessageDigest origDigest = DigestUtils.getMd5Digest();
            byte[] payload = new byte[]{};
            origDigest.update(payload);
            ByteArrayInputStream is = new ByteArrayInputStream(payload);
            PartHandle partHandle = (PartHandle)FutureIO.awaitFuture((Future)uploader.putPart(uploadHandle, 1, true, file, (InputStream)is, (long)payload.length));
            partHandles.put(1, partHandle);
            this.completeUpload(file, uploadHandle, partHandles, origDigest, 0);
        }
    }

    @Test
    public void testUploadEmptyBlock() throws Exception {
        Path file = this.methodPath();
        UploadHandle uploadHandle = this.startUpload(file);
        HashMap<Integer, PartHandle> partHandles = new HashMap<Integer, PartHandle>();
        partHandles.put(1, this.putPart(file, uploadHandle, 1, true, new byte[0]));
        this.completeUpload(file, uploadHandle, partHandles, null, 0);
    }

    @Test
    public void testMultipartUploadReverseOrder() throws Exception {
        int i;
        Path file = this.methodPath();
        UploadHandle uploadHandle = this.startUpload(file);
        HashMap<Integer, PartHandle> partHandles = new HashMap<Integer, PartHandle>();
        MessageDigest origDigest = DigestUtils.getMd5Digest();
        int payloadCount = this.getTestPayloadCount();
        for (i = 1; i <= payloadCount; ++i) {
            byte[] payload = this.generatePayload(i);
            origDigest.update(payload);
        }
        for (i = payloadCount; i > 0; --i) {
            partHandles.put(i, this.buildAndPutPart(file, uploadHandle, i, i == payloadCount, null));
        }
        this.completeUpload(file, uploadHandle, partHandles, origDigest, payloadCount * this.partSizeInBytes());
    }

    @Test
    public void testMultipartUploadReverseOrderNonContiguousPartNumbers() throws Exception {
        this.describe("Upload in reverse order and the part numbers are not contiguous");
        Path file = this.methodPath();
        UploadHandle uploadHandle = this.startUpload(file);
        MessageDigest origDigest = DigestUtils.getMd5Digest();
        int payloadCount = 2 * this.getTestPayloadCount();
        for (int i = 2; i <= payloadCount; i += 2) {
            byte[] payload = this.generatePayload(i);
            origDigest.update(payload);
        }
        HashMap<Integer, PartHandle> partHandles = new HashMap<Integer, PartHandle>();
        for (int i = payloadCount; i > 0; i -= 2) {
            partHandles.put(i, this.buildAndPutPart(file, uploadHandle, i, i == payloadCount, null));
        }
        this.completeUpload(file, uploadHandle, partHandles, origDigest, this.getTestPayloadCount() * this.partSizeInBytes());
    }

    @Test
    public void testMultipartUploadAbort() throws Exception {
        this.describe("Upload and then abort it before completing");
        Path file = this.methodPath();
        UploadHandle uploadHandle = this.startUpload(file);
        HashMap<Integer, PartHandle> partHandles = new HashMap<Integer, PartHandle>();
        for (int i = 12; i > 10; --i) {
            partHandles.put(i, this.buildAndPutPart(file, uploadHandle, i, i == 12, null));
        }
        this.abortUpload(uploadHandle, file);
        String contents = "ThisIsPart49\n";
        int len = contents.getBytes(StandardCharsets.UTF_8).length;
        InputStream is = org.apache.commons.io.IOUtils.toInputStream((String)contents, (Charset)StandardCharsets.UTF_8);
        LambdaTestUtils.intercept(IOException.class, () -> (PartHandle)FutureIO.awaitFuture((Future)this.uploader0.putPart(uploadHandle, 49, true, file, is, (long)len)));
        LambdaTestUtils.intercept(IOException.class, () -> this.complete(this.uploader0, uploadHandle, file, partHandles));
        this.assertPathDoesNotExist("Uploaded file should not exist", file);
        if (this.finalizeConsumesUploadIdImmediately()) {
            LambdaTestUtils.intercept(FileNotFoundException.class, () -> this.abortUpload(uploadHandle, file));
        } else {
            this.abortUpload(uploadHandle, file);
        }
    }

    @Test
    public void testAbortUnknownUpload() throws Exception {
        Path file = this.methodPath();
        ByteBuffer byteBuffer = ByteBuffer.wrap("invalid-handle".getBytes(StandardCharsets.UTF_8));
        LambdaTestUtils.intercept(FileNotFoundException.class, () -> this.abortUpload(BBUploadHandle.from((ByteBuffer)byteBuffer), file));
    }

    @Test
    public void testAbortEmptyUpload() throws Exception {
        this.describe("initialize upload and abort before uploading data");
        Path file = this.methodPath();
        this.abortUpload(this.startUpload(file), file);
        this.assertPathDoesNotExist("Uploaded file should not exist", file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAbortAllPendingUploads() throws Exception {
        this.describe("initialize upload and abort the pending upload");
        Path path = this.methodPath();
        Path file = new Path(path, "child");
        UploadHandle upload = this.startUpload(file);
        try {
            CompletableFuture oF = this.getRandomUploader().abortUploadsUnderPath(path.getParent());
            int abortedUploads = (Integer)FutureIO.awaitFuture((Future)oF);
            if (abortedUploads >= 0) {
                ((AbstractIntegerAssert)Assertions.assertThat((int)abortedUploads).describedAs("Number of uploads aborted", new Object[0])).isGreaterThanOrEqualTo(1);
                this.assertPathDoesNotExist("Uploaded file should not exist", file);
            }
        }
        finally {
            this.abortUploadQuietly(upload, file);
        }
    }

    @Test
    public void testAbortEmptyUploadHandle() throws Exception {
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[0]);
        LambdaTestUtils.intercept(IllegalArgumentException.class, () -> this.abortUpload(BBUploadHandle.from((ByteBuffer)byteBuffer), this.methodPath()));
    }

    @Test
    public void testCompleteEmptyUpload() throws Exception {
        this.describe("Expect an empty MPU to fail, but still be abortable");
        Path dest = this.methodPath();
        UploadHandle handle = this.startUpload(dest);
        LambdaTestUtils.intercept(IllegalArgumentException.class, () -> this.complete(this.uploader0, handle, dest, new HashMap<Integer, PartHandle>()));
        this.abortUpload(handle, dest);
    }

    @Test
    public void testPutPartEmptyUploadID() throws Exception {
        this.describe("Expect IllegalArgumentException when putPart uploadID is empty");
        Path dest = this.methodPath();
        UploadHandle emptyHandle = BBUploadHandle.from((ByteBuffer)ByteBuffer.wrap(new byte[0]));
        byte[] payload = this.generatePayload(1);
        ByteArrayInputStream is = new ByteArrayInputStream(payload);
        LambdaTestUtils.intercept(IllegalArgumentException.class, () -> this.uploader0.putPart(emptyHandle, 1, true, dest, is, (long)payload.length));
    }

    @Test
    public void testCompleteEmptyUploadID() throws Exception {
        this.describe("Expect IllegalArgumentException when complete uploadID is empty");
        Path dest = this.methodPath();
        UploadHandle realHandle = this.startUpload(dest);
        UploadHandle emptyHandle = BBUploadHandle.from((ByteBuffer)ByteBuffer.wrap(new byte[0]));
        HashMap<Integer, PartHandle> partHandles = new HashMap<Integer, PartHandle>();
        PartHandle partHandle = this.putPart(dest, realHandle, 1, true, this.generatePayload(1, 100));
        partHandles.put(1, partHandle);
        LambdaTestUtils.intercept(IllegalArgumentException.class, () -> this.complete(this.uploader0, emptyHandle, dest, partHandles));
        partHandles.clear();
        partHandles.put(0, partHandle);
        LambdaTestUtils.intercept(IllegalArgumentException.class, () -> this.complete(this.uploader0, realHandle, dest, partHandles));
    }

    @Test
    public void testDirectoryInTheWay() throws Exception {
        FileSystem fs = this.getFileSystem();
        Path file = this.methodPath();
        UploadHandle uploadHandle = this.startUpload(file);
        HashMap<Integer, PartHandle> partHandles = new HashMap<Integer, PartHandle>();
        int size = 100;
        PartHandle partHandle = this.putPart(file, uploadHandle, 1, true, this.generatePayload(1, size));
        partHandles.put(1, partHandle);
        fs.mkdirs(file);
        LambdaTestUtils.intercept(IOException.class, () -> this.completeUpload(file, uploadHandle, partHandles, null, size));
        this.abortUpload(uploadHandle, file);
    }

    @Test
    public void testConcurrentUploads() throws Throwable {
        UploadHandle upload2;
        boolean concurrent = this.supportsConcurrentUploadsToSamePath();
        this.describe("testing concurrent uploads, MPU support for this is " + concurrent);
        Path file = this.methodPath();
        int size1 = 100;
        int partId1 = 1;
        byte[] payload1 = this.generatePayload(partId1, size1);
        MessageDigest digest1 = DigestUtils.getMd5Digest();
        digest1.update(payload1);
        UploadHandle upload1 = this.startUpload(file);
        HashMap<Integer, PartHandle> partHandles1 = new HashMap<Integer, PartHandle>();
        int size2 = size1 * 2;
        int partId2 = 2;
        byte[] payload2 = this.generatePayload(partId1, size2);
        MessageDigest digest2 = DigestUtils.getMd5Digest();
        digest2.update(payload2);
        try {
            upload2 = this.startUpload(file);
            Assumptions.assumeTrue((boolean)concurrent, (String)"The Filesystem is unexpectedly supporting concurrent uploads");
        }
        catch (IOException e) {
            if (!concurrent) {
                LOG.debug("Expected exception raised on concurrent uploads", (Throwable)e);
                return;
            }
            throw e;
        }
        HashMap<Integer, PartHandle> partHandles2 = new HashMap<Integer, PartHandle>();
        AbstractContractMultipartUploaderTest.assertNotEquals((Object)upload1, (Object)upload2, (String)"Upload handles match");
        partHandles1.put(partId1, this.putPart(file, upload1, partId1, false, payload1));
        partHandles2.put(partId2, this.putPart(file, upload2, partId2, true, payload2));
        this.completeUpload(file, upload1, partHandles1, digest1, size1);
        this.complete(file, upload2, partHandles2);
        int consistencyDelay = this.timeToBecomeConsistentMillis();
        if (consistencyDelay > 0) {
            LambdaTestUtils.eventually(consistencyDelay, () -> this.verifyFileLength(file, size2), (Callable<Integer>)new LambdaTestUtils.ProportionalRetryInterval(1000, consistencyDelay));
        }
        this.verifyContents(file, digest2, size2);
    }

    @Test
    public void testPathCapabilities() throws Throwable {
        FileSystem fs = this.getFileSystem();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.hasPathCapability(this.getContract().getTestPath(), "fs.capability.multipart.uploader")).describedAs("fs %s, lacks multipart upload capability", new Object[]{fs})).isTrue();
    }
}

