/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.contract;

import java.io.IOException;
import java.lang.invoke.StringConcatFactory;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.contract.AbstractFSContractTestBase;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.junit.jupiter.api.Test;

public abstract class AbstractContractMkdirTest
extends AbstractFSContractTestBase {
    public static final String MKDIRS_NOT_FAILED_OVER_FILE = "mkdirs did not fail over a file but returned ";

    @Test
    public void testMkDirRmDir() throws Throwable {
        FileSystem fs = this.getFileSystem();
        Path dir = this.path("testMkDirRmDir");
        this.assertPathDoesNotExist("directory already exists", dir);
        fs.mkdirs(dir);
        this.assertPathExists("mkdir failed", dir);
        this.assertDeleted(dir, false);
    }

    @Test
    public void testMkDirRmRfDir() throws Throwable {
        this.describe("create a directory then recursive delete it");
        FileSystem fs = this.getFileSystem();
        Path dir = this.path("testMkDirRmRfDir");
        this.assertPathDoesNotExist("directory already exists", dir);
        fs.mkdirs(dir);
        this.assertPathExists("mkdir failed", dir);
        this.assertDeleted(dir, true);
    }

    @Test
    public void testNoMkdirOverFile() throws Throwable {
        this.describe("try to mkdir over a file");
        FileSystem fs = this.getFileSystem();
        Path path = this.path("testNoMkdirOverFile");
        byte[] dataset = ContractTestUtils.dataset(1024, 32, 122);
        ContractTestUtils.createFile(this.getFileSystem(), path, false, dataset);
        try {
            boolean made = fs.mkdirs(path);
            AbstractContractMkdirTest.fail((String)(MKDIRS_NOT_FAILED_OVER_FILE + made + "; " + this.ls(path)));
        }
        catch (FileAlreadyExistsException | ParentNotDirectoryException e) {
            this.handleExpectedException((Exception)e);
        }
        catch (IOException e) {
            this.handleRelaxedException("mkdirs", "FileAlreadyExistsException", e);
        }
        this.assertIsFile(path);
        byte[] bytes = ContractTestUtils.readDataset(this.getFileSystem(), path, dataset.length);
        ContractTestUtils.compareByteArrays(dataset, bytes, dataset.length);
        this.assertPathExists("mkdir failed", path);
        this.assertDeleted(path, true);
    }

    @Test
    public void testMkdirOverParentFile() throws Throwable {
        this.describe("try to mkdir where a parent is a file");
        FileSystem fs = this.getFileSystem();
        Path path = this.path("testMkdirOverParentFile");
        byte[] dataset = ContractTestUtils.dataset(1024, 32, 122);
        ContractTestUtils.createFile(this.getFileSystem(), path, false, dataset);
        Path child = new Path(path, "child-to-mkdir");
        try {
            boolean made = fs.mkdirs(child);
            AbstractContractMkdirTest.fail((String)(MKDIRS_NOT_FAILED_OVER_FILE + made + "; " + this.ls(path)));
        }
        catch (FileAlreadyExistsException | ParentNotDirectoryException e) {
            this.handleExpectedException((Exception)e);
        }
        catch (IOException e) {
            this.handleRelaxedException("mkdirs", "ParentNotDirectoryException", e);
        }
        this.assertIsFile(path);
        byte[] bytes = ContractTestUtils.readDataset(this.getFileSystem(), path, dataset.length);
        ContractTestUtils.compareByteArrays(dataset, bytes, dataset.length);
        this.assertPathExists("mkdir failed", path);
        this.assertDeleted(path, true);
    }

    @Test
    public void testMkdirSlashHandling() throws Throwable {
        Path[] paths;
        this.describe("verify mkdir slash handling");
        FileSystem fs = this.getFileSystem();
        for (Path path : paths = new Path[]{this.path("testMkdirSlashHandling/a"), this.path("testMkdirSlashHandling/b/"), new Path(this.getContract().getTestPath() + "/testMkdirSlashHandling/c"), new Path(this.getContract().getTestPath() + "/testMkdirSlashHandling/d/"), new Path(this.getContract().getTestPath() + "/testMkdirSlashHandling/e///")}) {
            AbstractContractMkdirTest.assertTrue((boolean)fs.mkdirs(path));
            this.assertPathExists(path + " does not exist after mkdirs", path);
            this.assertIsDirectory(path);
            if (!path.toString().endsWith("/")) continue;
            String s = path.toString().substring(0, path.toString().length() - 1);
            this.assertIsDirectory(new Path(s));
        }
    }

    @Test
    public void testMkdirsPopulatingAllNonexistentAncestors() throws IOException {
        Path nested;
        this.describe("Verify mkdir will populate all its non-existent ancestors");
        FileSystem fs = this.getFileSystem();
        Path parent = this.path("testMkdirsPopulatingAllNonexistentAncestors");
        AbstractContractMkdirTest.assertTrue((boolean)fs.mkdirs(parent));
        this.assertPathExists(parent + " should exist before making nested dir", parent);
        AbstractContractMkdirTest.assertTrue((boolean)fs.mkdirs(nested));
        for (nested = this.path((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001/a/b/c/d/e/f/g/h/i/j/k/L"}, (Path)parent))); nested != null && !nested.equals((Object)parent) && !nested.isRoot(); nested = nested.getParent()) {
            this.assertPathExists(nested + " nested dir should exist", nested);
        }
    }

    @Test
    public void testMkdirsDoesNotRemoveParentDirectories() throws IOException {
        this.describe("Verify mkdir will make its parent existent");
        FileSystem fs = this.getFileSystem();
        Path parent = this.path("testMkdirsDoesNotRemoveParentDirectories");
        AbstractContractMkdirTest.assertTrue((boolean)fs.mkdirs(parent));
        Path p = parent;
        for (int i = 0; i < 10; ++i) {
            AbstractContractMkdirTest.assertTrue((boolean)fs.mkdirs(p));
            this.assertPathExists(p + " should exist after mkdir(" + p + ")", p);
            p = this.path(p + "/dir-" + i);
        }
        for (p = p.getParent(); p != null && !p.equals((Object)parent) && !p.isRoot(); p = p.getParent()) {
            this.assertPathExists("Path " + p + " should exist", p);
            this.assertIsDirectory(p);
        }
    }

    @Test
    public void testCreateDirWithExistingDir() throws Exception {
        Path path = this.path("testCreateDirWithExistingDir");
        FileSystem fs = this.getFileSystem();
        ContractTestUtils.assertMkdirs(fs, path);
        ContractTestUtils.assertMkdirs(fs, path);
    }
}

