/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.contract;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LeaseRecoverable;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.contract.AbstractFSContractTestBase;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

public abstract class AbstractContractLeaseRecoveryTest
extends AbstractFSContractTestBase {
    @Test
    public void testLeaseRecovery() throws Throwable {
        Path path = this.methodPath();
        FileSystem fs = this.getFileSystem();
        ContractTestUtils.touch(fs, path);
        LeaseRecoverable leaseRecoverableFs = this.verifyAndGetLeaseRecoverableInstance(fs, path);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)leaseRecoverableFs.recoverLease(path)).describedAs("Issuing lease recovery on a closed file must be successful", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)leaseRecoverableFs.isFileClosed(path)).describedAs("Get the isFileClose status on a closed file must be successful", new Object[0])).isTrue();
    }

    @Test
    public void testLeaseRecoveryFileNotExist() throws Throwable {
        Path path = new Path("notExist");
        FileSystem fs = this.getFileSystem();
        LeaseRecoverable leaseRecoverableFs = this.verifyAndGetLeaseRecoverableInstance(fs, path);
        LambdaTestUtils.intercept(FileNotFoundException.class, "File does not exist", () -> leaseRecoverableFs.recoverLease(path));
        LambdaTestUtils.intercept(FileNotFoundException.class, "File does not exist", () -> leaseRecoverableFs.isFileClosed(path));
    }

    @Test
    public void testLeaseRecoveryFileOnDirectory() throws Throwable {
        Path path = this.methodPath();
        FileSystem fs = this.getFileSystem();
        LeaseRecoverable leaseRecoverableFs = this.verifyAndGetLeaseRecoverableInstance(fs, path);
        Path parentDirectory = path.getParent();
        LambdaTestUtils.intercept(FileNotFoundException.class, "Path is not a file", () -> leaseRecoverableFs.recoverLease(parentDirectory));
        LambdaTestUtils.intercept(FileNotFoundException.class, "Path is not a file", () -> leaseRecoverableFs.isFileClosed(parentDirectory));
    }

    private LeaseRecoverable verifyAndGetLeaseRecoverableInstance(FileSystem fs, Path path) throws IOException {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.hasPathCapability(path, "fs.capability.lease.recoverable")).describedAs("path capability %s of %s", new Object[]{"fs.capability.lease.recoverable", path})).isTrue();
        ((ObjectAssert)Assertions.assertThat((Object)fs).describedAs("filesystem %s", new Object[]{fs})).isInstanceOf(LeaseRecoverable.class);
        return (LeaseRecoverable)fs;
    }
}

