/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.audit;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.hadoop.fs.audit.CommonAuditContext;
import org.apache.hadoop.test.AbstractHadoopTestBase;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCommonAuditContext
extends AbstractHadoopTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(TestCommonAuditContext.class);
    private final CommonAuditContext context = CommonAuditContext.currentAuditContext();

    @Test
    public void testGlobalSetGetEnum() throws Throwable {
        String s = "command";
        CommonAuditContext.setGlobalContextEntry((String)"cm", (String)s);
        this.assertGlobalEntry("cm").isEqualTo((Object)s);
        List list = StreamSupport.stream(CommonAuditContext.getGlobalContextEntries().spliterator(), false).filter(e -> ((String)e.getKey()).equals("cm")).collect(Collectors.toList());
        ((ListAssert)Assertions.assertThat(list).hasSize(1)).allMatch(e -> ((String)e.getValue()).equals(s));
    }

    @Test
    public void testVerifyProcessID() throws Throwable {
        ((AbstractStringAssert)Assertions.assertThat((String)CommonAuditContext.getGlobalContextEntry((String)"ps")).describedAs("global context value of %s", new Object[]{"ps"})).isEqualTo((Object)CommonAuditContext.PROCESS_ID);
    }

    @Test
    public void testNullValue() throws Throwable {
        ((AbstractStringAssert)Assertions.assertThat((String)this.context.get("ps")).describedAs("Value of context element %s", new Object[]{"ps"})).isNull();
    }

    @Test
    public void testThreadId() throws Throwable {
        String t1 = this.getContextValue("t1");
        Long tid = Long.valueOf(t1);
        ((AbstractLongAssert)Assertions.assertThat((Long)tid).describedAs("thread ID", new Object[0])).isEqualTo(Thread.currentThread().getId());
    }

    @Test
    public void testDynamicEval() throws Throwable {
        this.context.reset();
        AtomicBoolean ab = new AtomicBoolean(false);
        this.context.put("key", () -> Boolean.toString(ab.get()));
        this.assertContextValue("key").isEqualTo((Object)"false");
        ab.set(true);
        this.assertContextValue("key").isEqualTo((Object)"true");
    }

    private String getContextValue(String key) {
        String val = this.context.get(key);
        Assertions.assertThat((String)val).isNotBlank();
        return val;
    }

    private AbstractStringAssert<?> assertContextValue(String key) {
        String val = this.context.get(key);
        return (AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)val).describedAs("Value of context element %s", new Object[]{key})).isNotBlank();
    }

    private void assertContextValueIsNull(String key) {
        ((AbstractStringAssert)Assertions.assertThat((String)this.context.get(key)).describedAs("Value of context element %s", new Object[]{key})).isNull();
    }

    @Test
    public void testNoteEntryPoint() throws Throwable {
        this.setAndAssertEntryPoint(this).isEqualTo((Object)"TestCommonAuditContext");
    }

    @Test
    public void testNoteNullEntryPoint() throws Throwable {
        this.setAndAssertEntryPoint(null).isNull();
    }

    private AbstractStringAssert<?> setAndAssertEntryPoint(Object tool) {
        CommonAuditContext.removeGlobalContextEntry((String)"cm");
        CommonAuditContext.noteEntryPoint((Object)tool);
        AbstractStringAssert<?> anAssert = this.assertGlobalEntry("cm");
        return anAssert;
    }

    private AbstractStringAssert<?> assertGlobalEntry(String key) {
        AbstractStringAssert anAssert = (AbstractStringAssert)Assertions.assertThat((String)CommonAuditContext.getGlobalContextEntry((String)key)).describedAs("Global context value %s", new Object[]{key});
        return anAssert;
    }

    @Test
    public void testAddRemove() throws Throwable {
        String key = "testAddRemove";
        this.assertContextValueIsNull("testAddRemove");
        this.context.put("testAddRemove", "testAddRemove");
        this.assertContextValue("testAddRemove").isEqualTo((Object)"testAddRemove");
        this.context.remove("testAddRemove");
        this.assertContextValueIsNull("testAddRemove");
    }
}

