/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import org.apache.hadoop.fs.QuotaUsage;
import org.apache.hadoop.fs.StorageType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestQuotaUsage {
    @Test
    public void testConstructorEmpty() {
        QuotaUsage quotaUsage = new QuotaUsage.Builder().build();
        Assertions.assertEquals((long)-1L, (long)quotaUsage.getQuota(), (String)"getQuota");
        Assertions.assertEquals((long)0L, (long)quotaUsage.getSpaceConsumed(), (String)"getSpaceConsumed");
        Assertions.assertEquals((long)-1L, (long)quotaUsage.getSpaceQuota(), (String)"getSpaceQuota");
    }

    @Test
    public void testConstructorWithQuota() {
        long fileAndDirCount = 22222L;
        long quota = 44444L;
        long spaceConsumed = 55555L;
        long spaceQuota = 66666L;
        QuotaUsage quotaUsage = new QuotaUsage.Builder().fileAndDirectoryCount(fileAndDirCount).quota(quota).spaceConsumed(spaceConsumed).spaceQuota(spaceQuota).build();
        Assertions.assertEquals((long)fileAndDirCount, (long)quotaUsage.getFileAndDirectoryCount(), (String)"getFileAndDirectoryCount");
        Assertions.assertEquals((long)quota, (long)quotaUsage.getQuota(), (String)"getQuota");
        Assertions.assertEquals((long)spaceConsumed, (long)quotaUsage.getSpaceConsumed(), (String)"getSpaceConsumed");
        Assertions.assertEquals((long)spaceQuota, (long)quotaUsage.getSpaceQuota(), (String)"getSpaceQuota");
    }

    @Test
    public void testConstructorNoQuota() {
        long spaceConsumed = 11111L;
        long fileAndDirCount = 22222L;
        QuotaUsage quotaUsage = new QuotaUsage.Builder().fileAndDirectoryCount(fileAndDirCount).spaceConsumed(spaceConsumed).build();
        Assertions.assertEquals((long)fileAndDirCount, (long)quotaUsage.getFileAndDirectoryCount(), (String)"getFileAndDirectoryCount");
        Assertions.assertEquals((long)-1L, (long)quotaUsage.getQuota(), (String)"getQuota");
        Assertions.assertEquals((long)spaceConsumed, (long)quotaUsage.getSpaceConsumed(), (String)"getSpaceConsumed");
        Assertions.assertEquals((long)-1L, (long)quotaUsage.getSpaceQuota(), (String)"getSpaceQuota");
    }

    @Test
    public void testGetHeader() {
        String header = "       QUOTA       REM_QUOTA     SPACE_QUOTA REM_SPACE_QUOTA ";
        Assertions.assertEquals((Object)header, (Object)QuotaUsage.getHeader());
    }

    @Test
    public void testToStringWithQuota() {
        long fileAndDirCount = 55555L;
        long quota = 44444L;
        long spaceConsumed = 55555L;
        long spaceQuota = 66665L;
        QuotaUsage quotaUsage = new QuotaUsage.Builder().fileAndDirectoryCount(fileAndDirCount).quota(quota).spaceConsumed(spaceConsumed).spaceQuota(spaceQuota).build();
        String expected = "       44444          -11111           66665           11110 ";
        Assertions.assertEquals((Object)expected, (Object)quotaUsage.toString());
    }

    @Test
    public void testToStringNoQuota() {
        QuotaUsage quotaUsage = new QuotaUsage.Builder().fileAndDirectoryCount(1234L).build();
        String expected = "        none             inf            none             inf ";
        Assertions.assertEquals((Object)expected, (Object)quotaUsage.toString());
    }

    @Test
    public void testToStringHumanWithQuota() {
        long fileAndDirCount = 222255555L;
        long quota = 222256578L;
        long spaceConsumed = 0x40000001L;
        long spaceQuota = 1L;
        QuotaUsage quotaUsage = new QuotaUsage.Builder().fileAndDirectoryCount(fileAndDirCount).quota(quota).spaceConsumed(spaceConsumed).spaceQuota(spaceQuota).build();
        String expected = "     212.0 M            1023               1            -1 G ";
        Assertions.assertEquals((Object)expected, (Object)quotaUsage.toString(true));
    }

    @Test
    public void testCompareQuotaUsage() {
        long fileAndDirCount = 222255555L;
        long quota = 222256578L;
        long spaceConsumed = 0x40000001L;
        long spaceQuota = 1L;
        long SSDspaceConsumed = 100000L;
        long SSDQuota = 300000L;
        QuotaUsage quotaUsage1 = new QuotaUsage.Builder().fileAndDirectoryCount(fileAndDirCount).quota(quota).spaceConsumed(spaceConsumed).spaceQuota(spaceQuota).typeConsumed(StorageType.SSD, SSDQuota).typeQuota(StorageType.SSD, SSDQuota).build();
        QuotaUsage quotaUsage2 = new QuotaUsage.Builder().fileAndDirectoryCount(fileAndDirCount).quota(quota).spaceConsumed(spaceConsumed).spaceQuota(spaceQuota).typeConsumed(StorageType.SSD, SSDQuota).typeQuota(StorageType.SSD, SSDQuota).build();
        Assertions.assertEquals((Object)quotaUsage1, (Object)quotaUsage2);
    }
}

