/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.AvroTestUtil;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.PlatformAssumptions;
import org.apache.hadoop.thirdparty.com.google.common.base.Joiner;
import org.apache.hadoop.util.Shell;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestPath {
    public static String mergeStatuses(Path[] paths) {
        Object[] pathStrings = new String[paths.length];
        int i = 0;
        for (Path path : paths) {
            pathStrings[i++] = path.toUri().getPath();
        }
        Arrays.sort(pathStrings);
        return Joiner.on((String)";").join(pathStrings);
    }

    public static String mergeStatuses(FileStatus[] statuses) {
        Path[] paths = new Path[statuses.length];
        int i = 0;
        for (FileStatus status : statuses) {
            paths[i++] = status.getPath();
        }
        return TestPath.mergeStatuses(paths);
    }

    @Test
    @Timeout(value=30L)
    public void testToString() {
        this.toStringTest("/");
        this.toStringTest("/foo");
        this.toStringTest("/foo/bar");
        this.toStringTest("foo");
        this.toStringTest("foo/bar");
        this.toStringTest("/foo/bar#boo");
        this.toStringTest("foo/bar#boo");
        boolean emptyException = false;
        try {
            this.toStringTest("");
        }
        catch (IllegalArgumentException e) {
            emptyException = true;
        }
        Assertions.assertTrue((boolean)emptyException);
        if (Path.WINDOWS) {
            this.toStringTest("c:");
            this.toStringTest("c:/");
            this.toStringTest("c:foo");
            this.toStringTest("c:foo/bar");
            this.toStringTest("c:foo/bar");
            this.toStringTest("c:/foo/bar");
            this.toStringTest("C:/foo/bar#boo");
            this.toStringTest("C:foo/bar#boo");
        }
    }

    private void toStringTest(String pathString) {
        Assertions.assertEquals((Object)pathString, (Object)new Path(pathString).toString());
    }

    @Test
    @Timeout(value=30L)
    public void testNormalize() throws URISyntaxException {
        Assertions.assertEquals((Object)"", (Object)new Path(".").toString());
        Assertions.assertEquals((Object)"..", (Object)new Path("..").toString());
        Assertions.assertEquals((Object)"/", (Object)new Path("/").toString());
        Assertions.assertEquals((Object)"/", (Object)new Path("//").toString());
        Assertions.assertEquals((Object)"/", (Object)new Path("///").toString());
        Assertions.assertEquals((Object)"//foo/", (Object)new Path("//foo/").toString());
        Assertions.assertEquals((Object)"//foo/", (Object)new Path("//foo//").toString());
        Assertions.assertEquals((Object)"//foo/bar", (Object)new Path("//foo//bar").toString());
        Assertions.assertEquals((Object)"/foo", (Object)new Path("/foo/").toString());
        Assertions.assertEquals((Object)"/foo", (Object)new Path("/foo/").toString());
        Assertions.assertEquals((Object)"foo", (Object)new Path("foo/").toString());
        Assertions.assertEquals((Object)"foo", (Object)new Path("foo//").toString());
        Assertions.assertEquals((Object)"foo", (Object)new Path("foo///").toString());
        Assertions.assertEquals((Object)"foo/bar", (Object)new Path("foo//bar").toString());
        Assertions.assertEquals((Object)"foo/bar", (Object)new Path("foo///bar").toString());
        Assertions.assertEquals((Object)"hdfs://foo/foo2/bar/baz/", (Object)new Path(new URI("hdfs://foo//foo2///bar/baz///")).toString());
        if (Path.WINDOWS) {
            Assertions.assertEquals((Object)"c:/a/b", (Object)new Path("c:\\a\\b").toString());
        }
    }

    @Test
    @Timeout(value=30L)
    public void testIsAbsolute() {
        Assertions.assertTrue((boolean)new Path("/").isAbsolute());
        Assertions.assertTrue((boolean)new Path("/foo").isAbsolute());
        Assertions.assertFalse((boolean)new Path("foo").isAbsolute());
        Assertions.assertFalse((boolean)new Path("foo/bar").isAbsolute());
        Assertions.assertFalse((boolean)new Path(".").isAbsolute());
        if (Path.WINDOWS) {
            Assertions.assertTrue((boolean)new Path("c:/a/b").isAbsolute());
            Assertions.assertFalse((boolean)new Path("c:a/b").isAbsolute());
        }
    }

    @Test
    @Timeout(value=30L)
    public void testParent() {
        Assertions.assertEquals((Object)new Path("/foo"), (Object)new Path("/foo/bar").getParent());
        Assertions.assertEquals((Object)new Path("foo"), (Object)new Path("foo/bar").getParent());
        Assertions.assertEquals((Object)new Path("/"), (Object)new Path("/foo").getParent());
        Assertions.assertEquals(null, (Object)new Path("/").getParent());
        if (Path.WINDOWS) {
            Assertions.assertEquals((Object)new Path("c:/"), (Object)new Path("c:/foo").getParent());
        }
    }

    @Test
    @Timeout(value=30L)
    public void testChild() {
        Assertions.assertEquals((Object)new Path("."), (Object)new Path(".", "."));
        Assertions.assertEquals((Object)new Path("/"), (Object)new Path("/", "."));
        Assertions.assertEquals((Object)new Path("/"), (Object)new Path(".", "/"));
        Assertions.assertEquals((Object)new Path("/foo"), (Object)new Path("/", "foo"));
        Assertions.assertEquals((Object)new Path("/foo/bar"), (Object)new Path("/foo", "bar"));
        Assertions.assertEquals((Object)new Path("/foo/bar/baz"), (Object)new Path("/foo/bar", "baz"));
        Assertions.assertEquals((Object)new Path("/foo/bar/baz"), (Object)new Path("/foo", "bar/baz"));
        Assertions.assertEquals((Object)new Path("foo"), (Object)new Path(".", "foo"));
        Assertions.assertEquals((Object)new Path("foo/bar"), (Object)new Path("foo", "bar"));
        Assertions.assertEquals((Object)new Path("foo/bar/baz"), (Object)new Path("foo", "bar/baz"));
        Assertions.assertEquals((Object)new Path("foo/bar/baz"), (Object)new Path("foo/bar", "baz"));
        Assertions.assertEquals((Object)new Path("/foo"), (Object)new Path("/bar", "/foo"));
        if (Path.WINDOWS) {
            Assertions.assertEquals((Object)new Path("c:/foo"), (Object)new Path("/bar", "c:/foo"));
            Assertions.assertEquals((Object)new Path("c:/foo"), (Object)new Path("d:/bar", "c:/foo"));
        }
    }

    @Test
    @Timeout(value=30L)
    public void testPathThreeArgContructor() {
        Assertions.assertEquals((Object)new Path("foo"), (Object)new Path(null, null, "foo"));
        Assertions.assertEquals((Object)new Path("scheme:///foo"), (Object)new Path("scheme", null, "/foo"));
        Assertions.assertEquals((Object)new Path("scheme://authority/foo"), (Object)new Path("scheme", "authority", "/foo"));
        if (Path.WINDOWS) {
            Assertions.assertEquals((Object)new Path("c:/foo/bar"), (Object)new Path(null, null, "c:/foo/bar"));
            Assertions.assertEquals((Object)new Path("c:/foo/bar"), (Object)new Path(null, null, "/c:/foo/bar"));
        } else {
            Assertions.assertEquals((Object)new Path("./a:b"), (Object)new Path(null, null, "a:b"));
        }
        if (Path.WINDOWS) {
            Assertions.assertEquals((Object)new Path("c:/foo/bar"), (Object)new Path("/fou", new Path(null, null, "c:/foo/bar")));
            Assertions.assertEquals((Object)new Path("c:/foo/bar"), (Object)new Path("/fou", new Path(null, null, "/c:/foo/bar")));
            Assertions.assertEquals((Object)new Path("/foo/bar"), (Object)new Path("/foo", new Path(null, null, "bar")));
        } else {
            Assertions.assertEquals((Object)new Path("/foo/bar/a:b"), (Object)new Path("/foo/bar", new Path(null, null, "a:b")));
            Assertions.assertEquals((Object)new Path("/a:b"), (Object)new Path("/foo/bar", new Path(null, null, "/a:b")));
        }
    }

    @Test
    @Timeout(value=30L)
    public void testEquals() {
        Assertions.assertFalse((boolean)new Path("/").equals((Object)new Path("/foo")));
    }

    @Test
    @Timeout(value=30L)
    public void testDots() {
        Assertions.assertEquals((Object)new Path("/foo/bar/baz").toString(), (Object)"/foo/bar/baz");
        Assertions.assertEquals((Object)new Path("/foo/bar", ".").toString(), (Object)"/foo/bar");
        Assertions.assertEquals((Object)new Path("/foo/bar/../baz").toString(), (Object)"/foo/baz");
        Assertions.assertEquals((Object)new Path("/foo/bar/./baz").toString(), (Object)"/foo/bar/baz");
        Assertions.assertEquals((Object)new Path("/foo/bar/baz/../../fud").toString(), (Object)"/foo/fud");
        Assertions.assertEquals((Object)new Path("/foo/bar/baz/.././../fud").toString(), (Object)"/foo/fud");
        Assertions.assertEquals((Object)new Path("../../foo/bar").toString(), (Object)"../../foo/bar");
        Assertions.assertEquals((Object)new Path(".././../foo/bar").toString(), (Object)"../../foo/bar");
        Assertions.assertEquals((Object)new Path("./foo/bar/baz").toString(), (Object)"foo/bar/baz");
        Assertions.assertEquals((Object)new Path("/foo/bar/../../baz/boo").toString(), (Object)"/baz/boo");
        Assertions.assertEquals((Object)new Path("foo/bar/").toString(), (Object)"foo/bar");
        Assertions.assertEquals((Object)new Path("foo/bar/../baz").toString(), (Object)"foo/baz");
        Assertions.assertEquals((Object)new Path("foo/bar/../../baz/boo").toString(), (Object)"baz/boo");
        Assertions.assertEquals((Object)new Path("/foo/bar", "baz/boo").toString(), (Object)"/foo/bar/baz/boo");
        Assertions.assertEquals((Object)new Path("foo/bar/", "baz/bud").toString(), (Object)"foo/bar/baz/bud");
        Assertions.assertEquals((Object)new Path("/foo/bar", "../../boo/bud").toString(), (Object)"/boo/bud");
        Assertions.assertEquals((Object)new Path("foo/bar", "../../boo/bud").toString(), (Object)"boo/bud");
        Assertions.assertEquals((Object)new Path(".", "boo/bud").toString(), (Object)"boo/bud");
        Assertions.assertEquals((Object)new Path("/foo/bar/baz", "../../boo/bud").toString(), (Object)"/foo/boo/bud");
        Assertions.assertEquals((Object)new Path("foo/bar/baz", "../../boo/bud").toString(), (Object)"foo/boo/bud");
        Assertions.assertEquals((Object)new Path("../../", "../../boo/bud").toString(), (Object)"../../../../boo/bud");
        Assertions.assertEquals((Object)new Path("../../foo", "../../../boo/bud").toString(), (Object)"../../../../boo/bud");
        Assertions.assertEquals((Object)new Path("../../foo/bar", "../boo/bud").toString(), (Object)"../../foo/boo/bud");
        Assertions.assertEquals((Object)new Path("foo/bar/baz", "../../..").toString(), (Object)"");
        Assertions.assertEquals((Object)new Path("foo/bar/baz", "../../../../..").toString(), (Object)"../..");
    }

    @Test
    @Timeout(value=5L)
    public void testWindowsPaths() throws URISyntaxException, IOException {
        PlatformAssumptions.assumeWindows();
        Assertions.assertEquals((Object)new Path("c:\\foo\\bar").toString(), (Object)"c:/foo/bar");
        Assertions.assertEquals((Object)new Path("c:/foo/bar").toString(), (Object)"c:/foo/bar");
        Assertions.assertEquals((Object)new Path("/c:/foo/bar").toString(), (Object)"c:/foo/bar");
        Assertions.assertEquals((Object)new Path("file://c:/foo/bar").toString(), (Object)"file://c:/foo/bar");
    }

    @Test
    @Timeout(value=5L)
    public void testInvalidWindowsPaths() throws URISyntaxException, IOException {
        String[] invalidPaths;
        PlatformAssumptions.assumeWindows();
        for (String path : invalidPaths = new String[]{"hdfs:\\\\\\tmp"}) {
            try {
                Path item = new Path(path);
                Assertions.fail((String)("Did not throw for invalid path " + path));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    @Test
    @Timeout(value=30L)
    public void testChildParentResolution() throws URISyntaxException, IOException {
        Path parent = new Path("foo1://bar1/baz1");
        Path child = new Path("foo2://bar2/baz2");
        Assertions.assertEquals((Object)child, (Object)new Path(parent, child));
    }

    @Test
    @Timeout(value=30L)
    public void testScheme() throws IOException {
        Assertions.assertEquals((Object)"foo:/bar", (Object)new Path("foo:/", "/bar").toString());
        Assertions.assertEquals((Object)"foo://bar/baz", (Object)new Path("foo://bar/", "/baz").toString());
    }

    @Test
    @Timeout(value=30L)
    public void testURI() throws URISyntaxException, IOException {
        URI uri = new URI("file:///bar#baz");
        Path path = new Path(uri);
        Assertions.assertTrue((boolean)uri.equals(new URI(path.toString())));
        FileSystem fs = path.getFileSystem(new Configuration());
        Assertions.assertTrue((boolean)uri.equals(new URI(fs.makeQualified(path).toString())));
        URI uri2 = new URI("file:///bar/baz");
        Assertions.assertTrue((boolean)uri2.equals(new URI(fs.makeQualified(new Path(uri2)).toString())));
        Assertions.assertEquals((Object)"foo://bar/baz#boo", (Object)new Path("foo://bar/", new Path(new URI("/baz#boo"))).toString());
        Assertions.assertEquals((Object)"foo://bar/baz/fud#boo", (Object)new Path(new Path(new URI("foo://bar/baz#bud")), new Path(new URI("fud#boo"))).toString());
        Assertions.assertEquals((Object)"foo://bar/fud#boo", (Object)new Path(new Path(new URI("foo://bar/baz#bud")), new Path(new URI("/fud#boo"))).toString());
    }

    @Test
    @Timeout(value=30L)
    public void testPathToUriConversion() throws URISyntaxException, IOException {
        Assertions.assertEquals((Object)new URI(null, null, "/foo?bar", null, null), (Object)new Path("/foo?bar").toUri(), (String)"? mark char in to URI");
        Assertions.assertEquals((Object)new URI(null, null, "/foo\"bar", null, null), (Object)new Path("/foo\"bar").toUri(), (String)"escape slashes chars in to URI");
        Assertions.assertEquals((Object)new URI(null, null, "/foo bar", null, null), (Object)new Path("/foo bar").toUri(), (String)"spaces in chars to URI");
        Assertions.assertEquals((Object)"/foo?bar", (Object)new Path("http://localhost/foo?bar").toUri().getPath());
        Assertions.assertEquals((Object)"/foo", (Object)new URI("http://localhost/foo?bar").getPath());
        Assertions.assertEquals((Object)new URI("/foo;bar").getPath(), (Object)new Path("/foo;bar").toUri().getPath());
        Assertions.assertEquals((Object)new URI("/foo;bar"), (Object)new Path("/foo;bar").toUri());
        Assertions.assertEquals((Object)new URI("/foo+bar"), (Object)new Path("/foo+bar").toUri());
        Assertions.assertEquals((Object)new URI("/foo-bar"), (Object)new Path("/foo-bar").toUri());
        Assertions.assertEquals((Object)new URI("/foo=bar"), (Object)new Path("/foo=bar").toUri());
        Assertions.assertEquals((Object)new URI("/foo,bar"), (Object)new Path("/foo,bar").toUri());
    }

    @Test
    @Timeout(value=30L)
    public void testReservedCharacters() throws URISyntaxException, IOException {
        Assertions.assertEquals((Object)"/foo%20bar", (Object)new URI(null, null, "/foo bar", null, null).getRawPath());
        Assertions.assertEquals((Object)"/foo bar", (Object)new URI(null, null, "/foo bar", null, null).getPath());
        Assertions.assertEquals((Object)"/foo%20bar", (Object)new URI(null, null, "/foo bar", null, null).toString());
        Assertions.assertEquals((Object)"/foo%20bar", (Object)new Path("/foo bar").toUri().toString());
        Assertions.assertEquals((Object)"/foo;bar", (Object)new URI("/foo;bar").getPath());
        Assertions.assertEquals((Object)"/foo;bar", (Object)new URI("/foo;bar").getRawPath());
        Assertions.assertEquals((Object)"/foo+bar", (Object)new URI("/foo+bar").getPath());
        Assertions.assertEquals((Object)"/foo+bar", (Object)new URI("/foo+bar").getRawPath());
        Assertions.assertEquals((Object)"/foo bar", (Object)new Path("http://localhost/foo bar").toUri().getPath());
        Assertions.assertEquals((Object)"/foo%20bar", (Object)new Path("http://localhost/foo bar").toUri().toURL().getPath());
        Assertions.assertEquals((Object)"/foo?bar", (Object)new URI("http", "localhost", "/foo?bar", null, null).getPath());
        Assertions.assertEquals((Object)"/foo%3Fbar", (Object)new URI("http", "localhost", "/foo?bar", null, null).toURL().getPath());
    }

    @Test
    @Timeout(value=30L)
    public void testMakeQualified() throws URISyntaxException {
        URI defaultUri = new URI("hdfs://host1/dir1");
        URI wd = new URI("hdfs://host2/dir2");
        Assertions.assertEquals((Object)new Path("hdfs://host1/dir/file"), (Object)new Path("file").makeQualified(defaultUri, new Path("/dir")));
        Assertions.assertEquals((Object)new Path("hdfs://host2/dir2/file"), (Object)new Path("file").makeQualified(defaultUri, new Path(wd)));
    }

    @Test
    @Timeout(value=30L)
    public void testGetName() {
        Assertions.assertEquals((Object)"", (Object)new Path("/").getName());
        Assertions.assertEquals((Object)"foo", (Object)new Path("foo").getName());
        Assertions.assertEquals((Object)"foo", (Object)new Path("/foo").getName());
        Assertions.assertEquals((Object)"foo", (Object)new Path("/foo/").getName());
        Assertions.assertEquals((Object)"bar", (Object)new Path("/foo/bar").getName());
        Assertions.assertEquals((Object)"bar", (Object)new Path("hdfs://host/foo/bar").getName());
    }

    @Test
    @Timeout(value=30L)
    public void testAvroReflect() throws Exception {
        System.setProperty("org.apache.avro.SERIALIZABLE_PACKAGES", "org.apache.hadoop.fs");
        AvroTestUtil.testReflect(new Path("foo"), "{\"type\":\"string\",\"java-class\":\"org.apache.hadoop.fs.Path\"}");
    }

    @Test
    @Timeout(value=30L)
    public void testGlobEscapeStatus() throws Exception {
        PlatformAssumptions.assumeNotWindows();
        LocalFileSystem lfs = FileSystem.getLocal((Configuration)new Configuration());
        Path testRoot = lfs.makeQualified(new Path(GenericTestUtils.getTempPath("testPathGlob")));
        lfs.delete(testRoot, true);
        lfs.mkdirs(testRoot);
        Assertions.assertTrue((boolean)lfs.isDirectory(testRoot));
        lfs.setWorkingDirectory(testRoot);
        Object[] paths = new Path[]{new Path(testRoot, "*/f"), new Path(testRoot, "d1/f"), new Path(testRoot, "d2/f")};
        Arrays.sort(paths);
        for (Object p : paths) {
            lfs.create((Path)p).close();
            Assertions.assertTrue((boolean)lfs.exists((Path)p));
        }
        Object[] stats = lfs.listStatus(new Path(testRoot, "*"));
        Assertions.assertEquals((int)1, (int)stats.length);
        Assertions.assertEquals((Object)new Path(testRoot, "*/f"), (Object)stats[0].getPath());
        stats = lfs.globStatus(new Path(testRoot, "*"));
        Arrays.sort(stats);
        Path[] parentPaths = new Path[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            parentPaths[i] = paths[i].getParent();
        }
        Assertions.assertEquals((Object)TestPath.mergeStatuses(parentPaths), (Object)TestPath.mergeStatuses((FileStatus[])stats));
        stats = lfs.globStatus(new Path(testRoot, "\\*"));
        Assertions.assertEquals((int)1, (int)stats.length);
        Assertions.assertEquals((Object)new Path(testRoot, "*"), (Object)stats[0].getPath());
        stats = lfs.globStatus(new Path(testRoot, "*/f"));
        Assertions.assertEquals((int)paths.length, (int)stats.length);
        Assertions.assertEquals((Object)TestPath.mergeStatuses((Path[])paths), (Object)TestPath.mergeStatuses((FileStatus[])stats));
        stats = lfs.globStatus(new Path(testRoot, "\\*/f"));
        Assertions.assertEquals((int)1, (int)stats.length);
        Assertions.assertEquals((Object)new Path(testRoot, "*/f"), (Object)stats[0].getPath());
        stats = lfs.globStatus(new Path(testRoot, "\\*/*"));
        Assertions.assertEquals((int)1, (int)stats.length);
        Assertions.assertEquals((Object)new Path(testRoot, "*/f"), (Object)stats[0].getPath());
    }

    @Test
    @Timeout(value=30L)
    public void testMergePaths() {
        Assertions.assertEquals((Object)new Path("/foo/bar"), (Object)Path.mergePaths((Path)new Path("/foo"), (Path)new Path("/bar")));
        Assertions.assertEquals((Object)new Path("/foo/bar/baz"), (Object)Path.mergePaths((Path)new Path("/foo/bar"), (Path)new Path("/baz")));
        Assertions.assertEquals((Object)new Path("/foo/bar/baz"), (Object)Path.mergePaths((Path)new Path("/foo"), (Path)new Path("/bar/baz")));
        Assertions.assertEquals((Object)new Path(Shell.WINDOWS ? "/C:/foo/bar" : "/C:/foo/C:/bar"), (Object)Path.mergePaths((Path)new Path("/C:/foo"), (Path)new Path("/C:/bar")));
        Assertions.assertEquals((Object)new Path(Shell.WINDOWS ? "/C:/bar" : "/C:/C:/bar"), (Object)Path.mergePaths((Path)new Path("/C:/"), (Path)new Path("/C:/bar")));
        Assertions.assertEquals((Object)new Path("/bar"), (Object)Path.mergePaths((Path)new Path("/"), (Path)new Path("/bar")));
        Assertions.assertEquals((Object)new Path("viewfs:///foo/bar"), (Object)Path.mergePaths((Path)new Path("viewfs:///foo"), (Path)new Path("file:///bar")));
        Assertions.assertEquals((Object)new Path("viewfs://vfsauthority/foo/bar"), (Object)Path.mergePaths((Path)new Path("viewfs://vfsauthority/foo"), (Path)new Path("file://fileauthority/bar")));
    }

    @Test
    @Timeout(value=30L)
    public void testIsWindowsAbsolutePath() {
        PlatformAssumptions.assumeWindows();
        Assertions.assertTrue((boolean)Path.isWindowsAbsolutePath((String)"C:\\test", (boolean)false));
        Assertions.assertTrue((boolean)Path.isWindowsAbsolutePath((String)"C:/test", (boolean)false));
        Assertions.assertTrue((boolean)Path.isWindowsAbsolutePath((String)"/C:/test", (boolean)true));
        Assertions.assertFalse((boolean)Path.isWindowsAbsolutePath((String)"/test", (boolean)false));
        Assertions.assertFalse((boolean)Path.isWindowsAbsolutePath((String)"/test", (boolean)true));
        Assertions.assertFalse((boolean)Path.isWindowsAbsolutePath((String)"C:test", (boolean)false));
        Assertions.assertFalse((boolean)Path.isWindowsAbsolutePath((String)"/C:test", (boolean)true));
    }

    @Test
    @Timeout(value=30L)
    public void testSerDeser() throws Throwable {
        Path source = new Path("hdfs://localhost:4040/scratch");
        ByteArrayOutputStream baos = new ByteArrayOutputStream(256);
        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(source);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        try (ObjectInputStream ois = new ObjectInputStream(bais);){
            Path deser = (Path)ois.readObject();
            Assertions.assertEquals((Object)source, (Object)deser);
        }
    }

    @Test
    @Timeout(value=30L)
    public void testSuffixFromRoot() {
        Path root = new Path("/");
        Assertions.assertNull((Object)root.getParent());
        Assertions.assertEquals((Object)new Path("/bar"), (Object)root.suffix("bar"));
    }
}

