/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.net.URI;
import org.apache.hadoop.fs.FCStatisticsBaseTest;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileSystem;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;

public class TestLocalFsFCStatistics
extends FCStatisticsBaseTest {
    static final String LOCAL_FS_ROOT_URI = "file:///tmp/test";

    @BeforeEach
    public void setUp() throws Exception {
        fc = FileContext.getLocalFSFileContext();
        fc.mkdir(this.fileContextTestHelper.getTestRootPath(fc, "test"), FileContext.DEFAULT_PERM, true);
    }

    @AfterEach
    public void tearDown() throws Exception {
        fc.delete(this.fileContextTestHelper.getTestRootPath(fc, "test"), true);
    }

    @Override
    protected void verifyReadBytes(FileSystem.Statistics stats) {
        Assertions.assertEquals((long)(2 * blockSize), (long)stats.getBytesRead());
    }

    @Override
    protected void verifyWrittenBytes(FileSystem.Statistics stats) {
        Assertions.assertEquals((long)(blockSize + 12), (long)stats.getBytesWritten());
    }

    @Override
    protected URI getFsUri() {
        return URI.create(LOCAL_FS_ROOT_URI);
    }
}

