/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BufferedFSInputStream;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSDataOutputStreamBuilder;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.test.PlatformAssumptions;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.util.StringUtils;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractShortAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.Mockito;

@Timeout(value=60L)
public class TestLocalFileSystem {
    private static final File base = GenericTestUtils.getTestDir("work-dir/localfs");
    private static final String TEST_ROOT_DIR = base.getAbsolutePath();
    private final Path TEST_PATH = new Path(TEST_ROOT_DIR, "test-file");
    private Configuration conf;
    private LocalFileSystem fileSys;
    private static final int CRC_SIZE = 12;
    private static final byte[] DATA = "1234567890".getBytes();

    private void cleanupFile(FileSystem fs, Path name) throws IOException {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)fs.exists(name));
        fs.delete(name, true);
        org.junit.jupiter.api.Assertions.assertTrue((!fs.exists(name) ? 1 : 0) != 0);
    }

    @BeforeEach
    public void setup() throws IOException {
        this.conf = new Configuration(false);
        this.conf.set("fs.file.impl", LocalFileSystem.class.getName());
        this.fileSys = FileSystem.getLocal((Configuration)this.conf);
        this.fileSys.delete(new Path(TEST_ROOT_DIR), true);
    }

    @AfterEach
    public void after() throws IOException {
        FileUtil.setWritable((File)base, (boolean)true);
        FileUtil.fullyDelete((File)base);
        org.junit.jupiter.api.Assertions.assertTrue((!base.exists() ? 1 : 0) != 0);
        RawLocalFileSystem.useStatIfAvailable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWorkingDirectory() throws IOException {
        Path origDir = this.fileSys.getWorkingDirectory();
        Path subdir = new Path(TEST_ROOT_DIR, "new");
        try {
            org.junit.jupiter.api.Assertions.assertTrue((!this.fileSys.exists(subdir) ? 1 : 0) != 0);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fileSys.mkdirs(subdir));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fileSys.isDirectory(subdir));
            this.fileSys.setWorkingDirectory(subdir);
            Path dir1 = new Path("dir1");
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fileSys.mkdirs(dir1));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fileSys.isDirectory(dir1));
            this.fileSys.delete(dir1, true);
            org.junit.jupiter.api.Assertions.assertTrue((!this.fileSys.exists(dir1) ? 1 : 0) != 0);
            Path file1 = new Path("file1");
            Path file2 = new Path("sub/file2");
            String contents = FileSystemTestHelper.writeFile((FileSystem)this.fileSys, file1, 1);
            this.fileSys.copyFromLocalFile(file1, file2);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fileSys.exists(file1));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fileSys.isFile(file1));
            this.cleanupFile((FileSystem)this.fileSys, file2);
            this.fileSys.copyToLocalFile(file1, file2);
            this.cleanupFile((FileSystem)this.fileSys, file2);
            this.fileSys.rename(file1, file2);
            org.junit.jupiter.api.Assertions.assertTrue((!this.fileSys.exists(file1) ? 1 : 0) != 0);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fileSys.exists(file2));
            this.fileSys.rename(file2, file1);
            FSDataInputStream stm = this.fileSys.open(file1);
            byte[] buffer = new byte[3];
            int bytesRead = stm.read(buffer, 0, 3);
            org.junit.jupiter.api.Assertions.assertEquals((Object)contents, (Object)new String(buffer, 0, bytesRead));
            stm.close();
        }
        finally {
            this.fileSys.setWorkingDirectory(origDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSyncable() throws IOException {
        FileSystem fs = this.fileSys.getRawFileSystem();
        Path file = new Path(TEST_ROOT_DIR, "syncable");
        FSDataOutputStream out = fs.create(file);
        boolean bytesWritten = true;
        byte[] expectedBuf = new byte[]{48, 49, 50, 51};
        try {
            out.write(expectedBuf, 0, 1);
            out.hflush();
            this.verifyFile(fs, file, 1, expectedBuf);
            out.write(expectedBuf, 1, expectedBuf.length - 1);
            out.hsync();
            this.verifyFile(fs, file, expectedBuf.length, expectedBuf);
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyFile(FileSystem fs, Path file, int bytesToVerify, byte[] expectedBytes) throws IOException {
        try (FSDataInputStream in = fs.open(file);){
            byte[] readBuf = new byte[bytesToVerify];
            in.readFully(readBuf, 0, bytesToVerify);
            for (int i = 0; i < bytesToVerify; ++i) {
                org.junit.jupiter.api.Assertions.assertEquals((byte)expectedBytes[i], (byte)readBuf[i]);
            }
        }
    }

    @Test
    public void testCopy() throws IOException {
        Path src = new Path(TEST_ROOT_DIR, "dingo");
        Path dst = new Path(TEST_ROOT_DIR, "yak");
        FileSystemTestHelper.writeFile((FileSystem)this.fileSys, src, 1);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)FileUtil.copy((FileSystem)this.fileSys, (Path)src, (FileSystem)this.fileSys, (Path)dst, (boolean)true, (boolean)false, (Configuration)this.conf));
        org.junit.jupiter.api.Assertions.assertTrue((!this.fileSys.exists(src) && this.fileSys.exists(dst) ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)FileUtil.copy((FileSystem)this.fileSys, (Path)dst, (FileSystem)this.fileSys, (Path)src, (boolean)false, (boolean)false, (Configuration)this.conf));
        org.junit.jupiter.api.Assertions.assertTrue((this.fileSys.exists(src) && this.fileSys.exists(dst) ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)FileUtil.copy((FileSystem)this.fileSys, (Path)src, (FileSystem)this.fileSys, (Path)dst, (boolean)true, (boolean)true, (Configuration)this.conf));
        org.junit.jupiter.api.Assertions.assertTrue((!this.fileSys.exists(src) && this.fileSys.exists(dst) ? 1 : 0) != 0);
        this.fileSys.mkdirs(src);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)FileUtil.copy((FileSystem)this.fileSys, (Path)dst, (FileSystem)this.fileSys, (Path)src, (boolean)false, (boolean)false, (Configuration)this.conf));
        Path tmp = new Path(src, dst.getName());
        org.junit.jupiter.api.Assertions.assertTrue((this.fileSys.exists(tmp) && this.fileSys.exists(dst) ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)FileUtil.copy((FileSystem)this.fileSys, (Path)dst, (FileSystem)this.fileSys, (Path)src, (boolean)false, (boolean)true, (Configuration)this.conf));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fileSys.delete(tmp, true));
        this.fileSys.mkdirs(tmp);
        try {
            FileUtil.copy((FileSystem)this.fileSys, (Path)dst, (FileSystem)this.fileSys, (Path)src, (boolean)true, (boolean)true, (Configuration)this.conf);
            org.junit.jupiter.api.Assertions.fail((String)"Failed to detect existing dir");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testHomeDirectory() throws IOException {
        Path home = this.fileSys.makeQualified(new Path(System.getProperty("user.home")));
        Path fsHome = this.fileSys.getHomeDirectory();
        org.junit.jupiter.api.Assertions.assertEquals((Object)home, (Object)fsHome);
    }

    @Test
    public void testPathEscapes() throws IOException {
        Path path = new Path(TEST_ROOT_DIR, "foo%bar");
        FileSystemTestHelper.writeFile((FileSystem)this.fileSys, path, 1);
        FileStatus status = this.fileSys.getFileStatus(path);
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.fileSys.makeQualified(path), (Object)status.getPath());
        this.cleanupFile((FileSystem)this.fileSys, path);
    }

    @Test
    public void testCreateFileAndMkdirs() throws IOException {
        Path test_dir = new Path(TEST_ROOT_DIR, "test_dir");
        Path test_file = new Path(test_dir, "file1");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fileSys.mkdirs(test_dir));
        int fileSize = new Random().nextInt(0x100000) + 1;
        FileSystemTestHelper.writeFile((FileSystem)this.fileSys, test_file, fileSize);
        FileStatus status = this.fileSys.getFileStatus(test_file);
        org.junit.jupiter.api.Assertions.assertEquals((long)fileSize, (long)status.getLen());
        ContentSummary summary = this.fileSys.getContentSummary(test_dir);
        org.junit.jupiter.api.Assertions.assertEquals((long)fileSize, (long)summary.getLength());
        Path bad_dir = new Path(test_file, "another_dir");
        try {
            this.fileSys.mkdirs(bad_dir);
            org.junit.jupiter.api.Assertions.fail((String)"Failed to detect existing file in path");
        }
        catch (ParentNotDirectoryException parentNotDirectoryException) {
            // empty catch block
        }
        try {
            this.fileSys.mkdirs(null);
            org.junit.jupiter.api.Assertions.fail((String)"Failed to detect null in mkdir arg");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testBasicDelete() throws IOException {
        Path dir1 = new Path(TEST_ROOT_DIR, "dir1");
        Path file1 = new Path(TEST_ROOT_DIR, "file1");
        Path file2 = new Path(TEST_ROOT_DIR + "/dir1", "file2");
        Path file3 = new Path(TEST_ROOT_DIR, "does-not-exist");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fileSys.mkdirs(dir1));
        FileSystemTestHelper.writeFile((FileSystem)this.fileSys, file1, 1);
        FileSystemTestHelper.writeFile((FileSystem)this.fileSys, file2, 1);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.fileSys.delete(file3), (String)"Returned true deleting non-existant path");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fileSys.delete(file1), (String)"Did not delete file");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fileSys.delete(dir1), (String)"Did not delete non-empty dir");
    }

    @Test
    public void testStatistics() throws Exception {
        int fileSchemeCount = 0;
        for (FileSystem.Statistics stats : FileSystem.getAllStatistics()) {
            if (!stats.getScheme().equals("file")) continue;
            ++fileSchemeCount;
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)fileSchemeCount);
    }

    @Test
    public void testHasFileDescriptor() throws IOException {
        Path path = new Path(TEST_ROOT_DIR, "test-file");
        FileSystemTestHelper.writeFile((FileSystem)this.fileSys, path, 1);
        BufferedFSInputStream bis = null;
        try {
            bis = new BufferedFSInputStream((FSInputStream)new RawLocalFileSystem.LocalFSFileInputStream(new RawLocalFileSystem(), path), 1024);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)bis.getFileDescriptor());
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{bis});
            throw throwable;
        }
        IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{bis});
    }

    @Test
    public void testListStatusWithColons() throws IOException {
        PlatformAssumptions.assumeNotWindows();
        File colonFile = new File(TEST_ROOT_DIR, "foo:bar");
        colonFile.mkdirs();
        FileStatus[] stats = this.fileSys.listStatus(new Path(TEST_ROOT_DIR));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)stats.length, (String)"Unexpected number of stats");
        org.junit.jupiter.api.Assertions.assertEquals((Object)colonFile.getAbsolutePath(), (Object)stats[0].getPath().toUri().getPath(), (String)"Bad path from stat");
    }

    @Test
    public void testListStatusReturnConsistentPathOnWindows() throws IOException {
        PlatformAssumptions.assumeWindows();
        String dirNoDriveSpec = TEST_ROOT_DIR;
        if (dirNoDriveSpec.charAt(1) == ':') {
            dirNoDriveSpec = dirNoDriveSpec.substring(2);
        }
        File file = new File(dirNoDriveSpec, "foo");
        file.mkdirs();
        FileStatus[] stats = this.fileSys.listStatus(new Path(dirNoDriveSpec));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)stats.length, (String)"Unexpected number of stats");
        org.junit.jupiter.api.Assertions.assertEquals((Object)new Path(file.getPath()).toUri().getPath(), (Object)stats[0].getPath().toUri().getPath(), (String)"Bad path from stat");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReportChecksumFailure() throws IOException {
        base.mkdirs();
        org.junit.jupiter.api.Assertions.assertTrue((base.exists() && base.isDirectory() ? 1 : 0) != 0);
        File dir1 = new File(base, "dir1");
        File dir2 = new File(dir1, "dir2");
        dir2.mkdirs();
        org.junit.jupiter.api.Assertions.assertTrue((dir2.exists() && FileUtil.canWrite((File)dir2) ? 1 : 0) != 0);
        String dataFileName = "corruptedData";
        Path dataPath = new Path(new File(dir2, "corruptedData").toURI());
        Path checksumPath = this.fileSys.getChecksumFile(dataPath);
        try (FSDataOutputStream fsdos = this.fileSys.create(dataPath);){
            fsdos.writeUTF("foo");
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fileSys.pathToFile(dataPath).exists());
        long dataFileLength = this.fileSys.getFileStatus(dataPath).getLen();
        org.junit.jupiter.api.Assertions.assertTrue((dataFileLength > 0L ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fileSys.pathToFile(checksumPath).exists());
        long checksumFileLength = this.fileSys.getFileStatus(checksumPath).getLen();
        org.junit.jupiter.api.Assertions.assertTrue((checksumFileLength > 0L ? 1 : 0) != 0);
        FileUtil.setWritable((File)base, (boolean)false);
        FSDataInputStream dataFsdis = this.fileSys.open(dataPath);
        FSDataInputStream checksumFsdis = this.fileSys.open(checksumPath);
        boolean retryIsNecessary = this.fileSys.reportChecksumFailure(dataPath, dataFsdis, 0L, checksumFsdis, 0L);
        org.junit.jupiter.api.Assertions.assertTrue((!retryIsNecessary ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((!this.fileSys.pathToFile(dataPath).exists() ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((!this.fileSys.pathToFile(checksumPath).exists() ? 1 : 0) != 0);
        File[] dir1files = dir1.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname != null && !pathname.getName().equals("dir2");
            }
        });
        org.junit.jupiter.api.Assertions.assertTrue((dir1files != null ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((dir1files.length == 1 ? 1 : 0) != 0);
        File badFilesDir = dir1files[0];
        File[] badFiles = badFilesDir.listFiles();
        org.junit.jupiter.api.Assertions.assertTrue((badFiles != null ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((badFiles.length == 2 ? 1 : 0) != 0);
        boolean dataFileFound = false;
        boolean checksumFileFound = false;
        for (File badFile : badFiles) {
            if (badFile.getName().startsWith("corruptedData")) {
                org.junit.jupiter.api.Assertions.assertTrue((dataFileLength == badFile.length() ? 1 : 0) != 0);
                dataFileFound = true;
                continue;
            }
            if (!badFile.getName().contains("corruptedData.crc")) continue;
            org.junit.jupiter.api.Assertions.assertTrue((checksumFileLength == badFile.length() ? 1 : 0) != 0);
            checksumFileFound = true;
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)dataFileFound);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)checksumFileFound);
    }

    private void checkTimesStatus(Path path, long expectedModTime, long expectedAccTime) throws IOException {
        FileStatus status = this.fileSys.getFileStatus(path);
        org.junit.jupiter.api.Assertions.assertEquals((long)expectedModTime, (long)status.getModificationTime());
        org.junit.jupiter.api.Assertions.assertEquals((long)expectedAccTime, (long)status.getAccessTime());
    }

    @Test
    public void testSetTimes() throws Exception {
        Path path = new Path(TEST_ROOT_DIR, "set-times");
        FileSystemTestHelper.writeFile((FileSystem)this.fileSys, path, 1);
        long newModTime = 12345000L;
        long newAccTime = 23456000L;
        FileStatus status = this.fileSys.getFileStatus(path);
        org.junit.jupiter.api.Assertions.assertTrue((newModTime != status.getModificationTime() ? 1 : 0) != 0, (String)"check we're actually changing something");
        org.junit.jupiter.api.Assertions.assertTrue((newAccTime != status.getAccessTime() ? 1 : 0) != 0, (String)"check we're actually changing something");
        this.fileSys.setTimes(path, newModTime, newAccTime);
        this.checkTimesStatus(path, newModTime, newAccTime);
        newModTime = 34567000L;
        this.fileSys.setTimes(path, newModTime, -1L);
        this.checkTimesStatus(path, newModTime, newAccTime);
        newAccTime = 45678000L;
        this.fileSys.setTimes(path, -1L, newAccTime);
        this.checkTimesStatus(path, newModTime, newAccTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBufferedFSInputStream() throws IOException {
        Configuration conf = new Configuration();
        conf.setClass("fs.file.impl", RawLocalFileSystem.class, FileSystem.class);
        conf.setInt("io.file.buffer.size", 4096);
        FileSystem fs = FileSystem.newInstance((Configuration)conf);
        byte[] buf = new byte[10240];
        new Random().nextBytes(buf);
        try (FSDataOutputStream stream = fs.create(this.TEST_PATH);){
            stream.write(buf);
        }
        Random r = new Random();
        FSDataInputStream stm = fs.open(this.TEST_PATH);
        int[] seeks = new int[10];
        int[] reads = new int[10];
        try {
            for (int i = 0; i < 1000; ++i) {
                int seekOff = r.nextInt(buf.length);
                int toRead = r.nextInt(Math.min(buf.length - seekOff, 32000));
                seeks[i % seeks.length] = seekOff;
                reads[i % reads.length] = toRead;
                this.verifyRead(stm, buf, seekOff, toRead);
            }
        }
        catch (AssertionError afe) {
            StringBuilder sb = new StringBuilder();
            sb.append("Sequence of actions:\n");
            for (int j = 0; j < seeks.length; ++j) {
                sb.append("seek @ ").append(seeks[j]).append("  ").append("read ").append(reads[j]).append("\n");
            }
            System.err.println(sb.toString());
            throw afe;
        }
        finally {
            stm.close();
        }
    }

    @Test
    public void testRenameDirectory() throws IOException {
        Path src = new Path(TEST_ROOT_DIR, "dir1");
        Path dst = new Path(TEST_ROOT_DIR, "dir2");
        this.fileSys.delete(src, true);
        this.fileSys.delete(dst, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fileSys.mkdirs(src));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fileSys.rename(src, dst));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fileSys.exists(dst));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.fileSys.exists(src));
    }

    @Test
    public void testRenameReplaceExistingEmptyDirectory() throws IOException {
        Path src = new Path(TEST_ROOT_DIR, "dir1");
        Path dst = new Path(TEST_ROOT_DIR, "dir2");
        this.fileSys.delete(src, true);
        this.fileSys.delete(dst, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fileSys.mkdirs(src));
        FileSystemTestHelper.writeFile((FileSystem)this.fileSys, new Path(src, "file1"), 1);
        FileSystemTestHelper.writeFile((FileSystem)this.fileSys, new Path(src, "file2"), 1);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fileSys.mkdirs(dst));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fileSys.rename(src, dst));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fileSys.exists(dst));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fileSys.exists(new Path(dst, "file1")));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fileSys.exists(new Path(dst, "file2")));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.fileSys.exists(src));
    }

    @Test
    public void testRenameMoveToExistingNonEmptyDirectory() throws IOException {
        Path src = new Path(TEST_ROOT_DIR, "dir1/dir2/dir3");
        Path dst = new Path(TEST_ROOT_DIR, "dir1");
        this.fileSys.delete(src, true);
        this.fileSys.delete(dst, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fileSys.mkdirs(src));
        FileSystemTestHelper.writeFile((FileSystem)this.fileSys, new Path(src, "file1"), 1);
        FileSystemTestHelper.writeFile((FileSystem)this.fileSys, new Path(src, "file2"), 1);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fileSys.exists(dst));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fileSys.rename(src, dst));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fileSys.exists(dst));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fileSys.exists(new Path(dst, "dir3")));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fileSys.exists(new Path(dst, "dir3/file1")));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fileSys.exists(new Path(dst, "dir3/file2")));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.fileSys.exists(src));
    }

    private void verifyRead(FSDataInputStream stm, byte[] fileContents, int seekOff, int toRead) throws IOException {
        byte[] out = new byte[toRead];
        stm.seek((long)seekOff);
        stm.readFully(out);
        byte[] expected = Arrays.copyOfRange(fileContents, seekOff, seekOff + toRead);
        if (!Arrays.equals(out, expected)) {
            String s = "\nExpected: " + StringUtils.byteToHexString((byte[])expected) + "\ngot:      " + StringUtils.byteToHexString((byte[])out) + "\noff=" + seekOff + " len=" + toRead;
            org.junit.jupiter.api.Assertions.fail((String)s);
        }
    }

    @Test
    public void testStripFragmentFromPath() throws Exception {
        LocalFileSystem fs = FileSystem.getLocal((Configuration)new Configuration());
        Path pathQualified = this.TEST_PATH.makeQualified(fs.getUri(), fs.getWorkingDirectory());
        Path pathWithFragment = new Path(new URI(pathQualified.toString() + "#glacier"));
        FileSystemTestHelper.createFile((FileSystem)fs, pathWithFragment);
        Path resolved = fs.resolvePath(pathWithFragment);
        org.junit.jupiter.api.Assertions.assertEquals((Object)pathQualified, (Object)resolved, (String)"resolvePath did not strip fragment from Path");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppendSetsPosCorrectly() throws Exception {
        FileSystem fs = this.fileSys.getRawFileSystem();
        Path file = new Path(TEST_ROOT_DIR, "test-append");
        fs.delete(file, true);
        try (FSDataOutputStream out = fs.create(file);){
            out.write("text1".getBytes());
        }
        out = fs.append(file);
        try {
            org.junit.jupiter.api.Assertions.assertEquals((long)5L, (long)out.getPos());
            out.write("text2".getBytes());
        }
        finally {
            out.close();
        }
        try (FSDataInputStream in = fs.open(file);){
            byte[] buf = new byte[in.available()];
            in.readFully(buf);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"text1text2", (Object)new String(buf));
        }
    }

    @Test
    public void testFileStatusPipeFile() throws Exception {
        RawLocalFileSystem origFs = new RawLocalFileSystem();
        RawLocalFileSystem fs = (RawLocalFileSystem)Mockito.spy((Object)origFs);
        Configuration conf = (Configuration)Mockito.mock(Configuration.class);
        fs.setConf(conf);
        RawLocalFileSystem.setUseDeprecatedFileStatus((boolean)false);
        Path path = new Path("/foo");
        File pipe = (File)Mockito.mock(File.class);
        Mockito.when((Object)pipe.isFile()).thenReturn((Object)false);
        Mockito.when((Object)pipe.isDirectory()).thenReturn((Object)false);
        Mockito.when((Object)pipe.exists()).thenReturn((Object)true);
        FileStatus stat = (FileStatus)Mockito.mock(FileStatus.class);
        ((RawLocalFileSystem)Mockito.doReturn((Object)pipe).when((Object)fs)).pathToFile(path);
        ((RawLocalFileSystem)Mockito.doReturn((Object)stat).when((Object)fs)).getFileStatus(path);
        FileStatus[] stats = fs.listStatus(path);
        org.junit.jupiter.api.Assertions.assertTrue((stats != null && stats.length == 1 && stats[0] == stat ? 1 : 0) != 0);
    }

    @Test
    public void testFSOutputStreamBuilder() throws Exception {
        Path path = new Path(TEST_ROOT_DIR, "testBuilder");
        FSDataOutputStreamBuilder builder = this.fileSys.createFile(path).recursive();
        FSDataOutputStream out = builder.build();
        String content = "Create with a generic type of createFile!";
        byte[] contentOrigin = content.getBytes(StandardCharsets.UTF_8);
        out.write(contentOrigin);
        out.close();
        FSDataInputStream input = this.fileSys.open(path);
        byte[] buffer = new byte[(int)this.fileSys.getFileStatus(path).getLen()];
        input.readFully(0L, buffer);
        input.close();
        org.junit.jupiter.api.Assertions.assertArrayEquals((byte[])contentOrigin, (byte[])buffer, (String)"The data be read should equals with the data written.");
        builder = this.fileSys.createFile(path);
        try (FSDataOutputStream stream = builder.build();){
            ((AbstractLongAssert)Assertions.assertThat((long)builder.getBlockSize()).withFailMessage("Should be default block size", new Object[0])).isEqualTo(this.fileSys.getDefaultBlockSize());
            ((AbstractShortAssert)Assertions.assertThat((short)builder.getReplication()).withFailMessage("Should be default replication factor", new Object[0])).isEqualTo(this.fileSys.getDefaultReplication());
            ((AbstractIntegerAssert)Assertions.assertThat((int)builder.getBufferSize()).withFailMessage("Should be default buffer size", new Object[0])).isEqualTo(this.fileSys.getConf().getInt("io.file.buffer.size", 4096));
            ((ObjectAssert)Assertions.assertThat((Object)builder.getPermission()).withFailMessage("Should be default permission", new Object[0])).isEqualTo((Object)FsPermission.getFileDefault());
        }
        builder = this.fileSys.createFile(path);
        builder.bufferSize(0).blockSize(0L).replication((short)0);
        ((AbstractLongAssert)Assertions.assertThat((long)builder.getBlockSize()).withFailMessage("Block size should be 0", new Object[0])).isZero();
        ((AbstractShortAssert)Assertions.assertThat((short)builder.getReplication()).withFailMessage("Replication factor should be 0", new Object[0])).isZero();
        ((AbstractIntegerAssert)Assertions.assertThat((int)builder.getBufferSize()).withFailMessage("Buffer size should be 0", new Object[0])).isZero();
    }

    @Test
    public void testFSOutputStreamBuilderOptions() throws Exception {
        Path path = new Path(TEST_ROOT_DIR, "testBuilderOpt");
        List<String> supportedKeys = Arrays.asList("strM");
        BuilderWithSupportedKeys builder = new BuilderWithSupportedKeys(supportedKeys, (FileSystem)this.fileSys, path);
        builder.opt("strKey", "value");
        builder.opt("intKey", 123);
        builder.opt("strM", "ignored");
        builder.must("strM", "value");
        builder.must("unsupported", 12.34);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"value", (Object)builder.getOptions().get("strM"), (String)"Optional value should be overwrite by a mandatory value");
        Set mandatoryKeys = builder.getMandatoryKeys();
        HashSet<String> expectedKeys = new HashSet<String>();
        expectedKeys.add("strM");
        expectedKeys.add("unsupported");
        org.junit.jupiter.api.Assertions.assertEquals(expectedKeys, (Object)mandatoryKeys);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)mandatoryKeys.size());
        LambdaTestUtils.intercept(IllegalArgumentException.class, "unsupported key found", () -> ((FSDataOutputStreamBuilder)builder).build());
    }

    protected FileSystem.Statistics getFileStatistics() {
        List all = FileSystem.getAllStatistics();
        List fileStats = all.stream().filter(s -> s.getScheme().equals("file")).collect(Collectors.toList());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)fileStats.size(), (String)"Number of statistics counters for file://");
        return (FileSystem.Statistics)fileStats.get(0);
    }

    private void writeData(FSDataOutputStream s) throws IOException {
        s.write(DATA);
        s.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertWritesCRC(String operation, Path path, LambdaTestUtils.VoidCallable callable, boolean delete) throws Exception {
        FileSystem.Statistics stats = this.getFileStatistics();
        long bytesOut0 = stats.getBytesWritten();
        try {
            callable.call();
            org.junit.jupiter.api.Assertions.assertEquals((long)(12 + DATA.length), (long)(stats.getBytesWritten() - bytesOut0), (String)("Bytes written in " + operation + "; stats=" + stats));
        }
        finally {
            if (delete) {
                try {
                    this.fileSys.delete(path, false);
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Test
    public void testCRCwithClassicAPIs() throws Throwable {
        Path file = new Path(TEST_ROOT_DIR, "testByteCountersClassicAPIs");
        this.assertWritesCRC("create()", file, () -> this.writeData(this.fileSys.create(file, true)), false);
        FileSystem.Statistics stats = this.getFileStatistics();
        long bytesRead0 = stats.getBytesRead();
        this.fileSys.open(file).close();
        long bytesRead1 = stats.getBytesRead();
        org.junit.jupiter.api.Assertions.assertEquals((long)12L, (long)(bytesRead1 - bytesRead0), (String)("Bytes read in open() call with stats " + stats));
    }

    @Test
    public void testCRCwithCreate7() throws Throwable {
        Path file = new Path(TEST_ROOT_DIR, "testCRCwithCreate7");
        this.assertWritesCRC("create/7", file, () -> this.writeData(this.fileSys.create(file, FsPermission.getFileDefault(), true, 8192, (short)1, 16384L, null)), true);
    }

    @Test
    public void testCRCwithCreateChecksumOpt() throws Throwable {
        Path file = new Path(TEST_ROOT_DIR, "testCRCwithCreateChecksumOpt");
        this.assertWritesCRC("create with checksum opt", file, () -> this.writeData(this.fileSys.create(file, FsPermission.getFileDefault(), EnumSet.of(CreateFlag.CREATE), 8192, (short)1, 16384L, null, Options.ChecksumOpt.createDisabled())), true);
    }

    @Test
    public void testCRCwithCreateNonRecursive6() throws Throwable {
        this.fileSys.mkdirs(this.TEST_PATH);
        Path file = new Path(TEST_ROOT_DIR, "testCRCwithCreateNonRecursive6");
        this.assertWritesCRC("create with checksum opt", file, () -> this.writeData(this.fileSys.createNonRecursive(file, FsPermission.getFileDefault(), true, 8192, (short)1, 16384L, null)), true);
    }

    @Test
    public void testCRCwithCreateNonRecursiveCreateFlags() throws Throwable {
        this.fileSys.mkdirs(this.TEST_PATH);
        Path file = new Path(TEST_ROOT_DIR, "testCRCwithCreateNonRecursiveCreateFlags");
        this.assertWritesCRC("create with checksum opt", file, () -> this.writeData(this.fileSys.createNonRecursive(file, FsPermission.getFileDefault(), EnumSet.of(CreateFlag.CREATE), 8192, (short)1, 16384L, null)), true);
    }

    @Test
    public void testReadIncludesCRCwithBuilders() throws Throwable {
        Path file = new Path(TEST_ROOT_DIR, "testReadIncludesCRCwithBuilders");
        FileSystem.Statistics stats = this.getFileStatistics();
        this.assertWritesCRC("createFile()", file, () -> this.writeData(this.fileSys.createFile(file).overwrite(true).recursive().build()), false);
        long bytesRead0 = stats.getBytesRead();
        ((FSDataInputStream)this.fileSys.openFile(file).build().get()).close();
        org.junit.jupiter.api.Assertions.assertEquals((long)12L, (long)(stats.getBytesRead() - bytesRead0), (String)("Bytes read in openFile() call with stats " + stats));
        this.assertWritesCRC("createFileNonRecursive()", file, () -> {
            try (FSDataOutputStream s = this.fileSys.createFile(file).overwrite(true).build();){
                s.write(DATA);
            }
        }, true);
    }

    @Test
    public void testWriteWithBuildersRecursive() throws Throwable {
        Path file = new Path(TEST_ROOT_DIR, "testWriteWithBuildersRecursive");
        FileSystem.Statistics stats = this.getFileStatistics();
        this.assertWritesCRC("createFile()", file, () -> this.writeData(this.fileSys.createFile(file).overwrite(false).recursive().build()), true);
    }

    private static class BuilderWithSupportedKeys
    extends FSDataOutputStreamBuilder<FSDataOutputStream, BuilderWithSupportedKeys> {
        private final Set<String> supportedKeys = new HashSet<String>();

        BuilderWithSupportedKeys(@Nonnull Collection<String> supportedKeys, @Nonnull FileSystem fileSystem, @Nonnull Path p) {
            super(fileSystem, p);
            this.supportedKeys.addAll(supportedKeys);
        }

        public BuilderWithSupportedKeys getThisBuilder() {
            return this;
        }

        public FSDataOutputStream build() throws IllegalArgumentException, IOException {
            HashSet unsupported = new HashSet(this.getMandatoryKeys());
            unsupported.removeAll(this.supportedKeys);
            Preconditions.checkArgument((boolean)unsupported.isEmpty(), (Object)("unsupported key found: " + this.supportedKeys));
            return this.getFS().create(this.getPath(), this.getPermission(), this.getFlags(), this.getBufferSize(), this.getReplication(), this.getBlockSize(), this.getProgress(), this.getChecksumOpt());
        }
    }
}

