/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.File;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.contract.AbstractContractCopyFromLocalTest;
import org.apache.hadoop.fs.contract.AbstractFSContract;
import org.apache.hadoop.fs.contract.localfs.LocalFSContract;
import org.junit.jupiter.api.Test;

public class TestLocalFSCopyFromLocal
extends AbstractContractCopyFromLocalTest {
    @Override
    protected AbstractFSContract createContract(Configuration conf) {
        return new LocalFSContract(conf);
    }

    @Test
    public void testDestinationFileIsToParentDirectory() throws Throwable {
        this.describe("Source is a file and destination is its own parent directory. Copying will cause the source file to be deleted.");
        File file = this.createTempFile("local");
        Path dest = new Path(file.getParentFile().toURI());
        Path src = new Path(file.toURI());
        this.getFileSystem().copyFromLocalFile(true, true, src, dest);
        this.assertPathDoesNotExist("Source found", src);
    }

    @Test
    public void testDestinationDirectoryToSelf() throws Throwable {
        this.describe("Source is a directory and it is copied into itself with delSrc flag set, destination must not exist");
        File source = this.createTempDirectory("srcDir");
        Path dest = new Path(source.toURI());
        this.getFileSystem().copyFromLocalFile(true, true, dest, dest);
        this.assertPathDoesNotExist("Source found", dest);
    }

    @Test
    public void testSourceIntoDestinationSubDirectoryWithDelSrc() throws Throwable {
        this.describe("Copying a parent folder inside a child folder with delSrc=TRUE");
        File parent = this.createTempDirectory("parent");
        File child = this.createTempDirectory(parent, "child");
        Path src = new Path(parent.toURI());
        Path dest = new Path(child.toURI());
        this.getFileSystem().copyFromLocalFile(true, true, src, dest);
        this.assertPathDoesNotExist("Source found", src);
        this.assertPathDoesNotExist("Destination found", dest);
    }

    @Test
    public void testSourceIntoDestinationSubDirectory() throws Throwable {
        this.describe("Copying a parent folder inside a child folder with delSrc=FALSE");
        File parent = this.createTempDirectory("parent");
        File child = this.createTempDirectory(parent, "child");
        Path src = new Path(parent.toURI());
        Path dest = new Path(child.toURI());
        this.getFileSystem().copyFromLocalFile(false, true, src, dest);
        Path recursiveParent = new Path(dest, parent.getName());
        Path recursiveChild = new Path(recursiveParent, child.getName());
        recursiveParent = new Path(recursiveChild, parent.getName());
        recursiveChild = new Path(recursiveParent, child.getName());
        this.assertPathExists("Recursive parent not found", recursiveParent);
        this.assertPathExists("Recursive child not found", recursiveChild);
    }
}

