/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.util.HashSet;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.slf4j.event.Level;

public class TestListFiles {
    static final long seed = 3735928559L;
    protected static final Configuration conf;
    protected static FileSystem fs;
    protected static Path TEST_DIR;
    private static final int FILE_LEN = 10;
    private static Path FILE1;
    private static Path DIR1;
    private static Path FILE2;
    private static Path FILE3;

    protected static Path getTestDir() {
        return TEST_DIR;
    }

    protected static void setTestPaths(Path testDir) {
        TEST_DIR = testDir;
        FILE1 = new Path(TEST_DIR, "file1");
        DIR1 = new Path(TEST_DIR, "dir1");
        FILE2 = new Path(DIR1, "file2");
        FILE3 = new Path(DIR1, "file3");
    }

    @BeforeAll
    public static void testSetUp() throws Exception {
        fs = FileSystem.getLocal((Configuration)conf);
        fs.delete(TEST_DIR, true);
    }

    private static void writeFile(FileSystem fileSys, Path name, int fileSize) throws IOException {
        FSDataOutputStream stm = fileSys.create(name);
        byte[] buffer = new byte[fileSize];
        Random rand = new Random(3735928559L);
        rand.nextBytes(buffer);
        stm.write(buffer);
        stm.close();
    }

    @Test
    public void testFile() throws IOException {
        fs.mkdirs(TEST_DIR);
        TestListFiles.writeFile(fs, FILE1, 10);
        RemoteIterator itor = fs.listFiles(FILE1, true);
        LocatedFileStatus stat = (LocatedFileStatus)itor.next();
        Assertions.assertFalse((boolean)itor.hasNext());
        Assertions.assertTrue((boolean)stat.isFile());
        Assertions.assertEquals((long)10L, (long)stat.getLen());
        Assertions.assertEquals((Object)fs.makeQualified(FILE1), (Object)stat.getPath());
        Assertions.assertEquals((int)1, (int)stat.getBlockLocations().length);
        itor = fs.listFiles(FILE1, false);
        stat = (LocatedFileStatus)itor.next();
        Assertions.assertFalse((boolean)itor.hasNext());
        Assertions.assertTrue((boolean)stat.isFile());
        Assertions.assertEquals((long)10L, (long)stat.getLen());
        Assertions.assertEquals((Object)fs.makeQualified(FILE1), (Object)stat.getPath());
        Assertions.assertEquals((int)1, (int)stat.getBlockLocations().length);
        fs.delete(FILE1, true);
    }

    @Test
    public void testDirectory() throws IOException {
        fs.mkdirs(DIR1);
        RemoteIterator itor = fs.listFiles(DIR1, true);
        Assertions.assertFalse((boolean)itor.hasNext());
        itor = fs.listFiles(DIR1, false);
        Assertions.assertFalse((boolean)itor.hasNext());
        TestListFiles.writeFile(fs, FILE2, 10);
        itor = fs.listFiles(DIR1, true);
        LocatedFileStatus stat = (LocatedFileStatus)itor.next();
        Assertions.assertFalse((boolean)itor.hasNext());
        Assertions.assertTrue((boolean)stat.isFile());
        Assertions.assertEquals((long)10L, (long)stat.getLen());
        Assertions.assertEquals((Object)fs.makeQualified(FILE2), (Object)stat.getPath());
        Assertions.assertEquals((int)1, (int)stat.getBlockLocations().length);
        itor = fs.listFiles(DIR1, false);
        stat = (LocatedFileStatus)itor.next();
        Assertions.assertFalse((boolean)itor.hasNext());
        Assertions.assertTrue((boolean)stat.isFile());
        Assertions.assertEquals((long)10L, (long)stat.getLen());
        Assertions.assertEquals((Object)fs.makeQualified(FILE2), (Object)stat.getPath());
        Assertions.assertEquals((int)1, (int)stat.getBlockLocations().length);
        TestListFiles.writeFile(fs, FILE1, 10);
        TestListFiles.writeFile(fs, FILE3, 10);
        HashSet<Path> filesToFind = new HashSet<Path>();
        filesToFind.add(fs.makeQualified(FILE1));
        filesToFind.add(fs.makeQualified(FILE2));
        filesToFind.add(fs.makeQualified(FILE3));
        itor = fs.listFiles(TEST_DIR, true);
        stat = (LocatedFileStatus)itor.next();
        Assertions.assertTrue((boolean)stat.isFile());
        Assertions.assertTrue((boolean)filesToFind.remove(stat.getPath()), (String)("Path " + stat.getPath() + " unexpected"));
        stat = (LocatedFileStatus)itor.next();
        Assertions.assertTrue((boolean)stat.isFile());
        Assertions.assertTrue((boolean)filesToFind.remove(stat.getPath()), (String)("Path " + stat.getPath() + " unexpected"));
        stat = (LocatedFileStatus)itor.next();
        Assertions.assertTrue((boolean)stat.isFile());
        Assertions.assertTrue((boolean)filesToFind.remove(stat.getPath()), (String)("Path " + stat.getPath() + " unexpected"));
        Assertions.assertFalse((boolean)itor.hasNext());
        Assertions.assertTrue((boolean)filesToFind.isEmpty());
        itor = fs.listFiles(TEST_DIR, false);
        stat = (LocatedFileStatus)itor.next();
        Assertions.assertTrue((boolean)stat.isFile());
        Assertions.assertEquals((Object)fs.makeQualified(FILE1), (Object)stat.getPath());
        Assertions.assertFalse((boolean)itor.hasNext());
        fs.delete(TEST_DIR, true);
    }

    static {
        GenericTestUtils.setLogLevel(FileSystem.LOG, Level.TRACE);
        conf = new Configuration();
        TestListFiles.setTestPaths(new Path(GenericTestUtils.getTempPath("testlistfiles"), "main_"));
    }
}

