/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.HarFileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Shell;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestHarFileSystemBasics {
    private static final String ROOT_PATH = GenericTestUtils.getTempPath("testharfilesystembasics");
    private static final Path rootPath;
    private static final Path harPath;
    private FileSystem localFileSystem;
    private HarFileSystem harFileSystem;
    private Configuration conf;

    private HarFileSystem createHarFileSystem(Configuration conf) throws Exception {
        this.localFileSystem = FileSystem.getLocal((Configuration)conf);
        this.localFileSystem.initialize(new URI("file:///"), conf);
        this.localFileSystem.mkdirs(rootPath);
        this.localFileSystem.mkdirs(harPath);
        Path indexPath = new Path(harPath, "_index");
        Path masterIndexPath = new Path(harPath, "_masterindex");
        this.localFileSystem.createNewFile(indexPath);
        Assertions.assertTrue((boolean)this.localFileSystem.exists(indexPath));
        this.localFileSystem.createNewFile(masterIndexPath);
        Assertions.assertTrue((boolean)this.localFileSystem.exists(masterIndexPath));
        this.writeVersionToMasterIndexImpl(3, masterIndexPath);
        HarFileSystem harFileSystem = new HarFileSystem(this.localFileSystem);
        URI uri = new URI("har://" + harPath.toString());
        harFileSystem.initialize(uri, conf);
        return harFileSystem;
    }

    private HarFileSystem createHarFileSystem(Configuration conf, Path aHarPath) throws Exception {
        this.localFileSystem.mkdirs(aHarPath);
        Path indexPath = new Path(aHarPath, "_index");
        Path masterIndexPath = new Path(aHarPath, "_masterindex");
        this.localFileSystem.createNewFile(indexPath);
        Assertions.assertTrue((boolean)this.localFileSystem.exists(indexPath));
        this.localFileSystem.createNewFile(masterIndexPath);
        Assertions.assertTrue((boolean)this.localFileSystem.exists(masterIndexPath));
        this.writeVersionToMasterIndexImpl(3, masterIndexPath);
        HarFileSystem harFileSystem = new HarFileSystem(this.localFileSystem);
        URI uri = new URI("har://" + aHarPath.toString());
        harFileSystem.initialize(uri, conf);
        return harFileSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeVersionToMasterIndexImpl(int version, Path masterIndexPath) throws IOException {
        try (FSDataOutputStream fsdos = this.localFileSystem.create(masterIndexPath);){
            String versionString = version + "\n";
            fsdos.write(versionString.getBytes(StandardCharsets.UTF_8));
            fsdos.flush();
        }
    }

    @BeforeEach
    public void before() throws Exception {
        File rootDirIoFile = new File(rootPath.toUri().getPath());
        rootDirIoFile.mkdirs();
        if (!rootDirIoFile.exists()) {
            throw new IOException("Failed to create temp directory [" + rootDirIoFile.getAbsolutePath() + "]");
        }
        this.conf = new Configuration();
        this.harFileSystem = this.createHarFileSystem(this.conf);
    }

    @AfterEach
    public void after() throws Exception {
        File rootDirIoFile;
        HarFileSystem harFS = this.harFileSystem;
        if (harFS != null) {
            harFS.close();
            this.harFileSystem = null;
        }
        if ((rootDirIoFile = new File(rootPath.toUri().getPath())).exists()) {
            FileUtil.fullyDelete((File)rootDirIoFile);
        }
        if (rootDirIoFile.exists()) {
            throw new IOException("Failed to delete temp directory [" + rootDirIoFile.getAbsolutePath() + "]");
        }
    }

    @Test
    public void testPositiveHarFileSystemBasics() throws Exception {
        Assertions.assertEquals((int)3, (int)this.harFileSystem.getHarVersion());
        URI harUri = this.harFileSystem.getUri();
        Assertions.assertEquals((Object)harPath.toUri().getPath(), (Object)harUri.getPath());
        Assertions.assertEquals((Object)"har", (Object)harUri.getScheme());
        Path homePath = this.harFileSystem.getHomeDirectory();
        Assertions.assertEquals((Object)harPath.toUri().getPath(), (Object)homePath.toUri().getPath());
        Path workDirPath0 = this.harFileSystem.getWorkingDirectory();
        Assertions.assertEquals((Object)homePath, (Object)workDirPath0);
        this.harFileSystem.setWorkingDirectory(new Path("/foo/bar"));
        Assertions.assertEquals((Object)workDirPath0, (Object)this.harFileSystem.getWorkingDirectory());
    }

    @Test
    public void testPositiveNewHarFsOnTheSameUnderlyingFs() throws Exception {
        HarFileSystem hfs = new HarFileSystem(this.localFileSystem);
        URI uri = new URI("har://" + harPath.toString());
        hfs.initialize(uri, new Configuration());
        Assertions.assertTrue((hfs.getMetadata() == this.harFileSystem.getMetadata() ? 1 : 0) != 0);
    }

    @Test
    public void testPositiveLruMetadataCacheFs() throws Exception {
        HarFileSystem hfs = new HarFileSystem(this.localFileSystem);
        URI uri = new URI("har://" + harPath.toString());
        hfs.initialize(uri, new Configuration());
        Assertions.assertTrue((hfs.getMetadata() == this.harFileSystem.getMetadata() ? 1 : 0) != 0);
        int i = 0;
        while (true) {
            if (i > 10) break;
            Path p = new Path(rootPath, "path1/path2/my" + i + ".har");
            this.createHarFileSystem(this.conf, p);
            ++i;
        }
        hfs = new HarFileSystem(this.localFileSystem);
        uri = new URI("har://" + harPath.toString());
        hfs.initialize(uri, new Configuration());
        Assertions.assertTrue((hfs.getMetadata() != this.harFileSystem.getMetadata() ? 1 : 0) != 0);
    }

    @Test
    public void testPositiveInitWithoutUnderlyingFS() throws Exception {
        HarFileSystem hfs = new HarFileSystem();
        URI uri = new URI("har://" + harPath.toString());
        hfs.initialize(uri, new Configuration());
    }

    @Test
    public void testPositiveListFilesNotEndInColon() throws Exception {
        URI uri = new URI("har://file-localhost" + harPath.toString());
        this.harFileSystem.initialize(uri, this.conf);
        Path p1 = new Path("har://file-localhost" + harPath.toString());
        Path p2 = this.harFileSystem.makeQualified(p1);
        Assertions.assertTrue((boolean)p2.toUri().toString().startsWith("har://file-localhost/"));
    }

    @Test
    public void testListLocatedStatus() throws Exception {
        String testHarPath = this.getClass().getResource("/test.har").getPath();
        URI uri = new URI("har://" + testHarPath);
        HarFileSystem hfs = new HarFileSystem(this.localFileSystem);
        hfs.initialize(uri, new Configuration());
        HashSet<String> expectedFileNames = new HashSet<String>();
        expectedFileNames.add("1.txt");
        expectedFileNames.add("2.txt");
        Path path = new Path("dir1");
        RemoteIterator fileList = hfs.listLocatedStatus(path);
        while (fileList.hasNext()) {
            String fileName = ((LocatedFileStatus)fileList.next()).getPath().getName();
            Assertions.assertTrue((boolean)expectedFileNames.contains(fileName), (String)(fileName + " not in expected files list"));
            expectedFileNames.remove(fileName);
        }
        Assertions.assertEquals((int)0, (int)expectedFileNames.size(), (String)("Didn't find all of the expected file names: " + expectedFileNames));
    }

    @Test
    public void testMakeQualifiedPath() throws Exception {
        String harPathWithUserinfo = "har://file-user:passwd@localhost:80" + harPath.toUri().getPath().toString();
        Path path = new Path(harPathWithUserinfo);
        Path qualifiedPath = path.getFileSystem(this.conf).makeQualified(path);
        Assertions.assertTrue((boolean)qualifiedPath.toString().equals(harPathWithUserinfo), (String)String.format("The qualified path (%s) did not match the expected path (%s).", qualifiedPath.toString(), harPathWithUserinfo));
    }

    @Test
    public void testNegativeInitWithoutIndex() throws Exception {
        Path indexPath = new Path(harPath, "_index");
        this.localFileSystem.delete(indexPath, false);
        HarFileSystem hfs = new HarFileSystem(this.localFileSystem);
        URI uri = new URI("har://" + harPath.toString());
        try {
            hfs.initialize(uri, new Configuration());
            Assertions.fail((String)"Exception expected.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testNegativeGetHarVersionOnNotInitializedFS() throws Exception {
        HarFileSystem hfs = new HarFileSystem(this.localFileSystem);
        try {
            int version = hfs.getHarVersion();
            Assertions.fail((String)("Exception expected, but got a Har version " + version + "."));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testNegativeInitWithAnUnsupportedVersion() throws Exception {
        Thread.sleep(1000L);
        this.writeVersionToMasterIndexImpl(7777, new Path(harPath, "_masterindex"));
        HarFileSystem hfs = new HarFileSystem(this.localFileSystem);
        Assertions.assertFalse((hfs.getMetadata() == this.harFileSystem.getMetadata() ? 1 : 0) != 0);
        URI uri = new URI("har://" + harPath.toString());
        try {
            hfs.initialize(uri, new Configuration());
            Assertions.fail((String)"IOException expected.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testNegativeHarFsModifications() throws Exception {
        Path fooPath = new Path(rootPath, "foo/bar");
        this.localFileSystem.createNewFile(fooPath);
        try {
            this.harFileSystem.create(fooPath, new FsPermission("+rwx"), true, 1024, (short)88, 1024L, null);
            Assertions.fail((String)"IOException expected.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.harFileSystem.setReplication(fooPath, (short)55);
            Assertions.fail((String)"IOException expected.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.harFileSystem.delete(fooPath, true);
            Assertions.fail((String)"IOException expected.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.harFileSystem.mkdirs(fooPath, new FsPermission("+rwx"));
            Assertions.fail((String)"IOException expected.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Path indexPath = new Path(harPath, "_index");
        try {
            this.harFileSystem.copyFromLocalFile(false, indexPath, fooPath);
            Assertions.fail((String)"IOException expected.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.harFileSystem.startLocalOutput(fooPath, indexPath);
            Assertions.fail((String)"IOException expected.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.harFileSystem.completeLocalOutput(fooPath, indexPath);
            Assertions.fail((String)"IOException expected.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.harFileSystem.setOwner(fooPath, "user", "group");
            Assertions.fail((String)"IOException expected.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.harFileSystem.setPermission(fooPath, new FsPermission("+x"));
            Assertions.fail((String)"IOException expected.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testHarFsWithoutAuthority() throws Exception {
        URI uri = this.harFileSystem.getUri();
        Assertions.assertNull((Object)uri.getAuthority(), (String)("har uri authority not null: " + uri));
        FileContext.getFileContext((URI)uri, (Configuration)this.conf);
    }

    static {
        String root = new Path(new File(ROOT_PATH).getAbsolutePath(), "localfs").toUri().getPath();
        if (Shell.WINDOWS) {
            root = root.substring(root.indexOf(58) + 1);
        }
        rootPath = new Path(root);
        harPath = new Path(rootPath, "path1/path2/my.har");
    }
}

