/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.shell.Command;
import org.apache.hadoop.fs.shell.CommandFactory;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestFsShell {
    @Test
    public void testConfWithInvalidFile() throws Throwable {
        String[] args = new String[]{"--conf=invalidFile"};
        Exception th = null;
        try {
            FsShell.main((String[])args);
        }
        catch (Exception e) {
            th = e;
        }
        if (!(th instanceof RuntimeException)) {
            throw ((Throwable)((Object)new AssertionError((Object)("Expected Runtime exception, got: " + th)))).initCause(th);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTracing() throws Throwable {
        Configuration conf = new Configuration();
        String prefix = "fs.shell.htrace.";
        conf.setQuietMode(false);
        try (FsShell shell = new FsShell(conf);){
            int res = ToolRunner.run((Tool)shell, (String[])new String[]{"-help", "ls", "cat"});
        }
    }

    @Test
    public void testDFSWithInvalidCommmand() throws Throwable {
        FsShell shell = new FsShell(new Configuration());
        try (GenericTestUtils.SystemErrCapturer capture = new GenericTestUtils.SystemErrCapturer();){
            ToolRunner.run((Tool)shell, (String[])new String[]{"dfs -mkdirs"});
            ((AbstractStringAssert)Assertions.assertThat((String)capture.getOutput()).as("FSShell dfs command did not print the error message when invalid command is passed", new Object[0])).contains(new CharSequence[]{"-mkdirs: Unknown command"});
            ((AbstractStringAssert)Assertions.assertThat((String)capture.getOutput()).as("FSShell dfs command did not print help message when invalid command is passed", new Object[0])).contains(new CharSequence[]{"Usage: hadoop fs [generic options]"});
        }
    }

    @Test
    public void testExceptionNullMessage() throws Exception {
        String cmdName = "-cmdExNullMsg";
        Command cmd = (Command)Mockito.mock(Command.class);
        Mockito.when((Object)cmd.run((String[])Mockito.any())).thenThrow(new Throwable[]{new IllegalArgumentException()});
        Mockito.when((Object)cmd.getUsage()).thenReturn((Object)"-cmdExNullMsg");
        CommandFactory cmdFactory = (CommandFactory)Mockito.mock(CommandFactory.class);
        String[] names = new String[]{"-cmdExNullMsg"};
        Mockito.when((Object)cmdFactory.getNames()).thenReturn((Object)names);
        Mockito.when((Object)cmdFactory.getInstance("-cmdExNullMsg")).thenReturn((Object)cmd);
        FsShell shell = new FsShell(new Configuration());
        shell.commandFactory = cmdFactory;
        try (GenericTestUtils.SystemErrCapturer capture = new GenericTestUtils.SystemErrCapturer();){
            ToolRunner.run((Tool)shell, (String[])new String[]{"-cmdExNullMsg"});
            Assertions.assertThat((String)capture.getOutput()).contains(new CharSequence[]{"-cmdExNullMsg: Null exception message"});
        }
    }
}

