/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.NetUtilsTestResolver;
import org.apache.hadoop.util.Progressable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestFileSystemCanonicalization {
    static String[] authorities = new String[]{"myfs://host", "myfs://host.a", "myfs://host.a.b"};
    static String[] ips = new String[]{"myfs://127.0.0.1"};

    @BeforeAll
    public static void initialize() throws Exception {
        NetUtilsTestResolver.install();
    }

    @Test
    public void testShortAuthority() throws Exception {
        FileSystem fs = this.getVerifiedFS("myfs://host", "myfs://host.a.b:123");
        this.verifyPaths(fs, authorities, -1, true);
        this.verifyPaths(fs, authorities, 123, true);
        this.verifyPaths(fs, authorities, 456, false);
        this.verifyPaths(fs, ips, -1, false);
        this.verifyPaths(fs, ips, 123, false);
        this.verifyPaths(fs, ips, 456, false);
    }

    @Test
    public void testPartialAuthority() throws Exception {
        FileSystem fs = this.getVerifiedFS("myfs://host.a", "myfs://host.a.b:123");
        this.verifyPaths(fs, authorities, -1, true);
        this.verifyPaths(fs, authorities, 123, true);
        this.verifyPaths(fs, authorities, 456, false);
        this.verifyPaths(fs, ips, -1, false);
        this.verifyPaths(fs, ips, 123, false);
        this.verifyPaths(fs, ips, 456, false);
    }

    @Test
    public void testFullAuthority() throws Exception {
        FileSystem fs = this.getVerifiedFS("myfs://host.a.b", "myfs://host.a.b:123");
        this.verifyPaths(fs, authorities, -1, true);
        this.verifyPaths(fs, authorities, 123, true);
        this.verifyPaths(fs, authorities, 456, false);
        this.verifyPaths(fs, ips, -1, false);
        this.verifyPaths(fs, ips, 123, false);
        this.verifyPaths(fs, ips, 456, false);
    }

    @Test
    public void testShortAuthorityWithDefaultPort() throws Exception {
        FileSystem fs = this.getVerifiedFS("myfs://host:123", "myfs://host.a.b:123");
        this.verifyPaths(fs, authorities, -1, true);
        this.verifyPaths(fs, authorities, 123, true);
        this.verifyPaths(fs, authorities, 456, false);
        this.verifyPaths(fs, ips, -1, false);
        this.verifyPaths(fs, ips, 123, false);
        this.verifyPaths(fs, ips, 456, false);
    }

    @Test
    public void testPartialAuthorityWithDefaultPort() throws Exception {
        FileSystem fs = this.getVerifiedFS("myfs://host.a:123", "myfs://host.a.b:123");
        this.verifyPaths(fs, authorities, -1, true);
        this.verifyPaths(fs, authorities, 123, true);
        this.verifyPaths(fs, authorities, 456, false);
        this.verifyPaths(fs, ips, -1, false);
        this.verifyPaths(fs, ips, 123, false);
        this.verifyPaths(fs, ips, 456, false);
    }

    @Test
    public void testFullAuthorityWithDefaultPort() throws Exception {
        FileSystem fs = this.getVerifiedFS("myfs://host.a.b:123", "myfs://host.a.b:123");
        this.verifyPaths(fs, authorities, -1, true);
        this.verifyPaths(fs, authorities, 123, true);
        this.verifyPaths(fs, authorities, 456, false);
        this.verifyPaths(fs, ips, -1, false);
        this.verifyPaths(fs, ips, 123, false);
        this.verifyPaths(fs, ips, 456, false);
    }

    @Test
    public void testShortAuthorityWithOtherPort() throws Exception {
        FileSystem fs = this.getVerifiedFS("myfs://host:456", "myfs://host.a.b:456");
        this.verifyPaths(fs, authorities, -1, false);
        this.verifyPaths(fs, authorities, 123, false);
        this.verifyPaths(fs, authorities, 456, true);
        this.verifyPaths(fs, ips, -1, false);
        this.verifyPaths(fs, ips, 123, false);
        this.verifyPaths(fs, ips, 456, false);
    }

    @Test
    public void testPartialAuthorityWithOtherPort() throws Exception {
        FileSystem fs = this.getVerifiedFS("myfs://host.a:456", "myfs://host.a.b:456");
        this.verifyPaths(fs, authorities, -1, false);
        this.verifyPaths(fs, authorities, 123, false);
        this.verifyPaths(fs, authorities, 456, true);
        this.verifyPaths(fs, ips, -1, false);
        this.verifyPaths(fs, ips, 123, false);
        this.verifyPaths(fs, ips, 456, false);
    }

    @Test
    public void testFullAuthorityWithOtherPort() throws Exception {
        FileSystem fs = this.getVerifiedFS("myfs://host.a.b:456", "myfs://host.a.b:456");
        this.verifyPaths(fs, authorities, -1, false);
        this.verifyPaths(fs, authorities, 123, false);
        this.verifyPaths(fs, authorities, 456, true);
        this.verifyPaths(fs, ips, -1, false);
        this.verifyPaths(fs, ips, 123, false);
        this.verifyPaths(fs, ips, 456, false);
    }

    @Test
    public void testIpAuthority() throws Exception {
        FileSystem fs = this.getVerifiedFS("myfs://127.0.0.1", "myfs://127.0.0.1:123");
        this.verifyPaths(fs, authorities, -1, false);
        this.verifyPaths(fs, authorities, 123, false);
        this.verifyPaths(fs, authorities, 456, false);
        this.verifyPaths(fs, ips, -1, true);
        this.verifyPaths(fs, ips, 123, true);
        this.verifyPaths(fs, ips, 456, false);
    }

    @Test
    public void testIpAuthorityWithDefaultPort() throws Exception {
        FileSystem fs = this.getVerifiedFS("myfs://127.0.0.1:123", "myfs://127.0.0.1:123");
        this.verifyPaths(fs, authorities, -1, false);
        this.verifyPaths(fs, authorities, 123, false);
        this.verifyPaths(fs, authorities, 456, false);
        this.verifyPaths(fs, ips, -1, true);
        this.verifyPaths(fs, ips, 123, true);
        this.verifyPaths(fs, ips, 456, false);
    }

    @Test
    public void testIpAuthorityWithOtherPort() throws Exception {
        FileSystem fs = this.getVerifiedFS("myfs://127.0.0.1:456", "myfs://127.0.0.1:456");
        this.verifyPaths(fs, authorities, -1, false);
        this.verifyPaths(fs, authorities, 123, false);
        this.verifyPaths(fs, authorities, 456, false);
        this.verifyPaths(fs, ips, -1, false);
        this.verifyPaths(fs, ips, 123, false);
        this.verifyPaths(fs, ips, 456, true);
    }

    @Test
    public void testMismatchedSchemes() throws Exception {
        FileSystem fs = this.getVerifiedFS("myfs2://simple", "myfs2://simple:123");
        this.verifyPaths(fs, authorities, -1, false);
        this.verifyPaths(fs, authorities, 123, false);
        this.verifyPaths(fs, authorities, 456, false);
        this.verifyPaths(fs, ips, -1, false);
        this.verifyPaths(fs, ips, 123, false);
        this.verifyPaths(fs, ips, 456, false);
    }

    @Test
    public void testMismatchedHosts() throws Exception {
        FileSystem fs = this.getVerifiedFS("myfs://simple", "myfs://simple:123");
        this.verifyPaths(fs, authorities, -1, false);
        this.verifyPaths(fs, authorities, 123, false);
        this.verifyPaths(fs, authorities, 456, false);
        this.verifyPaths(fs, ips, -1, false);
        this.verifyPaths(fs, ips, 123, false);
        this.verifyPaths(fs, ips, 456, false);
    }

    @Test
    public void testNullAuthority() throws Exception {
        FileSystem fs = this.getVerifiedFS("myfs:///", "myfs:///");
        this.verifyPaths(fs, new String[]{"myfs://"}, -1, true);
        this.verifyPaths(fs, authorities, -1, false);
        this.verifyPaths(fs, authorities, 123, false);
        this.verifyPaths(fs, authorities, 456, false);
        this.verifyPaths(fs, ips, -1, false);
        this.verifyPaths(fs, ips, 123, false);
        this.verifyPaths(fs, ips, 456, false);
    }

    @Test
    public void testAuthorityFromDefaultFS() throws Exception {
        Configuration config = new Configuration();
        String defaultFsKey = "fs.defaultFS";
        FileSystem fs = this.getVerifiedFS("myfs://host", "myfs://host.a.b:123", config);
        this.verifyPaths(fs, new String[]{"myfs://"}, -1, false);
        config.set(defaultFsKey, "myfs://host");
        this.verifyPaths(fs, new String[]{"myfs://"}, -1, true);
        config.set(defaultFsKey, "myfs2://host");
        this.verifyPaths(fs, new String[]{"myfs://"}, -1, false);
        config.set(defaultFsKey, "myfs://host:123");
        this.verifyPaths(fs, new String[]{"myfs://"}, -1, true);
        config.set(defaultFsKey, "myfs://host:456");
        this.verifyPaths(fs, new String[]{"myfs://"}, -1, false);
    }

    FileSystem getVerifiedFS(String authority, String canonical) throws Exception {
        return this.getVerifiedFS(authority, canonical, new Configuration());
    }

    FileSystem getVerifiedFS(String authority, String canonical, Configuration conf) throws Exception {
        URI uri = URI.create(authority);
        URI canonicalUri = URI.create(canonical);
        DummyFileSystem fs = new DummyFileSystem(uri, conf);
        Assertions.assertEquals((Object)uri, (Object)fs.getUri());
        Assertions.assertEquals((Object)canonicalUri, (Object)fs.getCanonicalUri());
        this.verifyCheckPath(fs, "/file", true);
        return fs;
    }

    /*
     * WARNING - void declaration
     */
    void verifyPaths(FileSystem fs, String[] uris, int port, boolean shouldPass) {
        for (String string : uris) {
            void var8_8;
            if (port != -1) {
                String string2 = string + ":" + port;
            }
            this.verifyCheckPath(fs, (String)var8_8 + "/file", shouldPass);
        }
    }

    void verifyCheckPath(FileSystem fs, String path, boolean shouldPass) {
        Path rawPath = new Path(path);
        Path fqPath = null;
        IllegalArgumentException e = null;
        try {
            fqPath = fs.makeQualified(rawPath);
        }
        catch (IllegalArgumentException iae) {
            e = iae;
        }
        if (shouldPass) {
            Assertions.assertEquals(null, (Object)e);
            String pathAuthority = rawPath.toUri().getAuthority();
            if (pathAuthority == null) {
                pathAuthority = fs.getUri().getAuthority();
            }
            Assertions.assertEquals((Object)pathAuthority, (Object)fqPath.toUri().getAuthority());
        } else {
            Assertions.assertNotNull((Object)e, (String)"did not fail");
            Assertions.assertEquals((Object)("Wrong FS: " + rawPath + ", expected: " + fs.getUri()), (Object)e.getMessage());
        }
    }

    static class DummyFileSystem
    extends FileSystem {
        URI uri;
        static int defaultPort = 123;

        DummyFileSystem(URI uri, Configuration conf) throws IOException {
            this.uri = uri;
            this.setConf(conf);
        }

        public URI getUri() {
            return this.uri;
        }

        protected int getDefaultPort() {
            return defaultPort;
        }

        protected URI canonicalizeUri(URI uri) {
            return NetUtils.getCanonicalUri((URI)uri, (int)this.getDefaultPort());
        }

        public FSDataInputStream open(Path f, int bufferSize) throws IOException {
            throw new IOException("not supposed to be here");
        }

        public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
            throw new IOException("not supposed to be here");
        }

        public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
            throw new IOException("not supposed to be here");
        }

        public boolean rename(Path src, Path dst) throws IOException {
            throw new IOException("not supposed to be here");
        }

        public boolean delete(Path f, boolean recursive) throws IOException {
            throw new IOException("not supposed to be here");
        }

        public FileStatus[] listStatus(Path f) throws IOException {
            throw new IOException("not supposed to be here");
        }

        public void setWorkingDirectory(Path new_dir) {
        }

        public Path getWorkingDirectory() {
            return new Path("/");
        }

        public boolean mkdirs(Path f, FsPermission permission) throws IOException {
            throw new IOException("not supposed to be here");
        }

        public FileStatus getFileStatus(Path f) throws IOException {
            throw new IOException("not supposed to be here");
        }
    }
}

