/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.ChecksumFileSystem;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSInputChecker;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestChecksumFileSystem {
    static final String TEST_ROOT_DIR = GenericTestUtils.getTempPath("work-dir/localfs");
    static LocalFileSystem localFs;

    @BeforeEach
    public void resetLocalFs() throws Exception {
        localFs = FileSystem.getLocal((Configuration)new Configuration());
        localFs.setVerifyChecksum(true);
    }

    @Test
    public void testgetChecksumLength() throws Exception {
        Assertions.assertEquals((long)8L, (long)ChecksumFileSystem.getChecksumLength((long)0L, (int)512));
        Assertions.assertEquals((long)12L, (long)ChecksumFileSystem.getChecksumLength((long)1L, (int)512));
        Assertions.assertEquals((long)12L, (long)ChecksumFileSystem.getChecksumLength((long)512L, (int)512));
        Assertions.assertEquals((long)16L, (long)ChecksumFileSystem.getChecksumLength((long)513L, (int)512));
        Assertions.assertEquals((long)16L, (long)ChecksumFileSystem.getChecksumLength((long)1023L, (int)512));
        Assertions.assertEquals((long)16L, (long)ChecksumFileSystem.getChecksumLength((long)1024L, (int)512));
        Assertions.assertEquals((long)408L, (long)ChecksumFileSystem.getChecksumLength((long)100L, (int)1));
        Assertions.assertEquals((long)4000000000008L, (long)ChecksumFileSystem.getChecksumLength((long)10000000000000L, (int)10));
    }

    @Test
    public void testVerifyChecksum() throws Exception {
        Path testPath = new Path(TEST_ROOT_DIR, "testPath");
        Path testPath11 = new Path(TEST_ROOT_DIR, "testPath11");
        FSDataOutputStream fout = localFs.create(testPath);
        fout.write("testing".getBytes());
        fout.close();
        fout = localFs.create(testPath11);
        fout.write("testing you".getBytes());
        fout.close();
        FileSystemTestHelper.readFile((FileSystem)localFs, testPath, 128);
        FileSystemTestHelper.readFile((FileSystem)localFs, testPath, 511);
        FileSystemTestHelper.readFile((FileSystem)localFs, testPath, 512);
        FileSystemTestHelper.readFile((FileSystem)localFs, testPath, 513);
        FileSystemTestHelper.readFile((FileSystem)localFs, testPath, 1023);
        FileSystemTestHelper.readFile((FileSystem)localFs, testPath, 1024);
        FileSystemTestHelper.readFile((FileSystem)localFs, testPath, 1025);
        localFs.delete(localFs.getChecksumFile(testPath), true);
        Assertions.assertTrue((!localFs.exists(localFs.getChecksumFile(testPath)) ? 1 : 0) != 0, (String)"checksum deleted");
        FileUtil.copy((FileSystem)localFs, (Path)localFs.getChecksumFile(testPath11), (FileSystem)localFs, (Path)localFs.getChecksumFile(testPath), (boolean)false, (boolean)true, (Configuration)localFs.getConf());
        Assertions.assertTrue((boolean)localFs.exists(localFs.getChecksumFile(testPath)), (String)"checksum exists");
        boolean errorRead = false;
        try {
            FileSystemTestHelper.readFile((FileSystem)localFs, testPath, 1024);
        }
        catch (ChecksumException ie) {
            errorRead = true;
        }
        Assertions.assertTrue((boolean)errorRead, (String)"error reading");
        localFs.setVerifyChecksum(false);
        String str = FileSystemTestHelper.readFile((FileSystem)localFs, testPath, 1024).toString();
        Assertions.assertTrue((boolean)"testing".equals(str), (String)"read");
    }

    @Test
    public void testMultiChunkFile() throws Exception {
        Path testPath = new Path(TEST_ROOT_DIR, "testMultiChunk");
        FSDataOutputStream fout = localFs.create(testPath);
        for (int i = 0; i < 1000; ++i) {
            fout.write(("testing" + i).getBytes());
        }
        fout.close();
        FileSystemTestHelper.readFile((FileSystem)localFs, testPath, 128);
        FileSystemTestHelper.readFile((FileSystem)localFs, testPath, 511);
        FileSystemTestHelper.readFile((FileSystem)localFs, testPath, 512);
        FileSystemTestHelper.readFile((FileSystem)localFs, testPath, 513);
        FileSystemTestHelper.readFile((FileSystem)localFs, testPath, 1023);
        FileSystemTestHelper.readFile((FileSystem)localFs, testPath, 1024);
        FileSystemTestHelper.readFile((FileSystem)localFs, testPath, 1025);
    }

    @Test
    public void testTruncatedChecksum() throws Exception {
        Path testPath = new Path(TEST_ROOT_DIR, "testtruncatedcrc");
        FSDataOutputStream fout = localFs.create(testPath);
        fout.write("testing truncation".getBytes());
        fout.close();
        Path checksumFile = localFs.getChecksumFile(testPath);
        FileSystem rawFs = localFs.getRawFileSystem();
        FSDataInputStream checksumStream = rawFs.open(checksumFile);
        byte[] buf = new byte[8192];
        int read = checksumStream.read(buf, 0, buf.length);
        checksumStream.close();
        FSDataOutputStream replaceStream = rawFs.create(checksumFile);
        replaceStream.write(buf, 0, read - 1);
        replaceStream.close();
        try {
            FileSystemTestHelper.readFile((FileSystem)localFs, testPath, 1024);
            Assertions.fail((String)"Did not throw a ChecksumException when reading truncated crc file");
        }
        catch (ChecksumException checksumException) {
            // empty catch block
        }
        localFs.setVerifyChecksum(false);
        String str = FileSystemTestHelper.readFile((FileSystem)localFs, testPath, 1024).toString();
        Assertions.assertTrue((boolean)"testing truncation".equals(str), (String)"read");
    }

    @Test
    public void testStreamType() throws Exception {
        Path testPath = new Path(TEST_ROOT_DIR, "testStreamType");
        localFs.create(testPath).close();
        FSDataInputStream in = null;
        localFs.setVerifyChecksum(true);
        in = localFs.open(testPath);
        Assertions.assertTrue((boolean)(in.getWrappedStream() instanceof FSInputChecker), (String)"stream is input checker");
        localFs.setVerifyChecksum(false);
        in = localFs.open(testPath);
        Assertions.assertFalse((boolean)(in.getWrappedStream() instanceof FSInputChecker), (String)"stream is not input checker");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCorruptedChecksum() throws Exception {
        Path testPath = new Path(TEST_ROOT_DIR, "testCorruptChecksum");
        Path checksumPath = localFs.getChecksumFile(testPath);
        FSDataOutputStream out = localFs.create(testPath, true);
        out.write("testing 1 2 3".getBytes());
        out.close();
        Assertions.assertTrue((boolean)localFs.exists(checksumPath));
        FileStatus stat = localFs.getFileStatus(checksumPath);
        out = localFs.getRawFileSystem().create(testPath, true);
        out.write("testing stale checksum".getBytes());
        out.close();
        Assertions.assertTrue((boolean)localFs.exists(checksumPath));
        Assertions.assertEquals((Object)stat, (Object)localFs.getFileStatus(checksumPath));
        ChecksumException e = null;
        try {
            localFs.setVerifyChecksum(true);
            FileSystemTestHelper.readFile((FileSystem)localFs, testPath, 1024);
        }
        catch (ChecksumException ce) {
            e = ce;
        }
        finally {
            Assertions.assertNotNull((Object)((Object)e), (String)"got checksum error");
        }
        localFs.setVerifyChecksum(false);
        String str = FileSystemTestHelper.readFile((FileSystem)localFs, testPath, 1024);
        Assertions.assertEquals((Object)"testing stale checksum", (Object)str);
    }

    @Test
    public void testRenameFileToFile() throws Exception {
        Path srcPath = new Path(TEST_ROOT_DIR, "testRenameSrc");
        Path dstPath = new Path(TEST_ROOT_DIR, "testRenameDst");
        this.verifyRename(srcPath, dstPath, false);
    }

    @Test
    public void testRenameFileIntoDir() throws Exception {
        Path srcPath = new Path(TEST_ROOT_DIR, "testRenameSrc");
        Path dstPath = new Path(TEST_ROOT_DIR, "testRenameDir");
        localFs.mkdirs(dstPath);
        this.verifyRename(srcPath, dstPath, true);
    }

    @Test
    public void testRenameFileIntoDirFile() throws Exception {
        Path srcPath = new Path(TEST_ROOT_DIR, "testRenameSrc");
        Path dstPath = new Path(TEST_ROOT_DIR, "testRenameDir/testRenameDst");
        Assertions.assertTrue((boolean)localFs.mkdirs(dstPath));
        this.verifyRename(srcPath, dstPath, false);
    }

    @Test
    public void testSetConf() {
        Configuration conf = new Configuration();
        conf.setInt("file.bytes-per-checksum", 0);
        try {
            localFs.setConf(conf);
            Assertions.fail((String)"Should have failed because zero bytes per checksum is invalid");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        conf.setInt("file.bytes-per-checksum", -1);
        try {
            localFs.setConf(conf);
            Assertions.fail((String)"Should have failed because negative bytes per checksum is invalid");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        conf.setInt("file.bytes-per-checksum", 512);
        localFs.setConf(conf);
    }

    void verifyRename(Path srcPath, Path dstPath, boolean dstIsDir) throws Exception {
        localFs.delete(srcPath, true);
        localFs.delete(dstPath, true);
        Path realDstPath = dstPath;
        if (dstIsDir) {
            localFs.mkdirs(dstPath);
            realDstPath = new Path(dstPath, srcPath.getName());
        }
        FileSystemTestHelper.writeFile((FileSystem)localFs, srcPath, 1);
        Assertions.assertTrue((boolean)localFs.exists(localFs.getChecksumFile(srcPath)));
        Assertions.assertTrue((boolean)localFs.rename(srcPath, dstPath));
        Assertions.assertTrue((boolean)localFs.exists(localFs.getChecksumFile(realDstPath)));
        FileSystemTestHelper.writeFile(localFs.getRawFileSystem(), srcPath, 1);
        Assertions.assertFalse((boolean)localFs.exists(localFs.getChecksumFile(srcPath)));
        Assertions.assertTrue((boolean)localFs.rename(srcPath, dstPath));
        Assertions.assertFalse((boolean)localFs.exists(localFs.getChecksumFile(realDstPath)));
        FileSystemTestHelper.writeFile((FileSystem)localFs, srcPath, 1);
        Assertions.assertTrue((boolean)localFs.exists(localFs.getChecksumFile(srcPath)));
        Assertions.assertTrue((boolean)localFs.rename(srcPath, dstPath));
        Assertions.assertTrue((boolean)localFs.exists(localFs.getChecksumFile(realDstPath)));
    }

    @Test
    public void testSetPermissionCrc() throws Exception {
        FileSystem rawFs = localFs.getRawFileSystem();
        Path p = new Path(TEST_ROOT_DIR, "testCrcPermissions");
        localFs.createNewFile(p);
        Path crc = localFs.getChecksumFile(p);
        assert (rawFs.exists(crc));
        for (short mode : Arrays.asList((short)438, (short)432, (short)384)) {
            FsPermission perm = new FsPermission(mode);
            localFs.setPermission(p, perm);
            Assertions.assertEquals((Object)perm, (Object)localFs.getFileStatus(p).getPermission());
            Assertions.assertEquals((Object)perm, (Object)rawFs.getFileStatus(crc).getPermission());
        }
    }

    @Test
    public void testOperationOnRoot() throws Exception {
        Path p = new Path("/");
        localFs.mkdirs(p);
        localFs.setReplication(p, localFs.getFileStatus(p).getPermission().toShort());
    }
}

