/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.StorageType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestBlockLocation {
    private static final String[] EMPTY_STR_ARRAY = new String[0];
    private static final StorageType[] EMPTY_STORAGE_TYPE_ARRAY = StorageType.EMPTY_ARRAY;

    private static void checkBlockLocation(BlockLocation loc) throws Exception {
        TestBlockLocation.checkBlockLocation(loc, 0L, 0L, false);
    }

    private static void checkBlockLocation(BlockLocation loc, long offset, long length, boolean corrupt) throws Exception {
        TestBlockLocation.checkBlockLocation(loc, EMPTY_STR_ARRAY, EMPTY_STR_ARRAY, EMPTY_STR_ARRAY, EMPTY_STR_ARRAY, EMPTY_STR_ARRAY, EMPTY_STORAGE_TYPE_ARRAY, offset, length, corrupt);
    }

    private static void checkBlockLocation(BlockLocation loc, String[] names, String[] hosts, String[] cachedHosts, String[] topologyPaths, String[] storageIds, StorageType[] storageTypes, long offset, long length, boolean corrupt) throws Exception {
        Assertions.assertNotNull((Object)loc.getHosts());
        Assertions.assertNotNull((Object)loc.getCachedHosts());
        Assertions.assertNotNull((Object)loc.getNames());
        Assertions.assertNotNull((Object)loc.getTopologyPaths());
        Assertions.assertNotNull((Object)loc.getStorageIds());
        Assertions.assertNotNull((Object)loc.getStorageTypes());
        Assertions.assertArrayEquals((Object[])hosts, (Object[])loc.getHosts());
        Assertions.assertArrayEquals((Object[])cachedHosts, (Object[])loc.getCachedHosts());
        Assertions.assertArrayEquals((Object[])names, (Object[])loc.getNames());
        Assertions.assertArrayEquals((Object[])topologyPaths, (Object[])loc.getTopologyPaths());
        Assertions.assertArrayEquals((Object[])storageIds, (Object[])loc.getStorageIds());
        Assertions.assertArrayEquals((Object[])storageTypes, (Object[])loc.getStorageTypes());
        Assertions.assertEquals((long)offset, (long)loc.getOffset());
        Assertions.assertEquals((long)length, (long)loc.getLength());
        Assertions.assertEquals((Object)corrupt, (Object)loc.isCorrupt());
    }

    @Test
    @Timeout(value=5L)
    public void testBlockLocationConstructors() throws Exception {
        BlockLocation loc = new BlockLocation();
        TestBlockLocation.checkBlockLocation(loc);
        loc = new BlockLocation(null, null, 1L, 2L);
        TestBlockLocation.checkBlockLocation(loc, 1L, 2L, false);
        loc = new BlockLocation(null, null, null, 1L, 2L);
        TestBlockLocation.checkBlockLocation(loc, 1L, 2L, false);
        loc = new BlockLocation(null, null, null, 1L, 2L, true);
        TestBlockLocation.checkBlockLocation(loc, 1L, 2L, true);
        loc = new BlockLocation(null, null, null, null, 1L, 2L, true);
        TestBlockLocation.checkBlockLocation(loc, 1L, 2L, true);
        loc = new BlockLocation(null, null, null, null, null, null, 1L, 2L, true);
        TestBlockLocation.checkBlockLocation(loc, 1L, 2L, true);
    }

    @Test
    @Timeout(value=5L)
    public void testBlockLocationSetters() throws Exception {
        BlockLocation loc = new BlockLocation();
        loc.setHosts(null);
        loc.setCachedHosts(null);
        loc.setNames(null);
        loc.setTopologyPaths(null);
        TestBlockLocation.checkBlockLocation(loc);
        String[] names = new String[]{"name"};
        String[] hosts = new String[]{"host"};
        String[] cachedHosts = new String[]{"cachedHost"};
        String[] topologyPaths = new String[]{"path"};
        String[] storageIds = new String[]{"storageId"};
        StorageType[] storageTypes = new StorageType[]{StorageType.DISK};
        loc.setNames(names);
        loc.setHosts(hosts);
        loc.setCachedHosts(cachedHosts);
        loc.setTopologyPaths(topologyPaths);
        loc.setStorageIds(storageIds);
        loc.setStorageTypes(storageTypes);
        loc.setOffset(1L);
        loc.setLength(2L);
        loc.setCorrupt(true);
        TestBlockLocation.checkBlockLocation(loc, names, hosts, cachedHosts, topologyPaths, storageIds, storageTypes, 1L, 2L, true);
    }
}

