/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.AvroFSInput;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestAvroFSInput {
    private static final String INPUT_DIR = "AvroFSInput";

    private Path getInputPath() {
        return new Path(GenericTestUtils.getTempPath(INPUT_DIR));
    }

    @Test
    public void testAFSInput() throws Exception {
        Path filePath;
        Path dir;
        Configuration conf = new Configuration();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        if (!fs.exists(dir = this.getInputPath())) {
            fs.mkdirs(dir);
        }
        if (fs.exists(filePath = new Path(dir, "foo"))) {
            fs.delete(filePath, false);
        }
        FSDataOutputStream ostream = fs.create(filePath);
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)ostream));
        w.write("0123456789");
        w.close();
        FileContext fc = FileContext.getFileContext((Configuration)conf);
        AvroFSInput avroFSIn = new AvroFSInput(fc, filePath);
        Assertions.assertEquals((long)10L, (long)avroFSIn.length());
        byte[] buf = new byte[1];
        Assertions.assertEquals((long)0L, (long)avroFSIn.tell());
        avroFSIn.read(buf, 0, 1);
        Assertions.assertEquals((long)1L, (long)avroFSIn.tell());
        Assertions.assertEquals((char)'0', (char)((char)buf[0]));
        avroFSIn.seek(4L);
        Assertions.assertEquals((long)4L, (long)avroFSIn.tell());
        avroFSIn.read(buf, 0, 1);
        Assertions.assertEquals((char)'4', (char)((char)buf[0]));
        Assertions.assertEquals((long)5L, (long)avroFSIn.tell());
        avroFSIn.close();
    }
}

