/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key;

import java.util.Date;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.CachingKeyProvider;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.kms.KMSClientProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestCachingKeyProvider {
    @Test
    public void testCurrentKey() throws Exception {
        KeyProvider.KeyVersion mockKey = (KeyProvider.KeyVersion)Mockito.mock(KeyProvider.KeyVersion.class);
        KeyProvider mockProv = (KeyProvider)Mockito.mock(KeyProvider.class);
        Mockito.when((Object)mockProv.getCurrentKey((String)Mockito.eq((Object)"k1"))).thenReturn((Object)mockKey);
        Mockito.when((Object)mockProv.getCurrentKey((String)Mockito.eq((Object)"k2"))).thenReturn(null);
        Mockito.when((Object)mockProv.getConf()).thenReturn((Object)new Configuration());
        CachingKeyProvider cache = new CachingKeyProvider(mockProv, 100L, 100L);
        Assertions.assertEquals((Object)mockKey, (Object)cache.getCurrentKey("k1"));
        ((KeyProvider)Mockito.verify((Object)mockProv, (VerificationMode)Mockito.times((int)1))).getCurrentKey((String)Mockito.eq((Object)"k1"));
        Assertions.assertEquals((Object)mockKey, (Object)cache.getCurrentKey("k1"));
        ((KeyProvider)Mockito.verify((Object)mockProv, (VerificationMode)Mockito.times((int)1))).getCurrentKey((String)Mockito.eq((Object)"k1"));
        Thread.sleep(1200L);
        Assertions.assertEquals((Object)mockKey, (Object)cache.getCurrentKey("k1"));
        ((KeyProvider)Mockito.verify((Object)mockProv, (VerificationMode)Mockito.times((int)2))).getCurrentKey((String)Mockito.eq((Object)"k1"));
        cache = new CachingKeyProvider(mockProv, 100L, 100L);
        Assertions.assertEquals(null, (Object)cache.getCurrentKey("k2"));
        ((KeyProvider)Mockito.verify((Object)mockProv, (VerificationMode)Mockito.times((int)1))).getCurrentKey((String)Mockito.eq((Object)"k2"));
        Assertions.assertEquals(null, (Object)cache.getCurrentKey("k2"));
        ((KeyProvider)Mockito.verify((Object)mockProv, (VerificationMode)Mockito.times((int)2))).getCurrentKey((String)Mockito.eq((Object)"k2"));
    }

    @Test
    public void testKeyVersion() throws Exception {
        KeyProvider.KeyVersion mockKey = (KeyProvider.KeyVersion)Mockito.mock(KeyProvider.KeyVersion.class);
        KeyProvider mockProv = (KeyProvider)Mockito.mock(KeyProvider.class);
        Mockito.when((Object)mockProv.getKeyVersion((String)Mockito.eq((Object)"k1@0"))).thenReturn((Object)mockKey);
        Mockito.when((Object)mockProv.getKeyVersion((String)Mockito.eq((Object)"k2@0"))).thenReturn(null);
        Mockito.when((Object)mockProv.getConf()).thenReturn((Object)new Configuration());
        CachingKeyProvider cache = new CachingKeyProvider(mockProv, 100L, 100L);
        Assertions.assertEquals((Object)mockKey, (Object)cache.getKeyVersion("k1@0"));
        ((KeyProvider)Mockito.verify((Object)mockProv, (VerificationMode)Mockito.times((int)1))).getKeyVersion((String)Mockito.eq((Object)"k1@0"));
        Assertions.assertEquals((Object)mockKey, (Object)cache.getKeyVersion("k1@0"));
        ((KeyProvider)Mockito.verify((Object)mockProv, (VerificationMode)Mockito.times((int)1))).getKeyVersion((String)Mockito.eq((Object)"k1@0"));
        Thread.sleep(200L);
        Assertions.assertEquals((Object)mockKey, (Object)cache.getKeyVersion("k1@0"));
        ((KeyProvider)Mockito.verify((Object)mockProv, (VerificationMode)Mockito.times((int)2))).getKeyVersion((String)Mockito.eq((Object)"k1@0"));
        cache = new CachingKeyProvider(mockProv, 100L, 100L);
        Assertions.assertEquals(null, (Object)cache.getKeyVersion("k2@0"));
        ((KeyProvider)Mockito.verify((Object)mockProv, (VerificationMode)Mockito.times((int)1))).getKeyVersion((String)Mockito.eq((Object)"k2@0"));
        Assertions.assertEquals(null, (Object)cache.getKeyVersion("k2@0"));
        ((KeyProvider)Mockito.verify((Object)mockProv, (VerificationMode)Mockito.times((int)2))).getKeyVersion((String)Mockito.eq((Object)"k2@0"));
    }

    @Test
    public void testMetadata() throws Exception {
        KeyProvider.Metadata mockMeta = (KeyProvider.Metadata)Mockito.mock(KeyProvider.Metadata.class);
        KeyProvider mockProv = (KeyProvider)Mockito.mock(KeyProvider.class);
        Mockito.when((Object)mockProv.getMetadata((String)Mockito.eq((Object)"k1"))).thenReturn((Object)mockMeta);
        Mockito.when((Object)mockProv.getMetadata((String)Mockito.eq((Object)"k2"))).thenReturn(null);
        Mockito.when((Object)mockProv.getConf()).thenReturn((Object)new Configuration());
        CachingKeyProvider cache = new CachingKeyProvider(mockProv, 100L, 100L);
        Assertions.assertEquals((Object)mockMeta, (Object)cache.getMetadata("k1"));
        ((KeyProvider)Mockito.verify((Object)mockProv, (VerificationMode)Mockito.times((int)1))).getMetadata((String)Mockito.eq((Object)"k1"));
        Assertions.assertEquals((Object)mockMeta, (Object)cache.getMetadata("k1"));
        ((KeyProvider)Mockito.verify((Object)mockProv, (VerificationMode)Mockito.times((int)1))).getMetadata((String)Mockito.eq((Object)"k1"));
        Thread.sleep(200L);
        Assertions.assertEquals((Object)mockMeta, (Object)cache.getMetadata("k1"));
        ((KeyProvider)Mockito.verify((Object)mockProv, (VerificationMode)Mockito.times((int)2))).getMetadata((String)Mockito.eq((Object)"k1"));
        cache = new CachingKeyProvider(mockProv, 100L, 100L);
        Assertions.assertEquals(null, (Object)cache.getMetadata("k2"));
        ((KeyProvider)Mockito.verify((Object)mockProv, (VerificationMode)Mockito.times((int)1))).getMetadata((String)Mockito.eq((Object)"k2"));
        Assertions.assertEquals(null, (Object)cache.getMetadata("k2"));
        ((KeyProvider)Mockito.verify((Object)mockProv, (VerificationMode)Mockito.times((int)2))).getMetadata((String)Mockito.eq((Object)"k2"));
    }

    @Test
    public void testRollNewVersion() throws Exception {
        KeyProvider.KeyVersion mockKey = (KeyProvider.KeyVersion)Mockito.mock(KeyProvider.KeyVersion.class);
        KeyProvider mockProv = (KeyProvider)Mockito.mock(KeyProvider.class);
        Mockito.when((Object)mockProv.getCurrentKey((String)Mockito.eq((Object)"k1"))).thenReturn((Object)mockKey);
        Mockito.when((Object)mockProv.getConf()).thenReturn((Object)new Configuration());
        CachingKeyProvider cache = new CachingKeyProvider(mockProv, 100L, 100L);
        Assertions.assertEquals((Object)mockKey, (Object)cache.getCurrentKey("k1"));
        ((KeyProvider)Mockito.verify((Object)mockProv, (VerificationMode)Mockito.times((int)1))).getCurrentKey((String)Mockito.eq((Object)"k1"));
        cache.rollNewVersion("k1");
        Assertions.assertEquals((Object)mockKey, (Object)cache.getCurrentKey("k1"));
        ((KeyProvider)Mockito.verify((Object)mockProv, (VerificationMode)Mockito.times((int)2))).getCurrentKey((String)Mockito.eq((Object)"k1"));
        cache.rollNewVersion("k1", new byte[0]);
        Assertions.assertEquals((Object)mockKey, (Object)cache.getCurrentKey("k1"));
        ((KeyProvider)Mockito.verify((Object)mockProv, (VerificationMode)Mockito.times((int)3))).getCurrentKey((String)Mockito.eq((Object)"k1"));
    }

    @Test
    public void testDeleteKey() throws Exception {
        KeyProvider.KeyVersion mockKey = (KeyProvider.KeyVersion)Mockito.mock(KeyProvider.KeyVersion.class);
        KeyProvider mockProv = (KeyProvider)Mockito.mock(KeyProvider.class);
        Mockito.when((Object)mockProv.getCurrentKey((String)Mockito.eq((Object)"k1"))).thenReturn((Object)mockKey);
        Mockito.when((Object)mockProv.getKeyVersion((String)Mockito.eq((Object)"k1@0"))).thenReturn((Object)mockKey);
        Mockito.when((Object)mockProv.getMetadata((String)Mockito.eq((Object)"k1"))).thenReturn((Object)new KMSClientProvider.KMSMetadata("c", 0, "l", null, new Date(), 1));
        Mockito.when((Object)mockProv.getConf()).thenReturn((Object)new Configuration());
        CachingKeyProvider cache = new CachingKeyProvider(mockProv, 100L, 100L);
        Assertions.assertEquals((Object)mockKey, (Object)cache.getCurrentKey("k1"));
        ((KeyProvider)Mockito.verify((Object)mockProv, (VerificationMode)Mockito.times((int)1))).getCurrentKey((String)Mockito.eq((Object)"k1"));
        Assertions.assertEquals((Object)mockKey, (Object)cache.getKeyVersion("k1@0"));
        ((KeyProvider)Mockito.verify((Object)mockProv, (VerificationMode)Mockito.times((int)1))).getKeyVersion((String)Mockito.eq((Object)"k1@0"));
        cache.deleteKey("k1");
        Assertions.assertEquals((Object)mockKey, (Object)cache.getCurrentKey("k1"));
        ((KeyProvider)Mockito.verify((Object)mockProv, (VerificationMode)Mockito.times((int)2))).getCurrentKey((String)Mockito.eq((Object)"k1"));
        Assertions.assertEquals((Object)mockKey, (Object)cache.getKeyVersion("k1@0"));
        ((KeyProvider)Mockito.verify((Object)mockProv, (VerificationMode)Mockito.times((int)2))).getKeyVersion((String)Mockito.eq((Object)"k1@0"));
    }
}

