/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto;

import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import org.apache.hadoop.crypto.CipherSuite;
import org.apache.hadoop.crypto.OpensslCipher;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestOpensslCipher {
    private static final byte[] key = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 16, 17, 18, 19, 20, 21, 22};
    private static final byte[] iv = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8};

    @Test
    @Timeout(value=120L)
    public void testGetInstance() throws Exception {
        Assumptions.assumeTrue((OpensslCipher.getLoadingFailureReason() == null ? 1 : 0) != 0);
        OpensslCipher cipher = OpensslCipher.getInstance((String)"AES/CTR/NoPadding");
        Assertions.assertTrue((cipher != null ? 1 : 0) != 0);
        try {
            cipher = OpensslCipher.getInstance((String)"AES2/CTR/NoPadding");
            Assertions.fail((String)"Should specify correct algorithm.");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        try {
            cipher = OpensslCipher.getInstance((String)"AES/CTR/NoPadding2");
            Assertions.fail((String)"Should specify correct padding.");
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            // empty catch block
        }
    }

    @Test
    @Timeout(value=120L)
    public void testUpdateArguments() throws Exception {
        Assumptions.assumeTrue((OpensslCipher.getLoadingFailureReason() == null ? 1 : 0) != 0);
        OpensslCipher cipher = OpensslCipher.getInstance((String)"AES/CTR/NoPadding");
        Assertions.assertTrue((cipher != null ? 1 : 0) != 0);
        cipher.init(1, key, iv);
        ByteBuffer input = ByteBuffer.allocate(1024);
        ByteBuffer output = ByteBuffer.allocate(1024);
        try {
            cipher.update(input, output);
            Assertions.fail((String)"Input and output buffer should be direct buffer.");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains("Direct buffers are required", e);
        }
        input = ByteBuffer.allocateDirect(1024);
        output = ByteBuffer.allocateDirect(1000);
        try {
            cipher.update(input, output);
            Assertions.fail((String)"Output buffer length should be sufficient to store output data");
        }
        catch (ShortBufferException e) {
            GenericTestUtils.assertExceptionContains("Output buffer is not sufficient", e);
        }
    }

    @Test
    @Timeout(value=120L)
    public void testDoFinalArguments() throws Exception {
        Assumptions.assumeTrue((OpensslCipher.getLoadingFailureReason() == null ? 1 : 0) != 0);
        OpensslCipher cipher = OpensslCipher.getInstance((String)"AES/CTR/NoPadding");
        Assertions.assertTrue((cipher != null ? 1 : 0) != 0);
        cipher.init(1, key, iv);
        ByteBuffer output = ByteBuffer.allocate(1024);
        try {
            cipher.doFinal(output);
            Assertions.fail((String)"Output buffer should be direct buffer.");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains("Direct buffer is required", e);
        }
    }

    @Test
    @Timeout(value=120L)
    public void testIsSupportedSuite() throws Exception {
        Assumptions.assumeTrue((OpensslCipher.getLoadingFailureReason() == null ? 1 : 0) != 0, (String)"Skipping due to failure of loading OpensslCipher.");
        Assertions.assertFalse((boolean)OpensslCipher.isSupported((CipherSuite)CipherSuite.UNKNOWN), (String)"Unknown suite must not be supported.");
        Assertions.assertTrue((boolean)OpensslCipher.isSupported((CipherSuite)CipherSuite.AES_CTR_NOPADDING), (String)"AES/CTR/NoPadding is not an optional suite.");
    }
}

