/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.CryptoCodec;
import org.apache.hadoop.crypto.OpensslAesCtrCryptoCodec;
import org.apache.hadoop.crypto.TestCryptoStreams;
import org.apache.hadoop.crypto.random.OsSecureRandom;
import org.apache.hadoop.fs.CommonConfigurationKeysPublic;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestCryptoStreamsWithOpensslAesCtrCryptoCodec
extends TestCryptoStreams {
    @BeforeAll
    public static void init() throws Exception {
        GenericTestUtils.assumeInNativeProfile();
        Configuration conf = new Configuration();
        conf.set(CommonConfigurationKeysPublic.HADOOP_SECURITY_CRYPTO_CODEC_CLASSES_AES_CTR_NOPADDING_KEY, OpensslAesCtrCryptoCodec.class.getName());
        codec = CryptoCodec.getInstance((Configuration)conf);
        Assertions.assertNotNull((Object)codec, (String)("Unable to instantiate codec " + OpensslAesCtrCryptoCodec.class.getName() + ", is the required version of OpenSSL installed?"));
        Assertions.assertEquals((Object)OpensslAesCtrCryptoCodec.class.getCanonicalName(), (Object)codec.getClass().getCanonicalName());
    }

    @Test
    public void testCodecClosesRandom() throws Exception {
        GenericTestUtils.assumeInNativeProfile();
        Configuration conf = new Configuration();
        conf.set("hadoop.security.crypto.cipher.suite", "AES/CTR/NoPadding");
        conf.set(CommonConfigurationKeysPublic.HADOOP_SECURITY_CRYPTO_CODEC_CLASSES_AES_CTR_NOPADDING_KEY, OpensslAesCtrCryptoCodec.class.getName());
        conf.set("hadoop.security.secure.random.impl", OsSecureRandom.class.getName());
        CryptoCodec codecWithRandom = CryptoCodec.getInstance((Configuration)conf);
        Assertions.assertNotNull((Object)codecWithRandom, (String)("Unable to instantiate codec " + OpensslAesCtrCryptoCodec.class.getName() + ", is the required version of OpenSSL installed?"));
        OsSecureRandom random = (OsSecureRandom)((OpensslAesCtrCryptoCodec)codecWithRandom).getRandom();
        random.nextBytes(new byte[10]);
        Assertions.assertFalse((boolean)random.isClosed());
        codecWithRandom.close();
        Assertions.assertTrue((boolean)random.isClosed());
    }
}

