/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.CryptoCodec;
import org.apache.hadoop.crypto.CryptoInputStream;
import org.apache.hadoop.crypto.CryptoOutputStream;
import org.apache.hadoop.crypto.CryptoStreamsTestBase;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestCryptoStreamsNormal
extends CryptoStreamsTestBase {
    private byte[] buffer;
    private int bufferLen;

    @BeforeAll
    public static void init() throws Exception {
        Configuration conf = new Configuration();
        codec = CryptoCodec.getInstance((Configuration)conf);
    }

    @AfterAll
    public static void shutdown() throws Exception {
    }

    @Override
    protected OutputStream getOutputStream(int bufferSize, byte[] key, byte[] iv) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(){

            @Override
            public void flush() throws IOException {
                TestCryptoStreamsNormal.this.buffer = this.buf;
                TestCryptoStreamsNormal.this.bufferLen = this.count;
            }

            @Override
            public void close() throws IOException {
                TestCryptoStreamsNormal.this.buffer = this.buf;
                TestCryptoStreamsNormal.this.bufferLen = this.count;
            }
        };
        return new CryptoOutputStream((OutputStream)out, codec, bufferSize, key, iv);
    }

    @Override
    protected InputStream getInputStream(int bufferSize, byte[] key, byte[] iv) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(this.buffer, 0, this.bufferLen);
        return new CryptoInputStream((InputStream)in, codec, bufferSize, key, iv);
    }

    @Override
    @Disabled(value="Wrapped stream doesn't support Syncable")
    @Test
    @Timeout(value=10L)
    public void testSyncable() throws IOException {
    }

    @Override
    @Disabled(value="Wrapped stream doesn't support PositionedRead")
    @Test
    @Timeout(value=10L)
    public void testPositionedRead() throws IOException {
    }

    @Override
    @Disabled(value="Wrapped stream doesn't support ByteBufferPositionedReadable")
    @Test
    @Timeout(value=10L)
    public void testPositionedReadWithByteBuffer() throws IOException {
    }

    @Override
    @Disabled(value="Wrapped stream doesn't support ByteBufferPositionedReadable")
    @Test
    @Timeout(value=10L)
    public void testByteBufferReadFully() throws Exception {
    }

    @Override
    @Disabled(value="Wrapped stream doesn't support ReadFully")
    @Test
    @Timeout(value=10L)
    public void testReadFully() throws IOException {
    }

    @Override
    @Disabled(value="Wrapped stream doesn't support Seek")
    @Test
    @Timeout(value=10L)
    public void testSeek() throws IOException {
    }

    @Override
    @Disabled(value="Wrapped stream doesn't support ByteBufferRead")
    @Test
    @Timeout(value=10L)
    public void testByteBufferRead() throws IOException {
    }

    @Override
    @Disabled(value="Wrapped stream doesn't support ByteBufferPositionedReadable")
    @Test
    @Timeout(value=10L)
    public void testByteBufferPread() throws IOException {
    }

    @Override
    @Disabled(value="Wrapped stream doesn't support ByteBufferRead, Seek")
    @Test
    @Timeout(value=10L)
    public void testCombinedOp() throws IOException {
    }

    @Override
    @Disabled(value="Wrapped stream doesn't support SeekToNewSource")
    @Test
    @Timeout(value=10L)
    public void testSeekToNewSource() throws IOException {
    }

    @Override
    @Disabled(value="Wrapped stream doesn't support HasEnhancedByteBufferAccess")
    @Test
    @Timeout(value=10L)
    public void testHasEnhancedByteBufferAccess() throws IOException {
    }

    @Override
    @Disabled(value="ByteArrayInputStream does not support unbuffer")
    @Test
    public void testUnbuffer() throws Exception {
    }
}

