/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.conf;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestGetInstances {
    @Test
    public void testGetInstances() throws Exception {
        Configuration conf = new Configuration();
        List classes = conf.getInstances("no.such.property", SampleInterface.class);
        Assertions.assertTrue((boolean)classes.isEmpty());
        conf.set("empty.property", "");
        classes = conf.getInstances("empty.property", SampleInterface.class);
        Assertions.assertTrue((boolean)classes.isEmpty());
        conf.setStrings("some.classes", new String[]{SampleClass.class.getName(), AnotherClass.class.getName()});
        classes = conf.getInstances("some.classes", SampleInterface.class);
        Assertions.assertEquals((int)2, (int)classes.size());
        try {
            conf.setStrings("some.classes", new String[]{SampleClass.class.getName(), AnotherClass.class.getName(), String.class.getName()});
            conf.getInstances("some.classes", SampleInterface.class);
            Assertions.fail((String)"java.lang.String does not implement SampleInterface");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            conf.setStrings("some.classes", new String[]{SampleClass.class.getName(), AnotherClass.class.getName(), "no.such.Class"});
            conf.getInstances("some.classes", SampleInterface.class);
            Assertions.fail((String)"no.such.Class does not exist");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    static interface SampleInterface {
    }

    static class SampleClass
    implements SampleInterface {
        SampleClass() {
        }
    }

    static class AnotherClass
    implements ChildInterface {
        AnotherClass() {
        }
    }

    static interface ChildInterface
    extends SampleInterface {
    }
}

