/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.conf;

import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestConfigurationSubclass {
    private static final String EMPTY_CONFIGURATION_XML = "/org/apache/hadoop/conf/empty-configuration.xml";

    @Test
    public void testGetProps() {
        SubConf conf = new SubConf(true);
        Properties properties = conf.getProperties();
        Assertions.assertNotNull((Object)properties.getProperty("hadoop.tmp.dir"), (String)"hadoop.tmp.dir is not set");
    }

    @Test
    public void testReload() throws Throwable {
        SubConf conf = new SubConf(true);
        Assertions.assertFalse((boolean)conf.isReloaded());
        Configuration.addDefaultResource((String)EMPTY_CONFIGURATION_XML);
        Assertions.assertTrue((boolean)conf.isReloaded());
        Properties properties = conf.getProperties();
    }

    @Test
    public void testReloadNotQuiet() throws Throwable {
        SubConf conf = new SubConf(true);
        conf.setQuietMode(false);
        Assertions.assertFalse((boolean)conf.isReloaded());
        conf.addResource("not-a-valid-resource");
        Assertions.assertFalse((boolean)conf.isReloaded());
        try {
            Properties properties = conf.getProperties();
            Assertions.fail((String)"Should not have got here");
        }
        catch (RuntimeException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("not found"), (String)e.toString());
        }
    }

    private static class SubConf
    extends Configuration {
        private boolean reloaded;

        private SubConf(boolean loadDefaults) {
            super(loadDefaults);
        }

        public Properties getProperties() {
            return super.getProps();
        }

        public void reloadConfiguration() {
            super.reloadConfiguration();
            this.reloaded = true;
        }

        public boolean isReloaded() {
            return this.reloaded;
        }

        public void setReloaded(boolean reloaded) {
            this.reloaded = reloaded;
        }
    }
}

