/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.conf;

import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.test.ReflectionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Disabled
public abstract class TestConfigurationFieldsBase {
    private static final Logger LOG = LoggerFactory.getLogger(TestConfigurationFieldsBase.class);
    private static final Logger LOG_CONFIG = LoggerFactory.getLogger((String)"org.apache.hadoop.conf.TestConfigurationFieldsBase.config");
    private static final Logger LOG_XML = LoggerFactory.getLogger((String)"org.apache.hadoop.conf.TestConfigurationFieldsBase.xml");
    private static final String VALID_PROP_REGEX = "^[A-Za-z][A-Za-z0-9_-]+(\\.[A-Za-z%s0-9_-]+)+$";
    private static final Pattern validPropertiesPattern = Pattern.compile("^[A-Za-z][A-Za-z0-9_-]+(\\.[A-Za-z%s0-9_-]+)+$");
    protected String xmlFilename = null;
    protected Class[] configurationClasses = null;
    protected boolean errorIfMissingConfigProps = false;
    protected boolean errorIfMissingXmlProps = false;
    protected Set<String> configurationPropsToSkipCompare = new HashSet<String>();
    protected Set<String> configurationPrefixToSkipCompare = new HashSet<String>();
    protected Set<String> xmlPropsToSkipCompare = new HashSet<String>();
    protected Set<String> xmlPrefixToSkipCompare = new HashSet<String>();
    private Map<String, String> configurationMemberVariables = null;
    private Map<String, String> configurationDefaultVariables = null;
    private Map<String, String> xmlKeyValueMap = null;
    private Set<String> configurationFieldsMissingInXmlFile = null;
    private Set<String> xmlFieldsMissingInConfiguration = null;
    protected Set<String> filtersForDefaultValueCollisionCheck = new HashSet<String>();

    public abstract void initializeMemberVariables();

    private Map<String, String> extractMemberVariablesFromConfigurationFields(Field[] fields) {
        if (fields == null) {
            return null;
        }
        HashMap<String, String> validConfigProperties = new HashMap<String, String>();
        HashSet<String> fieldsNotPassedRegex = new HashSet<String>();
        for (Field f : fields) {
            String value;
            LOG_CONFIG.debug("Field: {}", (Object)f);
            if (!(Modifier.isStatic(f.getModifiers()) && Modifier.isPublic(f.getModifiers()) && Modifier.isFinal(f.getModifiers()))) {
                LOG_CONFIG.debug("  Is skipped as it is not public static final");
                continue;
            }
            if (!f.getType().getName().equals("java.lang.String")) {
                LOG_CONFIG.debug("  Is skipped as it is not type of String");
                continue;
            }
            if (TestConfigurationFieldsBase.isFieldADefaultValue(f)) {
                LOG_CONFIG.debug("  Is skipped as it is a 'default value field'");
                continue;
            }
            try {
                value = (String)f.get(null);
            }
            catch (IllegalAccessException iaException) {
                LOG_CONFIG.debug("  Is skipped as it cannot be converted to a String");
                continue;
            }
            LOG_CONFIG.debug("  Value: {}", (Object)value);
            if (value.endsWith(".xml") || value.endsWith(".") || value.endsWith("-")) {
                LOG_CONFIG.debug("  Is skipped as it a 'partial property'");
                continue;
            }
            if (this.configurationPropsToSkipCompare.contains(value)) {
                LOG_CONFIG.debug("  Is skipped as it is registered as a property to be skipped");
                continue;
            }
            boolean skipPrefix = false;
            for (String cfgPrefix : this.configurationPrefixToSkipCompare) {
                if (!value.startsWith(cfgPrefix)) continue;
                skipPrefix = true;
                LOG_CONFIG.debug("  Is skipped as it is starts with a registered property prefix to skip: {}", (Object)cfgPrefix);
                break;
            }
            if (skipPrefix) continue;
            Matcher m = validPropertiesPattern.matcher(value);
            if (!m.find()) {
                LOG_CONFIG.debug("  Passes Regex: false");
                fieldsNotPassedRegex.add(f.getName());
                continue;
            }
            LOG_CONFIG.debug("  Passes Regex: true");
            if (!validConfigProperties.containsKey(value)) {
                validConfigProperties.put(value, f.getName());
                continue;
            }
            LOG_CONFIG.debug("ERROR: Already found key for property " + value);
        }
        LOG_CONFIG.debug("Listing fields did not pass regex pattern: {}", fieldsNotPassedRegex);
        return validConfigProperties;
    }

    private Map<String, String> extractPropertiesFromXml(String filename) {
        if (filename == null) {
            return null;
        }
        Configuration conf = new Configuration(false);
        conf.setAllowNullValueProperties(true);
        conf.addResource(filename);
        HashMap<String, String> retVal = new HashMap<String, String>();
        Iterator kvItr = conf.iterator();
        while (kvItr.hasNext()) {
            Map.Entry entry = (Map.Entry)kvItr.next();
            String key = (String)entry.getKey();
            if (this.xmlPropsToSkipCompare.contains(key)) {
                LOG_XML.debug("  Skipping Full Key: {}", (Object)key);
                continue;
            }
            if (this.xmlPrefixToSkipCompare.stream().anyMatch(key::startsWith)) {
                LOG_XML.debug("  Skipping Prefix Key: " + key);
                continue;
            }
            if (conf.onlyKeyExists(key)) {
                retVal.put(key, null);
                LOG_XML.debug("  XML Key, Null Value: " + key);
            } else if (conf.get(key) != null) {
                retVal.put(key, (String)entry.getValue());
                LOG_XML.debug("  XML Key, Valid Value: " + key);
            }
            kvItr.remove();
        }
        return retVal;
    }

    private static boolean isFieldADefaultValue(Field field) {
        return field.getName().startsWith("DEFAULT_") || field.getName().endsWith("_DEFAULT");
    }

    private Map<String, String> extractDefaultVariablesFromConfigurationFields(Field[] fields) {
        if (fields == null) {
            return null;
        }
        HashMap<String, String> retVal = new HashMap<String, String>();
        for (Field f : fields) {
            if (!Modifier.isStatic(f.getModifiers()) || !Modifier.isPublic(f.getModifiers()) || !Modifier.isFinal(f.getModifiers()) || !TestConfigurationFieldsBase.isFieldADefaultValue(f) || retVal.containsKey(f.getName())) continue;
            try {
                String s = ReflectionUtils.getStringValueOfField(f);
                retVal.put(f.getName(), s);
            }
            catch (IllegalAccessException iaException) {
                LOG.error("{}", (Object)f, (Object)iaException);
            }
        }
        return retVal;
    }

    private static Set<String> compareConfigurationToXmlFields(Map<String, String> keyMap1, Map<String, String> keyMap2) {
        HashSet<String> retVal = new HashSet<String>(keyMap1.keySet());
        retVal.removeAll(keyMap2.keySet());
        return retVal;
    }

    @BeforeEach
    public void setupTestConfigurationFields() {
        this.initializeMemberVariables();
        Assertions.assertNotNull((Object)this.xmlFilename, (String)"XML file name is null");
        Assertions.assertNotNull((Object)this.configurationClasses, (String)"Configuration classes array is null");
        this.configurationMemberVariables = new HashMap<String, String>();
        LOG_CONFIG.debug("Reading configuration classes\n");
        for (Class c : this.configurationClasses) {
            Field[] fields = c.getDeclaredFields();
            Map<String, String> memberMap = this.extractMemberVariablesFromConfigurationFields(fields);
            if (memberMap == null) continue;
            this.configurationMemberVariables.putAll(memberMap);
        }
        LOG_CONFIG.debug("\n=====\n");
        LOG_XML.debug("Reading XML property files\n");
        this.xmlKeyValueMap = this.extractPropertiesFromXml(this.xmlFilename);
        LOG_XML.debug("\n=====\n");
        LOG.debug("Reading Config property files for defaults\n");
        this.configurationDefaultVariables = new HashMap<String, String>();
        Arrays.stream(this.configurationClasses).map(Class::getDeclaredFields).map(this::extractDefaultVariablesFromConfigurationFields).filter(Objects::nonNull).forEach(map -> this.configurationDefaultVariables.putAll((Map<String, String>)map));
        LOG.debug("\n=====\n");
        this.configurationFieldsMissingInXmlFile = TestConfigurationFieldsBase.compareConfigurationToXmlFields(this.configurationMemberVariables, this.xmlKeyValueMap);
        this.xmlFieldsMissingInConfiguration = TestConfigurationFieldsBase.compareConfigurationToXmlFields(this.xmlKeyValueMap, this.configurationMemberVariables);
    }

    @Test
    public void testCompareConfigurationClassAgainstXml() {
        Assertions.assertNotNull((Object)this.xmlFilename, (String)"XML file name is null");
        Assertions.assertNotNull((Object)this.configurationClasses, (String)"Configuration classes array is null");
        int missingXmlSize = this.configurationFieldsMissingInXmlFile.size();
        for (Class c : this.configurationClasses) {
            LOG.info("Configuration class: {}", (Object)c.toString());
        }
        LOG.info("({} member variables)\n", (Object)this.configurationMemberVariables.size());
        StringBuilder xmlErrorMsg = new StringBuilder();
        for (Class c : this.configurationClasses) {
            xmlErrorMsg.append(c);
            xmlErrorMsg.append(" ");
        }
        xmlErrorMsg.append("has ");
        xmlErrorMsg.append(missingXmlSize);
        xmlErrorMsg.append(" variables missing in ");
        xmlErrorMsg.append(this.xmlFilename);
        LOG.error(xmlErrorMsg.toString());
        if (missingXmlSize == 0) {
            LOG.info("  (None)");
        } else {
            this.appendMissingEntries(xmlErrorMsg, this.configurationFieldsMissingInXmlFile);
        }
        LOG.info("\n=====\n");
        if (this.errorIfMissingXmlProps) {
            Assertions.assertEquals((int)0, (int)missingXmlSize, (String)xmlErrorMsg.toString());
        }
    }

    private void appendMissingEntries(StringBuilder sb, Set<String> missing) {
        sb.append(" Entries: ");
        new TreeSet<String>(missing).forEach(s -> {
            LOG.info("  {}", s);
            sb.append("  ").append((String)s);
        });
    }

    @Test
    public void testCompareXmlAgainstConfigurationClass() {
        Assertions.assertNotNull((Object)this.xmlFilename, (String)"XML file name is null");
        Assertions.assertNotNull((Object)this.configurationClasses, (String)"Configuration classes array is null");
        int missingConfigSize = this.xmlFieldsMissingInConfiguration.size();
        LOG.info("File {} ({} properties)", (Object)this.xmlFilename, (Object)this.xmlKeyValueMap.size());
        StringBuilder configErrorMsg = new StringBuilder();
        configErrorMsg.append(this.xmlFilename);
        configErrorMsg.append(" has ");
        configErrorMsg.append(missingConfigSize);
        configErrorMsg.append(" properties missing in");
        Arrays.stream(this.configurationClasses).forEach(c -> configErrorMsg.append("  ").append(c));
        LOG.info(configErrorMsg.toString());
        if (missingConfigSize == 0) {
            LOG.info("  (None)");
        } else {
            this.appendMissingEntries(configErrorMsg, this.xmlFieldsMissingInConfiguration);
        }
        LOG.info("\n=====\n");
        if (this.errorIfMissingConfigProps) {
            Assertions.assertEquals((int)0, (int)missingConfigSize, (String)configErrorMsg.toString());
        }
    }

    @Test
    public void testXmlAgainstDefaultValuesInConfigurationClass() {
        Assertions.assertNotNull((Object)this.xmlFilename, (String)"XML file name is null");
        Assertions.assertNotNull(this.configurationMemberVariables, (String)"Configuration member variables is null");
        Assertions.assertNotNull(this.configurationMemberVariables, (String)"Configuration default variables is null");
        TreeSet<String> xmlPropertiesWithEmptyValue = new TreeSet<String>();
        TreeSet<String> configPropertiesWithNoDefaultConfig = new TreeSet<String>();
        HashMap<String, Object> xmlPropertiesMatchingConfigDefault = new HashMap<String, Object>();
        HashMap mismatchingXmlConfig = new HashMap();
        for (Map.Entry<String, String> entry : this.xmlKeyValueMap.entrySet()) {
            String xmlProperty = entry.getKey();
            String xmlDefaultValue = entry.getValue();
            String configProperty = this.configurationMemberVariables.get(xmlProperty);
            if (configProperty == null) continue;
            String defaultConfigName = null;
            String defaultConfigValue = null;
            String defaultNameCheck1 = "DEFAULT_" + configProperty;
            String defaultValueCheck1 = this.configurationDefaultVariables.get(defaultNameCheck1);
            String defaultNameCheck2 = null;
            if (configProperty.endsWith("_KEY")) {
                defaultNameCheck2 = configProperty.substring(0, configProperty.length() - 4) + "_DEFAULT";
            }
            String defaultValueCheck2 = this.configurationDefaultVariables.get(defaultNameCheck2);
            String defaultNameCheck3 = configProperty + "_DEFAULT";
            String defaultValueCheck3 = this.configurationDefaultVariables.get(defaultNameCheck3);
            if (defaultValueCheck1 != null) {
                defaultConfigName = defaultNameCheck1;
                defaultConfigValue = defaultValueCheck1;
            } else if (defaultValueCheck2 != null) {
                defaultConfigName = defaultNameCheck2;
                defaultConfigValue = defaultValueCheck2;
            } else if (defaultValueCheck3 != null) {
                defaultConfigName = defaultNameCheck3;
                defaultConfigValue = defaultValueCheck3;
            }
            if (defaultConfigValue != null) {
                if (xmlDefaultValue == null) {
                    xmlPropertiesWithEmptyValue.add(xmlProperty);
                    continue;
                }
                if (!xmlDefaultValue.equals(defaultConfigValue)) {
                    HashMap<String, String> xmlEntry = new HashMap<String, String>();
                    xmlEntry.put(xmlProperty, xmlDefaultValue);
                    HashMap<CallSite, String> configEntry = new HashMap<CallSite, String>();
                    configEntry.put((CallSite)((Object)defaultConfigName), defaultConfigValue);
                    mismatchingXmlConfig.put(xmlEntry, configEntry);
                    continue;
                }
                xmlPropertiesMatchingConfigDefault.put(xmlProperty, defaultConfigName);
                continue;
            }
            configPropertiesWithNoDefaultConfig.add(configProperty);
        }
        LOG.info("{} has {} properties that do not match the default Config value", (Object)this.xmlFilename, (Object)mismatchingXmlConfig.size());
        if (mismatchingXmlConfig.isEmpty()) {
            LOG.info("  (None)");
        } else {
            for (Map.Entry<String, String> entry : mismatchingXmlConfig.entrySet()) {
                ((Map)((Object)entry.getKey())).forEach((key, value) -> {
                    LOG.info("XML Property: {}", key);
                    LOG.info("XML Value:    {}", value);
                });
                ((Map)((Object)entry.getValue())).forEach((key, value) -> {
                    LOG.info("Config Name:  {}", key);
                    LOG.info("Config Value: {}", value);
                });
                LOG.info("");
            }
        }
        LOG.info("\n");
        LOG.info("Configuration(s) have {}  properties with no corresponding default member variable.  These will need to be verified manually.", (Object)configPropertiesWithNoDefaultConfig.size());
        if (configPropertiesWithNoDefaultConfig.isEmpty()) {
            LOG.info("  (None)");
        } else {
            configPropertiesWithNoDefaultConfig.forEach(c -> LOG.info(" {}", c));
        }
        LOG.info("\n");
        LOG.info("{} has {} properties with empty values", (Object)this.xmlFilename, (Object)xmlPropertiesWithEmptyValue.size());
        if (xmlPropertiesWithEmptyValue.isEmpty()) {
            LOG.info("  (None)");
        } else {
            xmlPropertiesWithEmptyValue.forEach(p -> LOG.info("  {}", p));
        }
        LOG.info("\n");
        LOG.info("{} has {} properties which match a corresponding Config variable", (Object)this.xmlFilename, (Object)xmlPropertiesMatchingConfigDefault.size());
        if (xmlPropertiesMatchingConfigDefault.isEmpty()) {
            LOG.info("  (None)");
        } else {
            xmlPropertiesMatchingConfigDefault.forEach((key, value) -> LOG.info("  {} / {}", key, value));
        }
        LOG.info("\n=====\n");
    }

    @Test
    public void testDefaultValueCollision() {
        for (String filter : this.filtersForDefaultValueCollisionCheck) {
            LOG.info("Checking if any of the default values whose name contains string \"{}\" collide.", (Object)filter);
            HashMap<String, String> filteredValues = new HashMap<String, String>();
            int valuesChecked = 0;
            for (Map.Entry<String, String> ent : this.configurationDefaultVariables.entrySet()) {
                if (!ent.getKey().contains(filter)) continue;
                if (StringUtils.isNumeric((CharSequence)ent.getValue())) {
                    String crtValue = filteredValues.putIfAbsent(ent.getValue(), ent.getKey());
                    Assertions.assertNull((Object)crtValue, (String)("Parameters " + ent.getKey() + " and " + crtValue + " are using the same default value!"));
                }
                ++valuesChecked;
            }
            LOG.info("Checked {} default values for collision.", (Object)valuesChecked);
        }
    }
}

