/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util.functional;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.statistics.IOStatisticsContext;
import org.apache.hadoop.util.functional.RemoteIterators;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class TaskPool {
    private static final Logger LOG = LoggerFactory.getLogger(TaskPool.class);
    private static final int SLEEP_INTERVAL_AWAITING_COMPLETION = 10;

    private TaskPool() {
    }

    private static void waitFor(Collection<Future<?>> futures, int sleepInterval) {
        int size = futures.size();
        LOG.debug("Waiting for {} tasks to complete", (Object)size);
        int oldNumFinished = 0;
        while (true) {
            int numFinished;
            if (oldNumFinished != (numFinished = (int)futures.stream().filter(Future::isDone).count())) {
                LOG.debug("Finished count -> {}/{}", (Object)numFinished, (Object)size);
                oldNumFinished = numFinished;
            }
            if (numFinished == size) break;
            try {
                Thread.sleep(sleepInterval);
            }
            catch (InterruptedException e) {
                futures.forEach(future -> future.cancel(true));
                Thread.currentThread().interrupt();
                break;
            }
        }
    }

    public static <I> Builder<I> foreach(Iterable<I> items) {
        return new Builder<I>(Objects.requireNonNull(items, "items"));
    }

    public static <I> Builder<I> foreach(RemoteIterator<I> items) {
        return new Builder<I>(items);
    }

    public static <I> Builder<I> foreach(I[] items) {
        return new Builder<I>(Arrays.asList(Objects.requireNonNull(items, "items")));
    }

    private static <E extends Exception> void throwOne(Collection<Exception> exceptions) throws E {
        Iterator<Exception> iter = exceptions.iterator();
        Exception e = iter.next();
        Class<?> exceptionClass = e.getClass();
        while (iter.hasNext()) {
            Exception other = iter.next();
            if (exceptionClass.isInstance(other)) continue;
            e.addSuppressed(other);
        }
        TaskPool.castAndThrow(e);
    }

    private static <E extends Exception> void castAndThrow(Exception e) throws E {
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw e;
    }

    public static class Builder<I> {
        private final RemoteIterator<I> items;
        private Submitter service = null;
        private FailureTask<I, ?> onFailure = null;
        private boolean stopOnFailure = false;
        private boolean suppressExceptions = false;
        private Task<I, ?> revertTask = null;
        private boolean stopRevertsOnFailure = false;
        private Task<I, ?> abortTask = null;
        private boolean stopAbortsOnFailure = false;
        private int sleepInterval = 10;
        private IOStatisticsContext ioStatisticsContext = null;

        Builder(RemoteIterator<I> items) {
            this.items = Objects.requireNonNull(items, "items");
        }

        Builder(Iterable<I> items) {
            this(RemoteIterators.remoteIteratorFromIterable(items));
        }

        public Builder<I> executeWith(@Nullable Submitter submitter) {
            this.service = submitter;
            return this;
        }

        public Builder<I> onFailure(FailureTask<I, ?> task) {
            this.onFailure = task;
            return this;
        }

        public Builder<I> stopOnFailure() {
            this.stopOnFailure = true;
            return this;
        }

        public Builder<I> suppressExceptions() {
            return this.suppressExceptions(true);
        }

        public Builder<I> suppressExceptions(boolean suppress) {
            this.suppressExceptions = suppress;
            return this;
        }

        public Builder<I> revertWith(Task<I, ?> task) {
            this.revertTask = task;
            return this;
        }

        public Builder<I> stopRevertsOnFailure() {
            this.stopRevertsOnFailure = true;
            return this;
        }

        public Builder<I> abortWith(Task<I, ?> task) {
            this.abortTask = task;
            return this;
        }

        public Builder<I> stopAbortsOnFailure() {
            this.stopAbortsOnFailure = true;
            return this;
        }

        public Builder<I> sleepInterval(int value) {
            this.sleepInterval = value;
            return this;
        }

        public <E extends Exception> boolean run(Task<I, E> task) throws E, IOException {
            Objects.requireNonNull(this.items, "items");
            if (!this.items.hasNext()) {
                return true;
            }
            if (this.service != null) {
                return this.runParallel(task);
            }
            return this.runSingleThreaded(task);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private <E extends Exception> boolean runSingleThreaded(Task<I, E> task) throws E, IOException {
            ArrayList<Exception> exceptions;
            block27: {
                RemoteIterator<I> iterator;
                block28: {
                    Iterator e2;
                    boolean failed;
                    ArrayList<I> succeeded = new ArrayList<I>();
                    exceptions = new ArrayList<Exception>();
                    iterator = this.items;
                    boolean threw = true;
                    try {
                        while (iterator.hasNext()) {
                            I item = iterator.next();
                            try {
                                task.run(item);
                                succeeded.add(item);
                            }
                            catch (Exception e2) {
                                exceptions.add(e2);
                                if (this.onFailure != null) {
                                    try {
                                        this.onFailure.run(item, e2);
                                    }
                                    catch (Exception failException) {
                                        LOG.error("Failed to clean up on failure", (Throwable)e2);
                                    }
                                }
                                if (!this.stopOnFailure) continue;
                            }
                        }
                        if (!(threw = false) && exceptions.isEmpty()) break block27;
                        if (this.revertTask == null) break block28;
                        failed = false;
                        e2 = succeeded.iterator();
                    }
                    catch (IOException iteratorIOE) {
                        try {
                            LOG.debug("IOException when iterating through {}", iterator, (Object)iteratorIOE);
                            throw iteratorIOE;
                        }
                        catch (Throwable throwable) {
                            if (threw || !exceptions.isEmpty()) {
                                boolean failed2;
                                if (this.revertTask != null) {
                                    failed2 = false;
                                    for (Object item : succeeded) {
                                        try {
                                            this.revertTask.run(item);
                                        }
                                        catch (Exception e3) {
                                            LOG.error("Failed to revert task", (Throwable)e3);
                                            failed2 = true;
                                        }
                                        if (!this.stopRevertsOnFailure || !failed2) continue;
                                    }
                                }
                                if (this.abortTask != null) {
                                    failed2 = false;
                                    while (iterator.hasNext()) {
                                        try {
                                            this.abortTask.run(iterator.next());
                                        }
                                        catch (Exception e4) {
                                            failed2 = true;
                                            LOG.error("Failed to abort task", (Throwable)e4);
                                        }
                                        if (!this.stopAbortsOnFailure || !failed2) continue;
                                    }
                                }
                            }
                            throw throwable;
                        }
                    }
                    while (e2.hasNext()) {
                        Object item = e2.next();
                        try {
                            this.revertTask.run(item);
                        }
                        catch (Exception e5) {
                            LOG.error("Failed to revert task", (Throwable)e5);
                            failed = true;
                        }
                        if (!this.stopRevertsOnFailure || !failed) continue;
                    }
                }
                if (this.abortTask != null) {
                    boolean failed = false;
                    while (iterator.hasNext()) {
                        try {
                            this.abortTask.run(iterator.next());
                        }
                        catch (Exception e) {
                            failed = true;
                            LOG.error("Failed to abort task", (Throwable)e);
                        }
                        if (!this.stopAbortsOnFailure || !failed) continue;
                    }
                }
            }
            if (!this.suppressExceptions && !exceptions.isEmpty()) {
                TaskPool.throwOne(exceptions);
            }
            return exceptions.isEmpty();
        }

        private <E extends Exception> boolean runParallel(Task<I, E> task) throws E, IOException {
            ConcurrentLinkedQueue succeeded = new ConcurrentLinkedQueue();
            ConcurrentLinkedQueue<Exception> exceptions = new ConcurrentLinkedQueue<Exception>();
            AtomicBoolean taskFailed = new AtomicBoolean(false);
            AtomicBoolean abortFailed = new AtomicBoolean(false);
            AtomicBoolean revertFailed = new AtomicBoolean(false);
            ArrayList futures = new ArrayList();
            this.ioStatisticsContext = IOStatisticsContext.getCurrentIOStatisticsContext();
            IOException iteratorIOE = null;
            RemoteIterator<I> iterator = this.items;
            try {
                while (iterator.hasNext()) {
                    I item = iterator.next();
                    futures.add(this.service.submit(() -> {
                        block21: {
                            this.setStatisticsContext();
                            try {
                                if (!this.stopOnFailure || !taskFailed.get()) {
                                    boolean threw = true;
                                    try {
                                        LOG.debug("Executing task");
                                        task.run(item);
                                        succeeded.add(item);
                                        LOG.debug("Task succeeded");
                                        threw = false;
                                        break block21;
                                    }
                                    catch (Exception e) {
                                        taskFailed.set(true);
                                        exceptions.add(e);
                                        LOG.info("Task failed {}", (Object)e.toString());
                                        LOG.debug("Task failed", (Throwable)e);
                                        if (this.onFailure != null) {
                                            try {
                                                this.onFailure.run(item, e);
                                            }
                                            catch (Exception failException) {
                                                LOG.warn("Failed to clean up on failure", (Throwable)e);
                                            }
                                        }
                                        break block21;
                                    }
                                    finally {
                                        if (threw) {
                                            taskFailed.set(true);
                                        }
                                    }
                                }
                                if (this.abortTask == null) break block21;
                                if (this.stopAbortsOnFailure && abortFailed.get()) {
                                    return;
                                }
                                boolean failed = true;
                                try {
                                    LOG.info("Aborting task");
                                    this.abortTask.run(item);
                                    failed = false;
                                }
                                catch (Exception e) {
                                    LOG.error("Failed to abort task", (Throwable)e);
                                }
                                finally {
                                    if (failed) {
                                        abortFailed.set(true);
                                    }
                                }
                            }
                            finally {
                                this.resetStatisticsContext();
                            }
                        }
                    }));
                }
            }
            catch (IOException e) {
                LOG.debug("IOException when iterating through {}", iterator, (Object)e);
                iteratorIOE = e;
                taskFailed.set(true);
            }
            TaskPool.waitFor(futures, this.sleepInterval);
            int futureCount = futures.size();
            futures.clear();
            if (taskFailed.get() && this.revertTask != null) {
                LOG.info("Reverting all {} succeeded tasks from {} futures", (Object)succeeded.size(), (Object)futureCount);
                for (Object item : succeeded) {
                    futures.add(this.service.submit(() -> {
                        if (this.stopRevertsOnFailure && revertFailed.get()) {
                            return;
                        }
                        boolean failed = true;
                        this.setStatisticsContext();
                        try {
                            this.revertTask.run(item);
                            failed = false;
                        }
                        catch (Exception e) {
                            LOG.error("Failed to revert task", (Throwable)e);
                        }
                        finally {
                            if (failed) {
                                revertFailed.set(true);
                            }
                            this.resetStatisticsContext();
                        }
                    }));
                }
                TaskPool.waitFor(futures, this.sleepInterval);
            }
            if (!this.suppressExceptions && !exceptions.isEmpty()) {
                TaskPool.throwOne(exceptions);
            }
            if (iteratorIOE != null) {
                throw iteratorIOE;
            }
            return !taskFailed.get();
        }

        private void setStatisticsContext() {
            if (this.ioStatisticsContext != null) {
                IOStatisticsContext.setThreadIOStatisticsContext(this.ioStatisticsContext);
            }
        }

        private void resetStatisticsContext() {
            if (this.ioStatisticsContext != null) {
                IOStatisticsContext.setThreadIOStatisticsContext(null);
            }
        }
    }

    public static interface Submitter {
        public Future<?> submit(Runnable var1);
    }

    @FunctionalInterface
    public static interface FailureTask<I, E extends Exception> {
        public void run(I var1, Exception var2) throws E;
    }

    @FunctionalInterface
    public static interface Task<I, E extends Exception> {
        public void run(I var1) throws E;
    }
}

