/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util.functional;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.hadoop.util.functional.CallableRaisingIOE;
import org.apache.hadoop.util.functional.FunctionalIO;

public class LazyAtomicReference<T>
implements CallableRaisingIOE<T>,
Supplier<T> {
    private final AtomicReference<T> reference = new AtomicReference();
    private final CallableRaisingIOE<? extends T> constructor;

    public LazyAtomicReference(CallableRaisingIOE<? extends T> constructor) {
        this.constructor = Objects.requireNonNull(constructor);
    }

    protected CallableRaisingIOE<? extends T> getConstructor() {
        return this.constructor;
    }

    protected AtomicReference<T> getReference() {
        return this.reference;
    }

    public synchronized T eval() throws IOException {
        T v = this.reference.get();
        if (v != null) {
            return v;
        }
        this.reference.set(Objects.requireNonNull(this.constructor.apply()));
        return this.reference.get();
    }

    @Override
    public final T apply() throws IOException {
        return this.eval();
    }

    @Override
    public final T get() throws UncheckedIOException {
        return (T)FunctionalIO.uncheckIOExceptions(this::eval);
    }

    public final boolean isSet() {
        return this.reference.get() != null;
    }

    public String toString() {
        return "LazyAtomicReference{reference=" + this.reference + "}";
    }

    public static <T> LazyAtomicReference<T> lazyAtomicReferenceFromSupplier(Supplier<T> supplier) {
        return new LazyAtomicReference<Object>(supplier::get);
    }
}

