/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.util.Preconditions;

public class GcTimeMonitor
extends Thread {
    private final long maxGcTimePercentage;
    private final long observationWindowMs;
    private final long sleepIntervalMs;
    private final GcTimeAlertHandler alertHandler;
    private final List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
    private final TsAndData[] gcDataBuf;
    private int bufSize;
    private int startIdx;
    private int endIdx;
    private long startTime;
    private final GcData curData = new GcData();
    private volatile boolean shouldRun = true;

    public GcTimeMonitor(long observationWindowMs, long sleepIntervalMs, int maxGcTimePercentage, GcTimeAlertHandler alertHandler) {
        Preconditions.checkArgument(observationWindowMs > 0L);
        Preconditions.checkArgument(sleepIntervalMs > 0L && sleepIntervalMs < observationWindowMs);
        Preconditions.checkArgument(maxGcTimePercentage >= 0 && maxGcTimePercentage <= 100);
        this.observationWindowMs = observationWindowMs;
        this.sleepIntervalMs = sleepIntervalMs;
        this.maxGcTimePercentage = maxGcTimePercentage;
        this.alertHandler = alertHandler;
        this.bufSize = (int)(observationWindowMs / sleepIntervalMs + 2L);
        Preconditions.checkArgument(this.bufSize <= 131072);
        this.gcDataBuf = new TsAndData[this.bufSize];
        for (int i = 0; i < this.bufSize; ++i) {
            this.gcDataBuf[i] = new TsAndData();
        }
        this.setDaemon(true);
        this.setName("GcTimeMonitor obsWindow = " + observationWindowMs + ", sleepInterval = " + sleepIntervalMs + ", maxGcTimePerc = " + maxGcTimePercentage);
    }

    @Override
    public void run() {
        this.curData.timestamp = this.startTime = System.currentTimeMillis();
        this.gcDataBuf[this.startIdx].setValues(this.startTime, 0L);
        while (this.shouldRun) {
            try {
                Thread.sleep(this.sleepIntervalMs);
            }
            catch (InterruptedException ie) {
                return;
            }
            this.calculateGCTimePercentageWithinObservedInterval();
            if (this.alertHandler == null || (long)this.curData.gcTimePercentage <= this.maxGcTimePercentage) continue;
            this.alertHandler.alert(this.curData.clone());
        }
    }

    public void shutdown() {
        this.shouldRun = false;
    }

    public GcData getLatestGcData() {
        return this.curData.clone();
    }

    private void calculateGCTimePercentageWithinObservedInterval() {
        long prevTotalGcTime = this.curData.totalGcTime;
        long totalGcTime = 0L;
        long totalGcCount = 0L;
        for (GarbageCollectorMXBean gcBean : this.gcBeans) {
            totalGcTime += gcBean.getCollectionTime();
            totalGcCount += gcBean.getCollectionCount();
        }
        long gcTimeWithinSleepInterval = totalGcTime - prevTotalGcTime;
        long ts = System.currentTimeMillis();
        long gcMonitorRunTime = ts - this.startTime;
        this.endIdx = (this.endIdx + 1) % this.bufSize;
        this.gcDataBuf[this.endIdx].setValues(ts, gcTimeWithinSleepInterval);
        long startObsWindowTs = ts - this.observationWindowMs;
        while (this.gcDataBuf[this.startIdx].ts < startObsWindowTs && this.startIdx != this.endIdx) {
            this.startIdx = (this.startIdx + 1) % this.bufSize;
        }
        long gcTimeWithinObservationWindow = Math.min(this.gcDataBuf[this.startIdx].gcPause, this.gcDataBuf[this.startIdx].ts - startObsWindowTs);
        if (this.startIdx != this.endIdx) {
            int i = (this.startIdx + 1) % this.bufSize;
            while (i != this.endIdx) {
                gcTimeWithinObservationWindow += this.gcDataBuf[i].gcPause;
                i = (i + 1) % this.bufSize;
            }
        }
        this.curData.update(ts, gcMonitorRunTime, totalGcTime, totalGcCount, (int)(gcTimeWithinObservationWindow * 100L / Math.min(this.observationWindowMs, gcMonitorRunTime)));
    }

    public static class GcData
    implements Cloneable {
        private long timestamp;
        private long gcMonitorRunTime;
        private long totalGcTime;
        private long totalGcCount;
        private int gcTimePercentage;

        public long getTimestamp() {
            return this.timestamp;
        }

        public long getGcMonitorRunTime() {
            return this.gcMonitorRunTime;
        }

        public long getAccumulatedGcTime() {
            return this.totalGcTime;
        }

        public long getAccumulatedGcCount() {
            return this.totalGcCount;
        }

        public int getGcTimePercentage() {
            return this.gcTimePercentage;
        }

        private synchronized void update(long inTimestamp, long inGcMonitorRunTime, long inTotalGcTime, long inTotalGcCount, int inGcTimePercentage) {
            this.timestamp = inTimestamp;
            this.gcMonitorRunTime = inGcMonitorRunTime;
            this.totalGcTime = inTotalGcTime;
            this.totalGcCount = inTotalGcCount;
            this.gcTimePercentage = inGcTimePercentage;
        }

        public synchronized GcData clone() {
            try {
                return (GcData)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static interface GcTimeAlertHandler {
        public void alert(GcData var1);
    }

    private static class TsAndData {
        private long ts;
        private long gcPause;

        private TsAndData() {
        }

        void setValues(long inTs, long inGcPause) {
            this.ts = inTs;
            this.gcPause = inGcPause;
        }
    }

    public static class Builder {
        private long observationWindowMs = TimeUnit.MINUTES.toMillis(1L);
        private long sleepIntervalMs = TimeUnit.SECONDS.toMillis(5L);
        private int maxGcTimePercentage = 100;
        private GcTimeAlertHandler handler = null;

        public Builder observationWindowMs(long value) {
            this.observationWindowMs = value;
            return this;
        }

        public Builder sleepIntervalMs(long value) {
            this.sleepIntervalMs = value;
            return this;
        }

        public Builder maxGcTimePercentage(int value) {
            this.maxGcTimePercentage = value;
            return this;
        }

        public Builder gcTimeAlertHandler(GcTimeAlertHandler value) {
            this.handler = value;
            return this;
        }

        public GcTimeMonitor build() {
            return new GcTimeMonitor(this.observationWindowMs, this.sleepIntervalMs, this.maxGcTimePercentage, this.handler);
        }
    }
}

