/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.service.launcher;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.service.launcher.IrqHandler;
import org.apache.hadoop.service.launcher.ServiceLauncher;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class InterruptEscalator
implements IrqHandler.Interrupted {
    private static final Logger LOG = LoggerFactory.getLogger(InterruptEscalator.class);
    private final AtomicBoolean signalAlreadyReceived = new AtomicBoolean(false);
    private final WeakReference<ServiceLauncher> ownerRef;
    private final int shutdownTimeMillis;
    private final List<IrqHandler> interruptHandlers = new ArrayList<IrqHandler>(2);
    private boolean forcedShutdownTimedOut;

    public InterruptEscalator(ServiceLauncher owner, int shutdownTimeMillis) {
        Preconditions.checkArgument(owner != null, "null owner");
        this.ownerRef = new WeakReference<ServiceLauncher>(owner);
        this.shutdownTimeMillis = shutdownTimeMillis;
    }

    private ServiceLauncher getOwner() {
        return (ServiceLauncher)this.ownerRef.get();
    }

    private Service getService() {
        ServiceLauncher owner = this.getOwner();
        return owner != null ? (Service)owner.getService() : null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("InterruptEscalator{");
        sb.append(" signalAlreadyReceived=").append(this.signalAlreadyReceived.get());
        ServiceLauncher owner = (ServiceLauncher)this.ownerRef.get();
        if (owner != null) {
            sb.append(", owner= ").append(owner.toString());
        }
        sb.append(", shutdownTimeMillis=").append(this.shutdownTimeMillis).append(", forcedShutdownTimedOut=").append(this.forcedShutdownTimedOut).append('}');
        return sb.toString();
    }

    @Override
    public void interrupted(IrqHandler.InterruptData interruptData) {
        Service service;
        Object message = "Service interrupted by " + interruptData.toString();
        LOG.warn((String)message);
        if (!this.signalAlreadyReceived.compareAndSet(false, true)) {
            message = "Repeated interrupt: escalating to a JVM halt";
            LOG.warn((String)message);
            ExitUtil.halt(3, (String)message);
        }
        if ((service = this.getService()) != null) {
            ServiceForcedShutdown shutdown = new ServiceForcedShutdown(service, this.shutdownTimeMillis);
            Thread thread = new Thread(shutdown);
            thread.setDaemon(true);
            thread.setName("Service Forced Shutdown");
            thread.start();
            try {
                thread.join(this.shutdownTimeMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            boolean bl = this.forcedShutdownTimedOut = !shutdown.getServiceWasShutdown();
            if (this.forcedShutdownTimedOut) {
                LOG.warn("Service did not shut down in time");
            }
        }
        ExitUtil.terminate(3, (String)message);
    }

    public synchronized void register(String signalName) {
        IrqHandler handler = new IrqHandler(signalName, this);
        handler.bind();
        this.interruptHandlers.add(handler);
    }

    public synchronized IrqHandler lookup(String signalName) {
        for (IrqHandler irqHandler : this.interruptHandlers) {
            if (!irqHandler.getName().equals(signalName)) continue;
            return irqHandler;
        }
        return null;
    }

    public boolean isForcedShutdownTimedOut() {
        return this.forcedShutdownTimedOut;
    }

    public boolean isSignalAlreadyReceived() {
        return this.signalAlreadyReceived.get();
    }

    protected static class ServiceForcedShutdown
    implements Runnable {
        private final int shutdownTimeMillis;
        private final AtomicBoolean serviceWasShutdown = new AtomicBoolean(false);
        private Service service;

        public ServiceForcedShutdown(Service service, int shutdownTimeMillis) {
            this.shutdownTimeMillis = shutdownTimeMillis;
            this.service = service;
        }

        @Override
        public void run() {
            if (this.service != null) {
                this.service.stop();
                this.serviceWasShutdown.set(this.service.waitForServiceToStop(this.shutdownTimeMillis));
            } else {
                this.serviceWasShutdown.set(true);
            }
        }

        private boolean getServiceWasShutdown() {
            return this.serviceWasShutdown.get();
        }
    }
}

