/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.IOException;
import java.util.LinkedList;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathIsNotDirectoryException;
import org.apache.hadoop.fs.shell.CommandFactory;
import org.apache.hadoop.fs.shell.FsCommand;
import org.apache.hadoop.fs.shell.PathData;
import org.apache.hadoop.util.Preconditions;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class SnapshotCommands
extends FsCommand {
    private static final String CREATE_SNAPSHOT = "createSnapshot";
    private static final String DELETE_SNAPSHOT = "deleteSnapshot";
    private static final String RENAME_SNAPSHOT = "renameSnapshot";

    SnapshotCommands() {
    }

    public static void registerCommands(CommandFactory factory) {
        factory.addClass(CreateSnapshot.class, "-createSnapshot");
        factory.addClass(DeleteSnapshot.class, "-deleteSnapshot");
        factory.addClass(RenameSnapshot.class, "-renameSnapshot");
    }

    public static class CreateSnapshot
    extends FsCommand {
        public static final String NAME = "createSnapshot";
        public static final String USAGE = "<snapshotDir> [<snapshotName>]";
        public static final String DESCRIPTION = "Create a snapshot on a directory";
        private String snapshotName = null;

        @Override
        protected void processPath(PathData item) throws IOException {
            if (!item.stat.isDirectory()) {
                throw new PathIsNotDirectoryException(item.toString());
            }
        }

        @Override
        protected void processOptions(LinkedList<String> args) throws IOException {
            if (args.size() == 0) {
                throw new IllegalArgumentException("<snapshotDir> is missing.");
            }
            if (args.size() > 2) {
                throw new IllegalArgumentException("Too many arguments.");
            }
            if (args.size() == 2) {
                this.snapshotName = args.removeLast();
            }
        }

        @Override
        protected void processArguments(LinkedList<PathData> items) throws IOException {
            super.processArguments(items);
            if (this.numErrors != 0) {
                return;
            }
            assert (items.size() == 1);
            PathData sroot = items.getFirst();
            Path snapshotPath = sroot.fs.createSnapshot(sroot.path, this.snapshotName);
            this.out.println("Created snapshot " + snapshotPath);
        }
    }

    public static class DeleteSnapshot
    extends FsCommand {
        public static final String NAME = "deleteSnapshot";
        public static final String USAGE = "<snapshotDir> <snapshotName>";
        public static final String DESCRIPTION = "Delete a snapshot from a directory";
        private String snapshotName;

        @Override
        protected void processPath(PathData item) throws IOException {
            if (!item.stat.isDirectory()) {
                throw new PathIsNotDirectoryException(item.toString());
            }
        }

        @Override
        protected void processOptions(LinkedList<String> args) throws IOException {
            if (args.size() != 2) {
                throw new IllegalArgumentException("Incorrect number of arguments.");
            }
            this.snapshotName = args.removeLast();
        }

        @Override
        protected void processArguments(LinkedList<PathData> items) throws IOException {
            super.processArguments(items);
            if (this.numErrors != 0) {
                return;
            }
            assert (items.size() == 1);
            PathData sroot = items.getFirst();
            sroot.fs.deleteSnapshot(sroot.path, this.snapshotName);
            this.out.println("Deleted snapshot " + this.snapshotName + " under " + sroot.path);
        }
    }

    public static class RenameSnapshot
    extends FsCommand {
        public static final String NAME = "renameSnapshot";
        public static final String USAGE = "<snapshotDir> <oldName> <newName>";
        public static final String DESCRIPTION = "Rename a snapshot from oldName to newName";
        private String oldName;
        private String newName;

        @Override
        protected void processPath(PathData item) throws IOException {
            if (!item.stat.isDirectory()) {
                throw new PathIsNotDirectoryException(item.toString());
            }
        }

        @Override
        protected void processOptions(LinkedList<String> args) throws IOException {
            if (args.size() != 3) {
                throw new IllegalArgumentException("Incorrect number of arguments.");
            }
            this.newName = args.removeLast();
            this.oldName = args.removeLast();
        }

        @Override
        protected void processArguments(LinkedList<PathData> items) throws IOException {
            super.processArguments(items);
            if (this.numErrors != 0) {
                return;
            }
            Preconditions.checkArgument(items.size() == 1);
            PathData sroot = items.getFirst();
            sroot.fs.renameSnapshot(sroot.path, this.oldName, this.newName);
            this.out.println("Renamed snapshot " + this.oldName + " to " + this.newName + " under " + sroot.path);
        }
    }
}

