/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.impl;

import java.nio.ByteBuffer;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.io.ByteBufferPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@VisibleForTesting
public final class TrackingByteBufferPool
implements ByteBufferPool,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(TrackingByteBufferPool.class);
    private final Map<ByteBuffer, ByteBufferAllocationStacktraceException> allocated = new IdentityHashMap<ByteBuffer, ByteBufferAllocationStacktraceException>();
    private final ByteBufferPool allocator;
    private final AtomicInteger bufferAllocations = new AtomicInteger();
    private final AtomicInteger bufferReleases = new AtomicInteger();

    public static TrackingByteBufferPool wrap(ByteBufferPool allocator) {
        return new TrackingByteBufferPool(allocator);
    }

    private TrackingByteBufferPool(ByteBufferPool allocator) {
        this.allocator = allocator;
    }

    public int getBufferAllocations() {
        return this.bufferAllocations.get();
    }

    public int getBufferReleases() {
        return this.bufferReleases.get();
    }

    @Override
    public synchronized ByteBuffer getBuffer(boolean direct, int size) {
        this.bufferAllocations.incrementAndGet();
        ByteBuffer buffer = this.allocator.getBuffer(direct, size);
        ByteBufferAllocationStacktraceException ex = ByteBufferAllocationStacktraceException.create();
        this.allocated.put(buffer, ex);
        LOG.debug("Creating ByteBuffer:{} size {} {}", new Object[]{System.identityHashCode(buffer), size, buffer, ex});
        return buffer;
    }

    @Override
    public synchronized void putBuffer(ByteBuffer buffer) throws ReleasingUnallocatedByteBufferException {
        this.bufferReleases.incrementAndGet();
        Objects.requireNonNull(buffer);
        LOG.debug("Releasing ByteBuffer: {}: {}", (Object)System.identityHashCode(buffer), (Object)buffer);
        if (this.allocated.remove(buffer) == null) {
            throw new ReleasingUnallocatedByteBufferException(buffer);
        }
        this.allocator.putBuffer(buffer);
        buffer.clear();
    }

    public boolean containsBuffer(ByteBuffer buffer) {
        return this.allocated.containsKey(Objects.requireNonNull(buffer));
    }

    public int size() {
        return this.allocated.size();
    }

    @Override
    public void close() throws LeakedByteBufferException {
        if (!this.allocated.isEmpty()) {
            this.allocated.keySet().forEach(buffer -> LOG.warn("Unreleased ByteBuffer {}; {}", (Object)System.identityHashCode(buffer), buffer));
            LeakedByteBufferException ex = new LeakedByteBufferException(this.allocated.size(), this.allocated.values().iterator().next());
            this.allocated.clear();
            throw ex;
        }
    }

    public static final class ByteBufferAllocationStacktraceException
    extends LeakDetectorHeapByteBufferPoolException {
        private static final ByteBufferAllocationStacktraceException WITHOUT_STACKTRACE = new ByteBufferAllocationStacktraceException(false);

        private static ByteBufferAllocationStacktraceException create() {
            return LOG.isDebugEnabled() ? new ByteBufferAllocationStacktraceException() : WITHOUT_STACKTRACE;
        }

        private ByteBufferAllocationStacktraceException() {
            super("Allocation stacktrace of the first ByteBuffer:");
        }

        private ByteBufferAllocationStacktraceException(boolean unused) {
            super("Log org.apache.hadoop.fs.impl.TrackingByteBufferPool at DEBUG for stack traces", null, false, false);
        }
    }

    public static final class ReleasingUnallocatedByteBufferException
    extends LeakDetectorHeapByteBufferPoolException {
        private ReleasingUnallocatedByteBufferException(ByteBuffer b) {
            super(String.format("Releasing a ByteBuffer instance that is not allocated by this buffer pool or already been released: %s size %d; hash code %s", b, b.capacity(), System.identityHashCode(b)));
        }
    }

    public static final class LeakedByteBufferException
    extends LeakDetectorHeapByteBufferPoolException {
        private final int count;

        private LeakedByteBufferException(int count, ByteBufferAllocationStacktraceException e) {
            super(count + " ByteBuffer object(s) is/are remained unreleased after closing this buffer pool.", e);
            this.count = count;
        }

        public int getCount() {
            return this.count;
        }
    }

    public static class LeakDetectorHeapByteBufferPoolException
    extends RuntimeException {
        private LeakDetectorHeapByteBufferPoolException(String msg) {
            super(msg);
        }

        private LeakDetectorHeapByteBufferPoolException(String msg, Throwable cause) {
            super(msg, cause);
        }

        private LeakDetectorHeapByteBufferPoolException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
            super(message, cause, enableSuppression, writableStackTrace);
        }
    }
}

