/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.util.EnumSet;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.test.AbstractHadoopTestBase;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.util.ConfigurationHelper;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.junit.Test;

public class TestConfigurationHelper
extends AbstractHadoopTestBase {
    private static <E extends Enum<E>> IterableAssert<E> assertEnumParse(String valueString, Class<E> enumClass, boolean ignoreUnknown) {
        EnumSet enumSet = ConfigurationHelper.parseEnumSet((String)"key", (String)valueString, enumClass, (boolean)ignoreUnknown);
        IterableAssert assertion = Assertions.assertThat((Iterable)enumSet);
        return (IterableAssert)assertion.describedAs("parsed enum set '%s'", new Object[]{valueString});
    }

    private Configuration confWithKey(String value) {
        Configuration conf = new Configuration(false);
        conf.set("key", value);
        return conf;
    }

    @Test
    public void testEnumParseAll() {
        TestConfigurationHelper.assertEnumParse("*", SimpleEnum.class, false).containsExactly((Object[])new SimpleEnum[]{SimpleEnum.a, SimpleEnum.b, SimpleEnum.c, SimpleEnum.i});
    }

    @Test
    public void testEnumParse() {
        TestConfigurationHelper.assertEnumParse("a, b,c", SimpleEnum.class, false).containsExactly((Object[])new SimpleEnum[]{SimpleEnum.a, SimpleEnum.b, SimpleEnum.c});
    }

    @Test
    public void testEnumCaseIndependence() {
        TestConfigurationHelper.assertEnumParse("A, B, C, I", SimpleEnum.class, false).containsExactly((Object[])new SimpleEnum[]{SimpleEnum.a, SimpleEnum.b, SimpleEnum.c, SimpleEnum.i});
    }

    @Test
    public void testEmptyArguments() {
        TestConfigurationHelper.assertEnumParse(" ", SimpleEnum.class, false).isEmpty();
    }

    @Test
    public void testUnknownEnumNotIgnored() throws Throwable {
        LambdaTestUtils.intercept(IllegalArgumentException.class, "unrecognized", () -> ConfigurationHelper.parseEnumSet((String)"key", (String)"c, unrecognized", SimpleEnum.class, (boolean)false));
    }

    @Test
    public void testUnknownEnumNotIgnoredThroughConf() throws Throwable {
        LambdaTestUtils.intercept(IllegalArgumentException.class, "unrecognized", () -> this.confWithKey("c, unrecognized").getEnumSet("key", SimpleEnum.class, false));
    }

    @Test
    public void testUnknownEnumIgnored() {
        TestConfigurationHelper.assertEnumParse("c, d", SimpleEnum.class, true).containsExactly((Object[])new SimpleEnum[]{SimpleEnum.c});
    }

    @Test
    public void testUnknownStarEnum() throws Throwable {
        LambdaTestUtils.intercept(IllegalArgumentException.class, "unrecognized", () -> ConfigurationHelper.parseEnumSet((String)"key", (String)"*, unrecognized", SimpleEnum.class, (boolean)false));
    }

    @Test
    public void testUnknownStarEnumIgnored() {
        TestConfigurationHelper.assertEnumParse("*, d", SimpleEnum.class, true).containsExactly((Object[])new SimpleEnum[]{SimpleEnum.a, SimpleEnum.b, SimpleEnum.c, SimpleEnum.i});
    }

    @Test
    public void testCaseConflictingEnumNotSupported() throws Throwable {
        LambdaTestUtils.intercept(IllegalArgumentException.class, "has multiple elements matching to lower case value", () -> ConfigurationHelper.parseEnumSet((String)"key", (String)"c, unrecognized", CaseConflictingEnum.class, (boolean)false));
    }

    @Test
    public void testEmptyEnumMap() {
        Assertions.assertThat((Map)ConfigurationHelper.mapEnumNamesToValues((String)"", EmptyEnum.class)).isEmpty();
    }

    @Test
    public void testEmptyStarEnum() {
        TestConfigurationHelper.assertEnumParse("*", EmptyEnum.class, false).isEmpty();
    }

    @Test
    public void testDuplicateValues() {
        TestConfigurationHelper.assertEnumParse("a, a, c, b, c", SimpleEnum.class, true).containsExactly((Object[])new SimpleEnum[]{SimpleEnum.a, SimpleEnum.b, SimpleEnum.c});
    }

    @Test
    public void testResolveEnumGood() throws Throwable {
        this.assertEnumResolution("c", SimpleEnum.c);
    }

    @Test
    public void testResolveEnumTrimmed() throws Throwable {
        this.assertEnumResolution("\n i \n ", SimpleEnum.i);
    }

    @Test
    public void testResolveEnumCaseConversion() throws Throwable {
        this.assertEnumResolution("C", SimpleEnum.c);
    }

    @Test
    public void testResolveEnumNoMatch() throws Throwable {
        this.assertEnumResolution("other", null);
    }

    @Test
    public void testResolveEnumEmpty() throws Throwable {
        this.assertEnumResolution("", null);
    }

    @Test
    public void testResolveEnumUpperCaseConversion() throws Throwable {
        this.assertUpperEnumResolution("C", UppercaseEnum.C);
    }

    @Test
    public void testResolveLowerToUpperCaseConversion() throws Throwable {
        this.assertUpperEnumResolution("i", UppercaseEnum.I);
    }

    private void assertEnumResolution(String value, SimpleEnum expected) {
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)((Object)((SimpleEnum)ConfigurationHelper.resolveEnum((Configuration)this.confWithKey(value), (String)"key", SimpleEnum.class, v -> null)))).describedAs("Resolution of %s", new Object[]{value})).isEqualTo((Object)expected);
    }

    private void assertUpperEnumResolution(String value, UppercaseEnum expected) {
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)((Object)((UppercaseEnum)ConfigurationHelper.resolveEnum((Configuration)this.confWithKey(value), (String)"key", UppercaseEnum.class, v -> null)))).describedAs("Resolution of %s", new Object[]{value})).isEqualTo((Object)expected);
    }

    private static enum SimpleEnum {
        a,
        b,
        c,
        i;

    }

    private static final class EmptyEnum
    extends Enum<EmptyEnum> {
        private static final /* synthetic */ EmptyEnum[] $VALUES;

        public static EmptyEnum[] values() {
            return (EmptyEnum[])$VALUES.clone();
        }

        public static EmptyEnum valueOf(String name) {
            return Enum.valueOf(EmptyEnum.class, name);
        }

        private static /* synthetic */ EmptyEnum[] $values() {
            return new EmptyEnum[0];
        }

        static {
            $VALUES = EmptyEnum.$values();
        }
    }

    private static enum UppercaseEnum {
        A,
        B,
        C,
        I;

    }

    private static enum CaseConflictingEnum {
        a,
        A;

    }
}

