/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.token.delegation.web;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.server.AuthenticationHandler;
import org.apache.hadoop.security.authentication.server.AuthenticationToken;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenAuthenticationHandler;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenAuthenticator;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenIdentifier;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.mockito.Mockito;

public class TestDelegationTokenAuthenticationHandlerWithMocks {
    private DelegationTokenAuthenticationHandler handler;
    @Rule
    public Timeout testTimeout = new Timeout(120000L, TimeUnit.MILLISECONDS);

    @Before
    public void setUp() throws Exception {
        Properties conf = new Properties();
        conf.put("delegation-token.token-kind", "foo");
        this.handler = new MockDelegationTokenAuthenticationHandler();
        this.handler.initTokenManager(conf);
    }

    @After
    public void cleanUp() {
        this.handler.destroy();
    }

    @Test
    public void testManagementOperations() throws Exception {
        Text testTokenKind = new Text("foo");
        String testRenewer = "bar";
        String testService = "192.168.64.101:8888";
        this.testNonManagementOperation();
        this.testManagementOperationErrors();
        this.testGetToken(null, null, testTokenKind);
        this.testGetToken("bar", null, testTokenKind);
        this.testCancelToken();
        this.testRenewToken("bar");
        Token<DelegationTokenIdentifier> testToken = this.testGetToken("bar", "192.168.64.101:8888", testTokenKind);
        this.testRenewToken(testToken, "bar");
        this.testCancelToken(testToken);
    }

    private void testNonManagementOperation() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getParameter("op")).thenReturn(null);
        Assert.assertTrue((boolean)this.handler.managementOperation(null, request, null));
        Mockito.when((Object)request.getParameter("op")).thenReturn((Object)"CREATE");
        Assert.assertTrue((boolean)this.handler.managementOperation(null, request, null));
    }

    private void testManagementOperationErrors() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)request.getQueryString()).thenReturn((Object)("op=" + DelegationTokenAuthenticator.DelegationTokenOperation.GETDELEGATIONTOKEN.toString()));
        Mockito.when((Object)request.getMethod()).thenReturn((Object)"FOO");
        Assert.assertFalse((boolean)this.handler.managementOperation(null, request, response));
        ((HttpServletResponse)Mockito.verify((Object)response)).sendError(Mockito.eq((int)400), Mockito.startsWith((String)"Wrong HTTP method"));
        Mockito.reset((Object[])new HttpServletResponse[]{response});
        Mockito.when((Object)request.getMethod()).thenReturn((Object)DelegationTokenAuthenticator.DelegationTokenOperation.GETDELEGATIONTOKEN.getHttpMethod());
        Assert.assertFalse((boolean)this.handler.managementOperation(null, request, response));
        ((HttpServletResponse)Mockito.verify((Object)response)).setStatus(Mockito.eq((int)401));
        ((HttpServletResponse)Mockito.verify((Object)response)).setHeader((String)Mockito.eq((Object)"WWW-Authenticate"), (String)Mockito.eq((Object)"mock"));
    }

    private Token<DelegationTokenIdentifier> testGetToken(String renewer, String service, Text expectedTokenKind) throws Exception {
        DelegationTokenAuthenticator.DelegationTokenOperation op = DelegationTokenAuthenticator.DelegationTokenOperation.GETDELEGATIONTOKEN;
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)request.getQueryString()).thenReturn((Object)("op=" + op.toString()));
        Mockito.when((Object)request.getMethod()).thenReturn((Object)op.getHttpMethod());
        AuthenticationToken token = (AuthenticationToken)Mockito.mock(AuthenticationToken.class);
        Mockito.when((Object)token.getUserName()).thenReturn((Object)"user");
        Mockito.when((Object)response.getWriter()).thenReturn((Object)new PrintWriter(new StringWriter()));
        Assert.assertFalse((boolean)this.handler.managementOperation(token, request, response));
        String queryString = "op=" + op.toString() + "&renewer=" + renewer;
        if (service != null) {
            queryString = queryString + "&service=" + service;
        }
        Mockito.when((Object)request.getQueryString()).thenReturn((Object)queryString);
        Mockito.reset((Object[])new HttpServletResponse[]{response});
        Mockito.reset((Object[])new AuthenticationToken[]{token});
        Mockito.when((Object)token.getUserName()).thenReturn((Object)"user");
        StringWriter writer = new StringWriter();
        PrintWriter pwriter = new PrintWriter(writer);
        Mockito.when((Object)response.getWriter()).thenReturn((Object)pwriter);
        Assert.assertFalse((boolean)this.handler.managementOperation(token, request, response));
        if (renewer == null) {
            ((AuthenticationToken)Mockito.verify((Object)token)).getUserName();
        } else {
            ((AuthenticationToken)Mockito.verify((Object)token)).getUserName();
        }
        ((HttpServletResponse)Mockito.verify((Object)response)).setStatus(200);
        ((HttpServletResponse)Mockito.verify((Object)response)).setContentType("application/json");
        pwriter.close();
        String responseOutput = writer.toString();
        String tokenLabel = "Token";
        Assert.assertTrue((boolean)responseOutput.contains(tokenLabel));
        Assert.assertTrue((boolean)responseOutput.contains("urlString"));
        ObjectMapper jsonMapper = new ObjectMapper();
        Map json = (Map)jsonMapper.readValue(responseOutput, Map.class);
        json = (Map)json.get(tokenLabel);
        String tokenStr = (String)json.get("urlString");
        Token dt = new Token();
        dt.decodeFromUrlString(tokenStr);
        this.handler.getTokenManager().verifyToken(dt);
        Assert.assertEquals((Object)expectedTokenKind, (Object)dt.getKind());
        if (service != null) {
            Assert.assertEquals((Object)service, (Object)dt.getService().toString());
        } else {
            Assert.assertEquals((long)0L, (long)dt.getService().getLength());
        }
        return dt;
    }

    private void testCancelToken() throws Exception {
        Token token = this.handler.getTokenManager().createToken(UserGroupInformation.getCurrentUser(), "foo");
        this.testCancelToken((Token<DelegationTokenIdentifier>)token);
    }

    private void testCancelToken(Token<DelegationTokenIdentifier> token) throws Exception {
        DelegationTokenAuthenticator.DelegationTokenOperation op = DelegationTokenAuthenticator.DelegationTokenOperation.CANCELDELEGATIONTOKEN;
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)request.getQueryString()).thenReturn((Object)("op=" + op.toString()));
        Mockito.when((Object)request.getMethod()).thenReturn((Object)op.getHttpMethod());
        Assert.assertFalse((boolean)this.handler.managementOperation(null, request, response));
        ((HttpServletResponse)Mockito.verify((Object)response)).sendError(Mockito.eq((int)400), Mockito.contains((String)"requires the parameter [token]"));
        Mockito.reset((Object[])new HttpServletResponse[]{response});
        Mockito.when((Object)request.getQueryString()).thenReturn((Object)("op=" + op.toString() + "&token=" + token.encodeToUrlString()));
        Assert.assertFalse((boolean)this.handler.managementOperation(null, request, response));
        ((HttpServletResponse)Mockito.verify((Object)response)).setStatus(200);
        try {
            this.handler.getTokenManager().verifyToken(token);
            Assert.fail();
        }
        catch (SecretManager.InvalidToken invalidToken) {
        }
        catch (Throwable ex) {
            Assert.fail();
        }
    }

    private void testRenewToken(String testRenewer) throws Exception {
        Token dToken = this.handler.getTokenManager().createToken(UserGroupInformation.getCurrentUser(), testRenewer);
        this.testRenewToken((Token<DelegationTokenIdentifier>)dToken, testRenewer);
    }

    private void testRenewToken(Token<DelegationTokenIdentifier> dToken, String testRenewer) throws Exception {
        DelegationTokenAuthenticator.DelegationTokenOperation op = DelegationTokenAuthenticator.DelegationTokenOperation.RENEWDELEGATIONTOKEN;
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)request.getQueryString()).thenReturn((Object)("op=" + op.toString()));
        Mockito.when((Object)request.getMethod()).thenReturn((Object)op.getHttpMethod());
        Assert.assertFalse((boolean)this.handler.managementOperation(null, request, response));
        ((HttpServletResponse)Mockito.verify((Object)response)).setStatus(Mockito.eq((int)401));
        ((HttpServletResponse)Mockito.verify((Object)response)).setHeader((String)Mockito.eq((Object)"WWW-Authenticate"), (String)Mockito.eq((Object)"mock"));
        Mockito.reset((Object[])new HttpServletResponse[]{response});
        AuthenticationToken token = (AuthenticationToken)Mockito.mock(AuthenticationToken.class);
        Mockito.when((Object)token.getUserName()).thenReturn((Object)testRenewer);
        Assert.assertFalse((boolean)this.handler.managementOperation(token, request, response));
        ((HttpServletResponse)Mockito.verify((Object)response)).sendError(Mockito.eq((int)400), Mockito.contains((String)"requires the parameter [token]"));
        Mockito.reset((Object[])new HttpServletResponse[]{response});
        StringWriter writer = new StringWriter();
        PrintWriter pwriter = new PrintWriter(writer);
        Mockito.when((Object)response.getWriter()).thenReturn((Object)pwriter);
        Mockito.when((Object)request.getQueryString()).thenReturn((Object)("op=" + op.toString() + "&token=" + dToken.encodeToUrlString()));
        Assert.assertFalse((boolean)this.handler.managementOperation(token, request, response));
        ((HttpServletResponse)Mockito.verify((Object)response)).setStatus(200);
        pwriter.close();
        Assert.assertTrue((boolean)writer.toString().contains("long"));
        this.handler.getTokenManager().verifyToken(dToken);
    }

    @Test
    public void testAuthenticate() throws Exception {
        this.testValidDelegationTokenQueryString();
        this.testValidDelegationTokenHeader();
        this.testInvalidDelegationTokenQueryString();
        this.testInvalidDelegationTokenHeader();
    }

    private void testValidDelegationTokenQueryString() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Token dToken = this.handler.getTokenManager().createToken(UserGroupInformation.getCurrentUser(), "user");
        Mockito.when((Object)request.getQueryString()).thenReturn((Object)("delegation=" + dToken.encodeToUrlString()));
        AuthenticationToken token = this.handler.authenticate(request, response);
        Assert.assertEquals((Object)UserGroupInformation.getCurrentUser().getShortUserName(), (Object)token.getUserName());
        Assert.assertEquals((long)0L, (long)token.getExpires());
        Assert.assertEquals((Object)this.handler.getType(), (Object)token.getType());
        Assert.assertTrue((boolean)token.isExpired());
    }

    private void testValidDelegationTokenHeader() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Token dToken = this.handler.getTokenManager().createToken(UserGroupInformation.getCurrentUser(), "user");
        Mockito.when((Object)request.getHeader((String)Mockito.eq((Object)"X-Hadoop-Delegation-Token"))).thenReturn((Object)dToken.encodeToUrlString());
        AuthenticationToken token = this.handler.authenticate(request, response);
        Assert.assertEquals((Object)UserGroupInformation.getCurrentUser().getShortUserName(), (Object)token.getUserName());
        Assert.assertEquals((long)0L, (long)token.getExpires());
        Assert.assertEquals((Object)this.handler.getType(), (Object)token.getType());
        Assert.assertTrue((boolean)token.isExpired());
    }

    private void testInvalidDelegationTokenQueryString() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)request.getQueryString()).thenReturn((Object)"delegation=invalid");
        StringWriter writer = new StringWriter();
        Mockito.when((Object)response.getWriter()).thenReturn((Object)new PrintWriter(writer));
        Assert.assertNull((Object)this.handler.authenticate(request, response));
        ((HttpServletResponse)Mockito.verify((Object)response)).setStatus(403);
        Assert.assertTrue((boolean)writer.toString().contains("AuthenticationException"));
    }

    private void testInvalidDelegationTokenHeader() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)request.getHeader((String)Mockito.eq((Object)"X-Hadoop-Delegation-Token"))).thenReturn((Object)"invalid");
        StringWriter writer = new StringWriter();
        Mockito.when((Object)response.getWriter()).thenReturn((Object)new PrintWriter(writer));
        Assert.assertNull((Object)this.handler.authenticate(request, response));
        Assert.assertTrue((boolean)writer.toString().contains("AuthenticationException"));
    }

    private String getToken() throws Exception {
        DelegationTokenAuthenticator.DelegationTokenOperation op = DelegationTokenAuthenticator.DelegationTokenOperation.GETDELEGATIONTOKEN;
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)request.getQueryString()).thenReturn((Object)("op=" + op.toString()));
        Mockito.when((Object)request.getMethod()).thenReturn((Object)op.getHttpMethod());
        AuthenticationToken token = (AuthenticationToken)Mockito.mock(AuthenticationToken.class);
        Mockito.when((Object)token.getUserName()).thenReturn((Object)"user");
        Mockito.when((Object)response.getWriter()).thenReturn((Object)new PrintWriter(new StringWriter()));
        Assert.assertFalse((boolean)this.handler.managementOperation(token, request, response));
        Mockito.when((Object)request.getQueryString()).thenReturn((Object)("op=" + op.toString() + "&renewer=null"));
        Mockito.reset((Object[])new HttpServletResponse[]{response});
        Mockito.reset((Object[])new AuthenticationToken[]{token});
        Mockito.when((Object)token.getUserName()).thenReturn((Object)"user");
        StringWriter writer = new StringWriter();
        PrintWriter pwriter = new PrintWriter(writer);
        Mockito.when((Object)response.getWriter()).thenReturn((Object)pwriter);
        Assert.assertFalse((boolean)this.handler.managementOperation(token, request, response));
        ((AuthenticationToken)Mockito.verify((Object)token)).getUserName();
        ((HttpServletResponse)Mockito.verify((Object)response)).setStatus(200);
        ((HttpServletResponse)Mockito.verify((Object)response)).setContentType("application/json");
        pwriter.close();
        String responseOutput = writer.toString();
        String tokenLabel = "Token";
        Assert.assertTrue((boolean)responseOutput.contains(tokenLabel));
        Assert.assertTrue((boolean)responseOutput.contains("urlString"));
        ObjectMapper jsonMapper = new ObjectMapper();
        Map json = (Map)jsonMapper.readValue(responseOutput, Map.class);
        json = (Map)json.get(tokenLabel);
        String tokenStr = (String)json.get("urlString");
        Token dt = new Token();
        dt.decodeFromUrlString(tokenStr);
        this.handler.getTokenManager().verifyToken(dt);
        return tokenStr;
    }

    @Test
    public void testCannotGetTokenUsingToken() throws Exception {
        DelegationTokenAuthenticator.DelegationTokenOperation op = DelegationTokenAuthenticator.DelegationTokenOperation.GETDELEGATIONTOKEN;
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getMethod()).thenReturn((Object)op.getHttpMethod());
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)response.getWriter()).thenReturn((Object)new PrintWriter(new StringWriter()));
        String tokenStr = this.getToken();
        Mockito.when((Object)request.getQueryString()).thenReturn((Object)("op=" + op.toString() + "&renewer=null&delegation=" + tokenStr));
        Mockito.reset((Object[])new HttpServletResponse[]{response});
        StringWriter writer = new StringWriter();
        PrintWriter pwriter = new PrintWriter(writer);
        Mockito.when((Object)response.getWriter()).thenReturn((Object)pwriter);
        Assert.assertFalse((boolean)this.handler.managementOperation(null, request, response));
        ((HttpServletResponse)Mockito.verify((Object)response)).setStatus(401);
    }

    @Test
    public void testCannotRenewTokenUsingToken() throws Exception {
        DelegationTokenAuthenticator.DelegationTokenOperation op = DelegationTokenAuthenticator.DelegationTokenOperation.RENEWDELEGATIONTOKEN;
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getMethod()).thenReturn((Object)op.getHttpMethod());
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)response.getWriter()).thenReturn((Object)new PrintWriter(new StringWriter()));
        String tokenStr = this.getToken();
        Mockito.when((Object)request.getQueryString()).thenReturn((Object)("op=" + op.toString() + "&token=" + tokenStr + "&delegation=" + tokenStr));
        Mockito.reset((Object[])new HttpServletResponse[]{response});
        StringWriter writer = new StringWriter();
        PrintWriter pwriter = new PrintWriter(writer);
        Mockito.when((Object)response.getWriter()).thenReturn((Object)pwriter);
        Assert.assertFalse((boolean)this.handler.managementOperation(null, request, response));
        ((HttpServletResponse)Mockito.verify((Object)response)).setStatus(401);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriterNotClosed() throws Exception {
        Properties conf = new Properties();
        conf.put("delegation-token.token-kind", "foo");
        conf.put("delegation-token.json-mapper.AUTO_CLOSE_TARGET", "false");
        MockDelegationTokenAuthenticationHandler noAuthCloseHandler = new MockDelegationTokenAuthenticationHandler();
        try {
            noAuthCloseHandler.initTokenManager(conf);
            noAuthCloseHandler.initJsonFactory(conf);
            DelegationTokenAuthenticator.DelegationTokenOperation op = DelegationTokenAuthenticator.DelegationTokenOperation.GETDELEGATIONTOKEN;
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            Mockito.when((Object)request.getQueryString()).thenReturn((Object)("op=" + op.toString()));
            Mockito.when((Object)request.getMethod()).thenReturn((Object)op.getHttpMethod());
            AuthenticationToken token = (AuthenticationToken)Mockito.mock(AuthenticationToken.class);
            Mockito.when((Object)token.getUserName()).thenReturn((Object)"user");
            final MutableBoolean closed = new MutableBoolean();
            PrintWriter printWriterCloseCount = new PrintWriter(new StringWriter()){

                @Override
                public void close() {
                    closed.setValue(true);
                    super.close();
                }

                @Override
                public void write(String str) {
                    if (closed.booleanValue()) {
                        throw new RuntimeException("already closed!");
                    }
                    super.write(str);
                }
            };
            Mockito.when((Object)response.getWriter()).thenReturn((Object)printWriterCloseCount);
            Assert.assertFalse((boolean)noAuthCloseHandler.managementOperation(token, request, response));
        }
        finally {
            noAuthCloseHandler.destroy();
        }
    }

    public static class MockDelegationTokenAuthenticationHandler
    extends DelegationTokenAuthenticationHandler {
        public MockDelegationTokenAuthenticationHandler() {
            super(new AuthenticationHandler(){

                public String getType() {
                    return "T";
                }

                public void init(Properties config) throws ServletException {
                }

                public void destroy() {
                }

                public boolean managementOperation(AuthenticationToken token, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationException {
                    return false;
                }

                public AuthenticationToken authenticate(HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationException {
                    response.setStatus(401);
                    response.setHeader("WWW-Authenticate", "mock");
                    return null;
                }
            });
        }
    }
}

