/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.IOException;
import org.apache.hadoop.fs.viewfs.RegexMountPointInterceptorType;
import org.apache.hadoop.fs.viewfs.RegexMountPointResolvedDstPathReplaceInterceptor;
import org.junit.Assert;
import org.junit.Test;

public class TestRegexMountPointResolvedDstPathReplaceInterceptor {
    public String createSerializedString(String regex, String replaceString) {
        return RegexMountPointInterceptorType.REPLACE_RESOLVED_DST_PATH.getConfigName() + ":" + regex + ":" + replaceString;
    }

    @Test
    public void testDeserializeFromStringNormalCase() throws IOException {
        String srcRegex = "-";
        String replaceString = "_";
        String serializedString = this.createSerializedString(srcRegex, replaceString);
        RegexMountPointResolvedDstPathReplaceInterceptor interceptor = RegexMountPointResolvedDstPathReplaceInterceptor.deserializeFromString((String)serializedString);
        Assert.assertEquals((Object)srcRegex, (Object)interceptor.getSrcRegexString());
        Assert.assertEquals((Object)replaceString, (Object)interceptor.getReplaceString());
        Assert.assertNull((Object)interceptor.getSrcRegexPattern());
        interceptor.initialize();
        Assert.assertEquals((Object)srcRegex, (Object)interceptor.getSrcRegexPattern().toString());
    }

    @Test
    public void testDeserializeFromStringBadCase() throws IOException {
        String srcRegex = "-";
        String replaceString = "_";
        Object serializedString = this.createSerializedString(srcRegex, replaceString);
        serializedString = (String)serializedString + ":ddd";
        RegexMountPointResolvedDstPathReplaceInterceptor interceptor = RegexMountPointResolvedDstPathReplaceInterceptor.deserializeFromString((String)serializedString);
        Assert.assertNull((Object)interceptor);
    }

    @Test
    public void testSerialization() {
        String srcRegex = "word1";
        String replaceString = "word2";
        String serializedString = this.createSerializedString(srcRegex, replaceString);
        RegexMountPointResolvedDstPathReplaceInterceptor interceptor = new RegexMountPointResolvedDstPathReplaceInterceptor(srcRegex, replaceString);
        Assert.assertEquals((Object)interceptor.serializeToString(), (Object)serializedString);
    }

    @Test
    public void testInterceptSource() {
        String srcRegex = "word1";
        String replaceString = "word2";
        RegexMountPointResolvedDstPathReplaceInterceptor interceptor = new RegexMountPointResolvedDstPathReplaceInterceptor(srcRegex, replaceString);
        String sourcePath = "/a/b/l3/dd";
        Assert.assertEquals((Object)sourcePath, (Object)interceptor.interceptSource(sourcePath));
    }

    @Test
    public void testInterceptResolve() throws IOException {
        String pathAfterResolution = "/user-hadoop";
        String srcRegex = "hadoop";
        String replaceString = "hdfs";
        RegexMountPointResolvedDstPathReplaceInterceptor interceptor = new RegexMountPointResolvedDstPathReplaceInterceptor(srcRegex, replaceString);
        interceptor.initialize();
        Assert.assertEquals((Object)"/user-hdfs", (Object)interceptor.interceptResolvedDestPathStr(pathAfterResolution));
    }
}

