/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell.find;

import java.io.IOException;
import java.io.PrintStream;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.shell.PathData;
import org.apache.hadoop.fs.shell.find.FindOptions;
import org.apache.hadoop.fs.shell.find.MockFileSystem;
import org.apache.hadoop.fs.shell.find.Print;
import org.apache.hadoop.fs.shell.find.Result;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.mockito.Mockito;

public class TestPrint {
    private FileSystem mockFs;
    @Rule
    public Timeout globalTimeout = new Timeout(10000L, TimeUnit.MILLISECONDS);

    @Before
    public void resetMock() throws IOException {
        this.mockFs = MockFileSystem.setup();
    }

    @Test
    public void testPrint() throws IOException {
        Print print = new Print();
        PrintStream out = (PrintStream)Mockito.mock(PrintStream.class);
        FindOptions options = new FindOptions();
        options.setOut(out);
        print.setOptions(options);
        String filename = "/one/two/test";
        PathData item = new PathData(filename, this.mockFs.getConf());
        Assert.assertEquals((Object)Result.PASS, (Object)print.apply(item, -1));
        ((PrintStream)Mockito.verify((Object)out)).print(filename + "\n");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{out});
    }
}

