/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.naming.ConfigurationException;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.net.DNS;
import org.apache.hadoop.net.DomainNameResolver;
import org.apache.hadoop.net.DomainNameResolverFactory;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.HadoopKerberosName;
import org.apache.hadoop.security.KerberosInfo;
import org.apache.hadoop.security.SecurityInfo;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenInfo;
import org.apache.hadoop.thirdparty.com.google.common.net.InetAddresses;
import org.apache.hadoop.util.StopWatch;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.ZKUtil;
import org.apache.zookeeper.client.ZKClientConfig;
import org.apache.zookeeper.common.ClientX509Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.Name;
import org.xbill.DNS.ResolverConfig;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public final class SecurityUtil {
    public static final Logger LOG = LoggerFactory.getLogger(SecurityUtil.class);
    public static final String HOSTNAME_PATTERN = "_HOST";
    public static final String FAILED_TO_GET_UGI_MSG_HEADER = "Failed to obtain user group information:";
    @VisibleForTesting
    static boolean useIpForTokenService;
    @VisibleForTesting
    static HostResolver hostResolver;
    private static DomainNameResolver domainNameResolver;
    private static boolean logSlowLookups;
    private static int slowLookupThresholdMs;
    private static ServiceLoader<SecurityInfo> securityInfoProviders;
    private static SecurityInfo[] testProviders;

    private SecurityUtil() {
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static void setConfiguration(Configuration conf) {
        LOG.info("Updating Configuration");
        SecurityUtil.setConfigurationInternal(conf);
    }

    private static void setConfigurationInternal(Configuration conf) {
        boolean useIp = conf.getBoolean("hadoop.security.token.service.use_ip", true);
        SecurityUtil.setTokenServiceUseIp(useIp);
        logSlowLookups = conf.getBoolean("hadoop.security.dns.log-slow-lookups.enabled", false);
        slowLookupThresholdMs = conf.getInt("hadoop.security.dns.log-slow-lookups.threshold.ms", 1000);
        domainNameResolver = DomainNameResolverFactory.newInstance(conf, "hadoop.security.resolver.impl");
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public static void setTokenServiceUseIp(boolean flag) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Setting hadoop.security.token.service.use_ip to " + flag);
        }
        hostResolver = !(useIpForTokenService = flag) ? new QualifiedHostResolver() : new StandardHostResolver();
    }

    static boolean isTGSPrincipal(KerberosPrincipal principal) {
        if (principal == null) {
            return false;
        }
        return principal.getName().equals("krbtgt/" + principal.getRealm() + "@" + principal.getRealm());
    }

    protected static boolean isOriginalTGT(KerberosTicket ticket) {
        return SecurityUtil.isTGSPrincipal(ticket.getServer());
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static String getServerPrincipal(String principalConfig, String hostname) throws IOException {
        String[] components = SecurityUtil.getComponents(principalConfig);
        if (components == null || components.length != 3 || !components[1].equals(HOSTNAME_PATTERN)) {
            return principalConfig;
        }
        return SecurityUtil.replacePattern(components, hostname);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static String getServerPrincipal(String principalConfig, InetAddress addr) throws IOException {
        String[] components = SecurityUtil.getComponents(principalConfig);
        if (components == null || components.length != 3 || !components[1].equals(HOSTNAME_PATTERN)) {
            return principalConfig;
        }
        if (addr == null) {
            throw new IOException("Can't replace _HOST pattern since client address is null");
        }
        return SecurityUtil.replacePattern(components, domainNameResolver.getHostnameByIP(addr));
    }

    private static String[] getComponents(String principalConfig) {
        if (principalConfig == null) {
            return null;
        }
        return principalConfig.split("[/@]");
    }

    private static String replacePattern(String[] components, String hostname) throws IOException {
        String fqdn = hostname;
        if (fqdn == null || fqdn.isEmpty() || fqdn.equals("0.0.0.0")) {
            fqdn = SecurityUtil.getLocalHostName(null);
        }
        return components[0] + "/" + StringUtils.toLowerCase(fqdn) + "@" + components[2];
    }

    static String getLocalHostName(@Nullable Configuration conf) throws UnknownHostException {
        if (conf != null) {
            String dnsInterface = conf.get("hadoop.security.dns.interface");
            String nameServer = conf.get("hadoop.security.dns.nameserver");
            if (dnsInterface != null) {
                return DNS.getDefaultHost(dnsInterface, nameServer, true);
            }
            if (nameServer != null) {
                throw new IllegalArgumentException("hadoop.security.dns.nameserver requires hadoop.security.dns.interface. Check yourconfiguration.");
            }
        }
        return InetAddress.getLocalHost().getCanonicalHostName();
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static void login(Configuration conf, String keytabFileKey, String userNameKey) throws IOException {
        SecurityUtil.login(conf, keytabFileKey, userNameKey, SecurityUtil.getLocalHostName(conf));
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static void login(Configuration conf, String keytabFileKey, String userNameKey, String hostname) throws IOException {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return;
        }
        String keytabFilename = conf.get(keytabFileKey);
        if (keytabFilename == null || keytabFilename.length() == 0) {
            throw new IOException("Running in secure mode, but config doesn't have a keytab for key: " + keytabFileKey);
        }
        String principalConfig = conf.get(userNameKey, System.getProperty("user.name"));
        String principalName = SecurityUtil.getServerPrincipal(principalConfig, hostname);
        UserGroupInformation.loginUserFromKeytab(principalName, keytabFilename);
    }

    public static String buildDTServiceName(URI uri, int defPort) {
        String authority = uri.getAuthority();
        if (authority == null) {
            return null;
        }
        InetSocketAddress addr = NetUtils.createSocketAddr(authority, defPort);
        return SecurityUtil.buildTokenService(addr).toString();
    }

    public static String getHostFromPrincipal(String principalName) {
        return new HadoopKerberosName(principalName).getHostName();
    }

    @InterfaceAudience.Private
    public static void setSecurityInfoProviders(SecurityInfo ... providers) {
        testProviders = providers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KerberosInfo getKerberosInfo(Class<?> protocol, Configuration conf) {
        for (SecurityInfo provider : testProviders) {
            KerberosInfo result = provider.getKerberosInfo(protocol, conf);
            if (result == null) continue;
            return result;
        }
        ServiceLoader<SecurityInfo> serviceLoader = securityInfoProviders;
        synchronized (serviceLoader) {
            for (SecurityInfo provider : securityInfoProviders) {
                KerberosInfo result = provider.getKerberosInfo(protocol, conf);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public static String getClientPrincipal(Class<?> protocol, Configuration conf) {
        String user = null;
        KerberosInfo krbInfo = SecurityUtil.getKerberosInfo(protocol, conf);
        if (krbInfo != null) {
            String key = krbInfo.clientPrincipal();
            user = key != null && !key.isEmpty() ? conf.get(key) : null;
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TokenInfo getTokenInfo(Class<?> protocol, Configuration conf) {
        for (SecurityInfo provider : testProviders) {
            TokenInfo result = provider.getTokenInfo(protocol, conf);
            if (result == null) continue;
            return result;
        }
        ServiceLoader<SecurityInfo> serviceLoader = securityInfoProviders;
        synchronized (serviceLoader) {
            for (SecurityInfo provider : securityInfoProviders) {
                TokenInfo result = provider.getTokenInfo(protocol, conf);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public static InetSocketAddress getTokenServiceAddr(Token<?> token) {
        return NetUtils.createSocketAddr(token.getService().toString());
    }

    public static void setTokenService(Token<?> token, InetSocketAddress addr) {
        Text service = SecurityUtil.buildTokenService(addr);
        if (token != null) {
            token.setService(service);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Acquired token " + token);
            }
        } else {
            LOG.warn("Failed to get token for service " + service);
        }
    }

    public static Text buildTokenService(InetSocketAddress addr) {
        String host = null;
        if (useIpForTokenService) {
            if (addr.isUnresolved()) {
                throw new IllegalArgumentException(new UnknownHostException(addr.getHostName()));
            }
            host = addr.getAddress().getHostAddress();
        } else {
            host = StringUtils.toLowerCase(addr.getHostName());
        }
        return new Text(host + ":" + addr.getPort());
    }

    public static Text buildTokenService(URI uri) {
        return SecurityUtil.buildTokenService(NetUtils.createSocketAddr(uri.getAuthority()));
    }

    public static <T> T doAsLoginUserOrFatal(PrivilegedAction<T> action) {
        if (UserGroupInformation.isSecurityEnabled()) {
            UserGroupInformation ugi = null;
            try {
                ugi = UserGroupInformation.getLoginUser();
            }
            catch (IOException e) {
                LOG.error("Exception while getting login user", (Throwable)e);
                e.printStackTrace();
                Runtime.getRuntime().exit(-1);
            }
            return ugi.doAs(action);
        }
        return action.run();
    }

    public static <T> T doAsLoginUser(PrivilegedExceptionAction<T> action) throws IOException {
        return SecurityUtil.doAsUser(UserGroupInformation.getLoginUser(), action);
    }

    public static <T> T doAsCurrentUser(PrivilegedExceptionAction<T> action) throws IOException {
        return SecurityUtil.doAsUser(UserGroupInformation.getCurrentUser(), action);
    }

    private static <T> T doAsUser(UserGroupInformation ugi, PrivilegedExceptionAction<T> action) throws IOException {
        try {
            return ugi.doAs(action);
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    @InterfaceAudience.Private
    public static InetAddress getByName(String hostname) throws UnknownHostException {
        if (logSlowLookups || LOG.isTraceEnabled()) {
            StopWatch lookupTimer = new StopWatch().start();
            InetAddress result = hostResolver.getByName(hostname);
            long elapsedMs = lookupTimer.stop().now(TimeUnit.MILLISECONDS);
            if (elapsedMs >= (long)slowLookupThresholdMs) {
                LOG.warn("Slow name lookup for " + hostname + ". Took " + elapsedMs + " ms.");
            } else if (LOG.isTraceEnabled()) {
                LOG.trace("Name lookup for " + hostname + " took " + elapsedMs + " ms.");
            }
            return result;
        }
        return hostResolver.getByName(hostname);
    }

    public static UserGroupInformation.AuthenticationMethod getAuthenticationMethod(Configuration conf) {
        String value = conf.get("hadoop.security.authentication", "simple");
        try {
            return Enum.valueOf(UserGroupInformation.AuthenticationMethod.class, StringUtils.toUpperCase(value));
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("Invalid attribute value for hadoop.security.authentication of " + value);
        }
    }

    public static void setAuthenticationMethod(UserGroupInformation.AuthenticationMethod authenticationMethod, Configuration conf) {
        if (authenticationMethod == null) {
            authenticationMethod = UserGroupInformation.AuthenticationMethod.SIMPLE;
        }
        conf.set("hadoop.security.authentication", StringUtils.toLowerCase(authenticationMethod.toString()));
    }

    public static boolean isPrivilegedPort(int port) {
        return port < 1024;
    }

    public static List<ZKUtil.ZKAuthInfo> getZKAuthInfos(Configuration conf, String configKey) throws IOException {
        char[] zkAuthChars = conf.getPassword(configKey);
        String zkAuthConf = zkAuthChars != null ? String.valueOf(zkAuthChars) : null;
        try {
            zkAuthConf = ZKUtil.resolveConfIndirection(zkAuthConf);
            if (zkAuthConf != null) {
                return ZKUtil.parseAuth(zkAuthConf);
            }
            return Collections.emptyList();
        }
        catch (IOException | ZKUtil.BadAuthFormatException e) {
            LOG.error("Couldn't read Auth based on {}", (Object)configKey);
            throw e;
        }
    }

    public static void validateSslConfiguration(TruststoreKeystore truststoreKeystore) throws ConfigurationException {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)truststoreKeystore.keystoreLocation)) {
            throw new ConfigurationException("The keystore location parameter is empty for the ZooKeeper client connection.");
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)truststoreKeystore.keystorePassword)) {
            throw new ConfigurationException("The keystore password parameter is empty for the ZooKeeper client connection.");
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)truststoreKeystore.truststoreLocation)) {
            throw new ConfigurationException("The truststore location parameter is empty for the ZooKeeper client connection.");
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)truststoreKeystore.truststorePassword)) {
            throw new ConfigurationException("The truststore password parameter is empty for the ZooKeeper client connection.");
        }
    }

    public static void setSslConfiguration(ZKClientConfig zkClientConfig, TruststoreKeystore truststoreKeystore) throws ConfigurationException {
        SecurityUtil.setSslConfiguration(zkClientConfig, truststoreKeystore, new ClientX509Util());
    }

    public static void setSslConfiguration(ZKClientConfig zkClientConfig, TruststoreKeystore truststoreKeystore, ClientX509Util x509Util) throws ConfigurationException {
        SecurityUtil.validateSslConfiguration(truststoreKeystore);
        LOG.info("Configuring the ZooKeeper client to use SSL/TLS encryption for connecting to the ZooKeeper server.");
        LOG.debug("Configuring the ZooKeeper client with {} location: {}.", (Object)truststoreKeystore.keystoreLocation, (Object)"hadoop.zk.ssl.keystore.location");
        LOG.debug("Configuring the ZooKeeper client with {} location: {}.", (Object)truststoreKeystore.truststoreLocation, (Object)"hadoop.zk.ssl.truststore.location");
        zkClientConfig.setProperty("zookeeper.client.secure", "true");
        zkClientConfig.setProperty("zookeeper.clientCnxnSocket", "org.apache.zookeeper.ClientCnxnSocketNetty");
        zkClientConfig.setProperty(x509Util.getSslKeystoreLocationProperty(), truststoreKeystore.keystoreLocation);
        zkClientConfig.setProperty(x509Util.getSslKeystorePasswdProperty(), truststoreKeystore.keystorePassword);
        zkClientConfig.setProperty(x509Util.getSslTruststoreLocationProperty(), truststoreKeystore.truststoreLocation);
        zkClientConfig.setProperty(x509Util.getSslTruststorePasswdProperty(), truststoreKeystore.truststorePassword);
    }

    static {
        SecurityUtil.setConfigurationInternal(new Configuration());
        securityInfoProviders = ServiceLoader.load(SecurityInfo.class);
        testProviders = new SecurityInfo[0];
    }

    protected static class QualifiedHostResolver
    implements HostResolver {
        private List<String> searchDomains = new ArrayList<String>();

        protected QualifiedHostResolver() {
            ResolverConfig resolverConfig = ResolverConfig.getCurrentConfig();
            for (Name name : resolverConfig.searchPath()) {
                this.searchDomains.add(name.toString());
            }
        }

        @Override
        public InetAddress getByName(String host) throws UnknownHostException {
            InetAddress addr = null;
            if (InetAddresses.isInetAddress((String)host)) {
                addr = InetAddresses.forString((String)host);
                addr = InetAddress.getByAddress(host, addr.getAddress());
            } else if (host.endsWith(".")) {
                addr = this.getByExactName(host);
            } else if (host.contains(".")) {
                addr = this.getByExactName(host);
                if (addr == null) {
                    addr = this.getByNameWithSearch(host);
                }
            } else {
                InetAddress loopback = InetAddress.getByName(null);
                if (host.equalsIgnoreCase(loopback.getHostName())) {
                    addr = InetAddress.getByAddress(host, loopback.getAddress());
                } else {
                    addr = this.getByNameWithSearch(host);
                    if (addr == null) {
                        addr = this.getByExactName(host);
                    }
                }
            }
            if (addr == null) {
                throw new UnknownHostException(host);
            }
            return addr;
        }

        InetAddress getByExactName(String host) {
            InetAddress addr = null;
            String fqHost = host;
            if (!fqHost.endsWith(".")) {
                fqHost = fqHost + ".";
            }
            try {
                addr = this.getInetAddressByName(fqHost);
                addr = InetAddress.getByAddress(host, addr.getAddress());
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            return addr;
        }

        InetAddress getByNameWithSearch(String host) {
            InetAddress addr = null;
            if (host.endsWith(".")) {
                addr = this.getByExactName(host);
            } else {
                for (String domain : this.searchDomains) {
                    String dot;
                    String string = dot = !domain.startsWith(".") ? "." : "";
                    addr = this.getByExactName(host + dot + domain);
                    if (addr == null) continue;
                    break;
                }
            }
            return addr;
        }

        InetAddress getInetAddressByName(String host) throws UnknownHostException {
            return InetAddress.getByName(host);
        }

        void setSearchDomains(String ... domains) {
            this.searchDomains = Arrays.asList(domains);
        }
    }

    static class StandardHostResolver
    implements HostResolver {
        StandardHostResolver() {
        }

        @Override
        public InetAddress getByName(String host) throws UnknownHostException {
            return InetAddress.getByName(host);
        }
    }

    static interface HostResolver {
        public InetAddress getByName(String var1) throws UnknownHostException;
    }

    public static class TruststoreKeystore {
        private final String keystoreLocation;
        private final String keystorePassword;
        private final String truststoreLocation;
        private final String truststorePassword;

        public TruststoreKeystore(Configuration conf) {
            this.keystoreLocation = conf.get("hadoop.zk.ssl.keystore.location", "");
            this.keystorePassword = conf.get("hadoop.zk.ssl.keystore.password", "");
            this.truststoreLocation = conf.get("hadoop.zk.ssl.truststore.location", "");
            this.truststorePassword = conf.get("hadoop.zk.ssl.truststore.password", "");
        }

        public String getKeystoreLocation() {
            return this.keystoreLocation;
        }

        public String getKeystorePassword() {
            return this.keystorePassword;
        }

        public String getTruststoreLocation() {
            return this.truststoreLocation;
        }

        public String getTruststorePassword() {
            return this.truststorePassword;
        }
    }
}

