/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.SocketFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.ObjectWritable;
import org.apache.hadoop.io.UTF8;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.ipc.AlignmentContext;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.ClientCache;
import org.apache.hadoop.ipc.ProtocolMetaInfoPB;
import org.apache.hadoop.ipc.ProtocolProxy;
import org.apache.hadoop.ipc.ProtocolSignature;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RpcClientUtil;
import org.apache.hadoop.ipc.RpcEngine;
import org.apache.hadoop.ipc.RpcInvocationHandler;
import org.apache.hadoop.ipc.RpcServerException;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.VersionedProtocol;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.tracing.TraceScope;
import org.apache.hadoop.tracing.Tracer;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceStability.Evolving
@Deprecated
public class WritableRpcEngine
implements RpcEngine {
    private static final Logger LOG = LoggerFactory.getLogger(RPC.class);
    public static final long writableRpcVersion = 2L;
    private static boolean isInitialized = false;
    private static ClientCache CLIENTS;

    public static synchronized void ensureInitialized() {
        if (!isInitialized) {
            WritableRpcEngine.initialize();
        }
    }

    private static synchronized void initialize() {
        org.apache.hadoop.ipc.Server.registerProtocolEngine(RPC.RpcKind.RPC_WRITABLE, Invocation.class, new Server.WritableRpcInvoker());
        isInitialized = true;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    static Client getClient(Configuration conf) {
        return CLIENTS.getClient(conf);
    }

    @Override
    public <T> ProtocolProxy<T> getProxy(Class<T> protocol, long clientVersion, InetSocketAddress addr, UserGroupInformation ticket, Configuration conf, SocketFactory factory, int rpcTimeout, RetryPolicy connectionRetryPolicy) throws IOException {
        return this.getProxy(protocol, clientVersion, addr, ticket, conf, factory, rpcTimeout, connectionRetryPolicy, null, null);
    }

    @Override
    public <T> ProtocolProxy<T> getProxy(Class<T> protocol, long clientVersion, Client.ConnectionId connId, Configuration conf, SocketFactory factory, AlignmentContext alignmentContext) throws IOException {
        return this.getProxy(protocol, clientVersion, connId.getAddress(), connId.getTicket(), conf, factory, connId.getRpcTimeout(), connId.getRetryPolicy(), null, alignmentContext);
    }

    @Override
    public <T> ProtocolProxy<T> getProxy(Class<T> protocol, long clientVersion, InetSocketAddress addr, UserGroupInformation ticket, Configuration conf, SocketFactory factory, int rpcTimeout, RetryPolicy connectionRetryPolicy, AtomicBoolean fallbackToSimpleAuth, AlignmentContext alignmentContext) throws IOException {
        if (connectionRetryPolicy != null) {
            throw new UnsupportedOperationException("Not supported: connectionRetryPolicy=" + connectionRetryPolicy);
        }
        Object proxy = Proxy.newProxyInstance(protocol.getClassLoader(), new Class[]{protocol}, (InvocationHandler)new Invoker(protocol, addr, ticket, conf, factory, rpcTimeout, fallbackToSimpleAuth, alignmentContext));
        return new ProtocolProxy<Object>(protocol, proxy, true);
    }

    @Override
    public RPC.Server getServer(Class<?> protocolClass, Object protocolImpl, String bindAddress, int port, int numHandlers, int numReaders, int queueSizePerHandler, boolean verbose, Configuration conf, SecretManager<? extends TokenIdentifier> secretManager, String portRangeConfig, AlignmentContext alignmentContext) throws IOException {
        return new Server(protocolClass, protocolImpl, conf, bindAddress, port, numHandlers, numReaders, queueSizePerHandler, verbose, secretManager, portRangeConfig, alignmentContext);
    }

    @Override
    public ProtocolProxy<ProtocolMetaInfoPB> getProtocolMetaInfoProxy(Client.ConnectionId connId, Configuration conf, SocketFactory factory) throws IOException {
        throw new UnsupportedOperationException("This proxy is not supported");
    }

    static {
        WritableRpcEngine.ensureInitialized();
        CLIENTS = new ClientCache();
    }

    private static class Invocation
    implements Writable,
    Configurable {
        private String methodName;
        private Class<?>[] parameterClasses;
        private Object[] parameters;
        private Configuration conf;
        private long clientVersion;
        private int clientMethodsHash;
        private String declaringClassProtocolName;
        private long rpcVersion;

        public Invocation() {
        }

        public Invocation(Method method, Object[] parameters) {
            this.methodName = method.getName();
            this.parameterClasses = method.getParameterTypes();
            this.parameters = parameters;
            this.rpcVersion = 2L;
            if (method.getDeclaringClass().equals(VersionedProtocol.class)) {
                this.clientVersion = 0L;
                this.clientMethodsHash = 0;
            } else {
                this.clientVersion = RPC.getProtocolVersion(method.getDeclaringClass());
                this.clientMethodsHash = ProtocolSignature.getFingerprint(method.getDeclaringClass().getMethods());
            }
            this.declaringClassProtocolName = RPC.getProtocolName(method.getDeclaringClass());
        }

        public String getMethodName() {
            return this.methodName;
        }

        public Class<?>[] getParameterClasses() {
            return this.parameterClasses;
        }

        public Object[] getParameters() {
            return this.parameters;
        }

        private long getProtocolVersion() {
            return this.clientVersion;
        }

        private int getClientMethodsHash() {
            return this.clientMethodsHash;
        }

        public long getRpcVersion() {
            return this.rpcVersion;
        }

        @Override
        public void readFields(DataInput in) throws IOException {
            this.rpcVersion = in.readLong();
            this.declaringClassProtocolName = UTF8.readString(in);
            this.methodName = UTF8.readString(in);
            this.clientVersion = in.readLong();
            this.clientMethodsHash = in.readInt();
            this.parameters = new Object[in.readInt()];
            this.parameterClasses = new Class[this.parameters.length];
            ObjectWritable objectWritable = new ObjectWritable();
            for (int i = 0; i < this.parameters.length; ++i) {
                this.parameters[i] = ObjectWritable.readObject(in, objectWritable, this.conf);
                this.parameterClasses[i] = objectWritable.getDeclaredClass();
            }
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeLong(this.rpcVersion);
            UTF8.writeString(out, this.declaringClassProtocolName);
            UTF8.writeString(out, this.methodName);
            out.writeLong(this.clientVersion);
            out.writeInt(this.clientMethodsHash);
            out.writeInt(this.parameterClasses.length);
            for (int i = 0; i < this.parameterClasses.length; ++i) {
                ObjectWritable.writeObject(out, this.parameters[i], this.parameterClasses[i], this.conf, true);
            }
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append(this.methodName).append("(");
            for (int i = 0; i < this.parameters.length; ++i) {
                if (i != 0) {
                    buffer.append(", ");
                }
                buffer.append(this.parameters[i]);
            }
            buffer.append(")").append(", rpc version=" + this.rpcVersion).append(", client version=" + this.clientVersion).append(", methodsFingerPrint=" + this.clientMethodsHash);
            return buffer.toString();
        }

        @Override
        public void setConf(Configuration conf) {
            this.conf = conf;
        }

        @Override
        public Configuration getConf() {
            return this.conf;
        }
    }

    @Deprecated
    public static class Server
    extends RPC.Server {
        @Deprecated
        public Server(Object instance, Configuration conf, String bindAddress, int port) throws IOException {
            this(null, instance, conf, bindAddress, port);
        }

        public Server(Class<?> protocolClass, Object protocolImpl, Configuration conf, String bindAddress, int port) throws IOException {
            this(protocolClass, protocolImpl, conf, bindAddress, port, 1, -1, -1, false, null, null);
        }

        @Deprecated
        public Server(Object protocolImpl, Configuration conf, String bindAddress, int port, int numHandlers, int numReaders, int queueSizePerHandler, boolean verbose, SecretManager<? extends TokenIdentifier> secretManager) throws IOException {
            this(null, protocolImpl, conf, bindAddress, port, numHandlers, numReaders, queueSizePerHandler, verbose, secretManager, null);
        }

        @Deprecated
        public Server(Class<?> protocolClass, Object protocolImpl, Configuration conf, String bindAddress, int port, int numHandlers, int numReaders, int queueSizePerHandler, boolean verbose, SecretManager<? extends TokenIdentifier> secretManager, String portRangeConfig) throws IOException {
            this(null, protocolImpl, conf, bindAddress, port, numHandlers, numReaders, queueSizePerHandler, verbose, secretManager, null, null);
        }

        public Server(Class<?> protocolClass, Object protocolImpl, Configuration conf, String bindAddress, int port, int numHandlers, int numReaders, int queueSizePerHandler, boolean verbose, SecretManager<? extends TokenIdentifier> secretManager, String portRangeConfig, AlignmentContext alignmentContext) throws IOException {
            super(bindAddress, port, null, numHandlers, numReaders, queueSizePerHandler, conf, Server.serverNameFromClass(protocolImpl.getClass()), secretManager, portRangeConfig);
            Class<?>[] protocols;
            this.setAlignmentContext(alignmentContext);
            this.verbose = verbose;
            if (protocolClass == null) {
                protocols = RPC.getProtocolInterfaces(protocolImpl.getClass());
            } else {
                if (!protocolClass.isAssignableFrom(protocolImpl.getClass())) {
                    throw new IOException("protocolClass " + protocolClass + " is not implemented by protocolImpl which is of class " + protocolImpl.getClass());
                }
                this.registerProtocolAndImpl(RPC.RpcKind.RPC_WRITABLE, protocolClass, protocolImpl);
                protocols = RPC.getProtocolInterfaces(protocolClass);
            }
            for (Class<?> p : protocols) {
                if (p.equals(VersionedProtocol.class)) continue;
                this.registerProtocolAndImpl(RPC.RpcKind.RPC_WRITABLE, p, protocolImpl);
            }
        }

        private static void log(String value) {
            if (value != null && value.length() > 55) {
                value = value.substring(0, 55) + "...";
            }
            LOG.info(value);
        }

        @Deprecated
        static class WritableRpcInvoker
        implements RPC.RpcInvoker {
            WritableRpcInvoker() {
            }

            @Override
            public Writable call(RPC.Server server, String protocolName, Writable rpcRequest, long receivedTime) throws IOException, RPC.VersionMismatch {
                RPC.Server.ProtoClassProtoImpl protocolImpl;
                Invocation call = (Invocation)rpcRequest;
                if (server.verbose) {
                    Server.log("Call: " + call);
                }
                if (call.getRpcVersion() != 2L) {
                    throw new RpcServerException("WritableRpc version mismatch, client side version=" + call.getRpcVersion() + ", server side version=" + 2L);
                }
                long clientVersion = call.getProtocolVersion();
                if (call.declaringClassProtocolName.equals(VersionedProtocol.class.getName())) {
                    RPC.Server.VerProtocolImpl highest = server.getHighestSupportedProtocol(RPC.RpcKind.RPC_WRITABLE, protocolName);
                    if (highest == null) {
                        throw new RpcServerException("Unknown protocol: " + protocolName);
                    }
                    protocolImpl = highest.protocolTarget;
                } else {
                    String protoName = call.declaringClassProtocolName;
                    RPC.Server.ProtoNameVer pv = new RPC.Server.ProtoNameVer(call.declaringClassProtocolName, clientVersion);
                    protocolImpl = server.getProtocolImplMap(RPC.RpcKind.RPC_WRITABLE).get(pv);
                    if (protocolImpl == null) {
                        RPC.Server.VerProtocolImpl highest = server.getHighestSupportedProtocol(RPC.RpcKind.RPC_WRITABLE, protoName);
                        if (highest == null) {
                            throw new RpcServerException("Unknown protocol: " + protoName);
                        }
                        throw new RPC.VersionMismatch(protoName, clientVersion, highest.version);
                    }
                }
                Object exception = null;
                Server.Call currentCall = Server.getCurCall().get();
                try {
                    Method method = protocolImpl.protocolClass.getMethod(call.getMethodName(), call.getParameterClasses());
                    method.setAccessible(true);
                    server.rpcDetailedMetrics.init(protocolImpl.protocolClass);
                    currentCall.setDetailedMetricsName(call.getMethodName());
                    Object value = method.invoke(protocolImpl.protocolImpl, call.getParameters());
                    if (server.verbose) {
                        Server.log("Return: " + value);
                    }
                    ObjectWritable objectWritable = new ObjectWritable(method.getReturnType(), value);
                    return objectWritable;
                }
                catch (InvocationTargetException e) {
                    Throwable target = e.getTargetException();
                    if (target instanceof IOException) {
                        exception = (IOException)target;
                        throw (IOException)target;
                    }
                    IOException ioe = new IOException(target.toString());
                    ioe.setStackTrace(target.getStackTrace());
                    exception = ioe;
                    throw ioe;
                }
                catch (Throwable e) {
                    if (!(e instanceof IOException)) {
                        org.apache.hadoop.ipc.Server.LOG.error("Unexpected throwable object ", e);
                    }
                    IOException ioe = new IOException(e.toString());
                    ioe.setStackTrace(e.getStackTrace());
                    exception = ioe;
                    throw ioe;
                }
                finally {
                    if (exception != null) {
                        currentCall.setDetailedMetricsName(exception.getClass().getSimpleName());
                    }
                }
            }
        }
    }

    private static class Invoker
    implements RpcInvocationHandler {
        private Client.ConnectionId remoteId;
        private Client client;
        private boolean isClosed = false;
        private final AtomicBoolean fallbackToSimpleAuth;
        private final AlignmentContext alignmentContext;

        public Invoker(Class<?> protocol, InetSocketAddress address, UserGroupInformation ticket, Configuration conf, SocketFactory factory, int rpcTimeout, AtomicBoolean fallbackToSimpleAuth, AlignmentContext alignmentContext) throws IOException {
            this.remoteId = Client.ConnectionId.getConnectionId(address, protocol, ticket, rpcTimeout, null, conf);
            this.client = CLIENTS.getClient(conf, factory);
            this.fallbackToSimpleAuth = fallbackToSimpleAuth;
            this.alignmentContext = alignmentContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            ObjectWritable value;
            long startTime = 0L;
            if (LOG.isDebugEnabled()) {
                startTime = Time.monotonicNow();
            }
            Tracer tracer = Tracer.curThreadTracer();
            TraceScope traceScope = null;
            if (tracer != null) {
                traceScope = tracer.newScope(RpcClientUtil.methodToTraceString(method));
            }
            try {
                value = (ObjectWritable)this.client.call(RPC.RpcKind.RPC_WRITABLE, (Writable)new Invocation(method, args), this.remoteId, this.fallbackToSimpleAuth, this.alignmentContext);
            }
            finally {
                if (traceScope != null) {
                    traceScope.close();
                }
            }
            if (LOG.isDebugEnabled()) {
                long callTime = Time.monotonicNow() - startTime;
                LOG.debug("Call: " + method.getName() + " " + callTime);
            }
            return value.get();
        }

        @Override
        public synchronized void close() {
            if (!this.isClosed) {
                this.isClosed = true;
                CLIENTS.stopClient(this.client);
            }
        }

        @Override
        public Client.ConnectionId getConnectionId() {
            return this.remoteId;
        }
    }
}

