/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.AclUtil;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.ScopedAclEntries;
import org.apache.hadoop.fs.shell.CommandFactory;
import org.apache.hadoop.fs.shell.CommandFormat;
import org.apache.hadoop.fs.shell.FsCommand;
import org.apache.hadoop.fs.shell.PathData;
import org.apache.hadoop.util.Lists;

@InterfaceAudience.Private
@InterfaceStability.Evolving
class AclCommands
extends FsCommand {
    private static String GET_FACL = "getfacl";
    private static String SET_FACL = "setfacl";

    AclCommands() {
    }

    public static void registerCommands(CommandFactory factory) {
        factory.addClass(GetfaclCommand.class, "-" + GET_FACL);
        factory.addClass(SetfaclCommand.class, "-" + SET_FACL);
    }

    static /* synthetic */ String access$000() {
        return GET_FACL;
    }

    static /* synthetic */ String access$100() {
        return SET_FACL;
    }

    public static class GetfaclCommand
    extends FsCommand {
        public static String NAME = AclCommands.access$000();
        public static String USAGE = "[-R] <path>";
        public static String DESCRIPTION = "Displays the Access Control Lists (ACLs) of files and directories. If a directory has a default ACL, then getfacl also displays the default ACL.\n  -R: List the ACLs of all files and directories recursively.\n  <path>: File or directory to list.\n";

        @Override
        protected void processOptions(LinkedList<String> args) throws IOException {
            CommandFormat cf = new CommandFormat(0, Integer.MAX_VALUE, "R");
            cf.parse(args);
            this.setRecursive(cf.getOpt("R"));
            if (args.isEmpty()) {
                throw new HadoopIllegalArgumentException("<path> is missing");
            }
            if (args.size() > 1) {
                throw new HadoopIllegalArgumentException("Too many arguments");
            }
        }

        @Override
        protected void processPath(PathData item) throws IOException {
            List<AclEntry> entries;
            AclStatus aclStatus;
            this.out.println("# file: " + item);
            this.out.println("# owner: " + item.stat.getOwner());
            this.out.println("# group: " + item.stat.getGroup());
            FsPermission perm = item.stat.getPermission();
            if (perm.getStickyBit()) {
                this.out.println("# flags: --" + (perm.getOtherAction().implies(FsAction.EXECUTE) ? "t" : "T"));
            }
            if (item.stat.hasAcl()) {
                aclStatus = item.fs.getAclStatus(item.path);
                entries = aclStatus.getEntries();
            } else {
                aclStatus = null;
                entries = Collections.emptyList();
            }
            ScopedAclEntries scopedEntries = new ScopedAclEntries(AclUtil.getAclFromPermAndEntries(perm, entries));
            this.printAclEntriesForSingleScope(aclStatus, perm, scopedEntries.getAccessEntries());
            this.printAclEntriesForSingleScope(aclStatus, perm, scopedEntries.getDefaultEntries());
            this.out.println();
        }

        private void printAclEntriesForSingleScope(AclStatus aclStatus, FsPermission fsPerm, List<AclEntry> entries) {
            if (entries.isEmpty()) {
                return;
            }
            if (AclUtil.isMinimalAcl(entries)) {
                for (AclEntry entry : entries) {
                    this.out.println(entry.toStringStable());
                }
            } else {
                for (AclEntry entry : entries) {
                    this.printExtendedAclEntry(aclStatus, fsPerm, entry);
                }
            }
        }

        private void printExtendedAclEntry(AclStatus aclStatus, FsPermission fsPerm, AclEntry entry) {
            if (entry.getName() != null || entry.getType() == AclEntryType.GROUP) {
                FsAction effectivePerm;
                FsAction entryPerm = entry.getPermission();
                if (entryPerm != (effectivePerm = aclStatus.getEffectivePermission(entry, fsPerm))) {
                    this.out.println(String.format("%s\t#effective:%s", entry, effectivePerm.SYMBOL));
                } else {
                    this.out.println(entry.toStringStable());
                }
            } else {
                this.out.println(entry.toStringStable());
            }
        }
    }

    public static class SetfaclCommand
    extends FsCommand {
        public static String NAME = AclCommands.access$100();
        public static String USAGE = "[-R] [{-b|-k} {-m|-x <acl_spec>} <path>]|[--set <acl_spec> <path>]";
        public static String DESCRIPTION = "Sets Access Control Lists (ACLs) of files and directories.\nOptions:\n  -b :Remove all but the base ACL entries. The entries for user, group and others are retained for compatibility with permission bits.\n  -k :Remove the default ACL.\n  -R :Apply operations to all files and directories recursively.\n  -m :Modify ACL. New entries are added to the ACL, and existing entries are retained.\n  -x :Remove specified ACL entries. Other ACL entries are retained.\n  --set :Fully replace the ACL, discarding all existing entries. The <acl_spec> must include entries for user, group, and others for compatibility with permission bits. If the ACL spec contains only access entries, then the existing default entries are retained. If the ACL spec contains only default entries, then the existing access entries are retained. If the ACL spec contains both access and default entries, then both are replaced.\n  <acl_spec>: Comma separated list of ACL entries.\n  <path>: File or directory to modify.\n";
        CommandFormat cf = new CommandFormat(0, Integer.MAX_VALUE, "b", "k", "R", "m", "x", "-set");
        List<AclEntry> aclEntries = null;
        List<AclEntry> accessAclEntries = null;

        @Override
        protected void processOptions(LinkedList<String> args) throws IOException {
            boolean hasExpectedOptions;
            this.cf.parse(args);
            this.setRecursive(this.cf.getOpt("R"));
            boolean bothRemoveOptions = this.cf.getOpt("b") && this.cf.getOpt("k");
            boolean bothModifyOptions = this.cf.getOpt("m") && this.cf.getOpt("x");
            boolean oneRemoveOption = this.cf.getOpt("b") || this.cf.getOpt("k");
            boolean oneModifyOption = this.cf.getOpt("m") || this.cf.getOpt("x");
            boolean setOption = this.cf.getOpt("-set");
            boolean bl = hasExpectedOptions = this.cf.getOpt("b") || this.cf.getOpt("k") || this.cf.getOpt("m") || this.cf.getOpt("x") || this.cf.getOpt("-set");
            if (bothRemoveOptions || bothModifyOptions || oneRemoveOption && oneModifyOption || setOption && (oneRemoveOption || oneModifyOption)) {
                throw new HadoopIllegalArgumentException("Specified flags contains both remove and modify flags");
            }
            if (oneModifyOption || setOption) {
                if (args.isEmpty()) {
                    throw new HadoopIllegalArgumentException("Missing arguments: <acl_spec> <path>");
                }
                if (args.size() < 2) {
                    throw new HadoopIllegalArgumentException("Missing either <acl_spec> or <path>");
                }
                this.aclEntries = AclEntry.parseAclSpec(args.removeFirst(), !this.cf.getOpt("x"));
                if (this.aclEntries.isEmpty()) {
                    throw new HadoopIllegalArgumentException("Missing <acl_spec> entry");
                }
            }
            if (args.isEmpty()) {
                throw new HadoopIllegalArgumentException("<path> is missing");
            }
            if (args.size() > 1) {
                throw new HadoopIllegalArgumentException("Too many arguments");
            }
            if (!hasExpectedOptions) {
                throw new HadoopIllegalArgumentException("Expected one of -b, -k, -m, -x or --set options");
            }
            if (this.isRecursive() && (oneModifyOption || setOption)) {
                this.accessAclEntries = Lists.newArrayList();
                for (AclEntry entry : this.aclEntries) {
                    if (entry.getScope() != AclEntryScope.ACCESS) continue;
                    this.accessAclEntries.add(entry);
                }
            }
        }

        @Override
        protected void processPath(PathData item) throws IOException {
            List<AclEntry> entries;
            if (this.cf.getOpt("b")) {
                item.fs.removeAcl(item.path);
            } else if (this.cf.getOpt("k")) {
                item.fs.removeDefaultAcl(item.path);
            } else if (this.cf.getOpt("m")) {
                List<AclEntry> entries2 = this.getAclEntries(item);
                if (!entries2.isEmpty()) {
                    item.fs.modifyAclEntries(item.path, entries2);
                }
            } else if (this.cf.getOpt("x")) {
                List<AclEntry> entries3 = this.getAclEntries(item);
                if (!entries3.isEmpty()) {
                    item.fs.removeAclEntries(item.path, entries3);
                }
            } else if (this.cf.getOpt("-set") && !(entries = this.getAclEntries(item)).isEmpty()) {
                item.fs.setAcl(item.path, entries);
            }
        }

        private List<AclEntry> getAclEntries(PathData item) {
            if (this.isRecursive()) {
                return item.stat.isDirectory() ? this.aclEntries : this.accessAclEntries;
            }
            return this.aclEntries;
        }
    }
}

