/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util.functional;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.test.AbstractHadoopTestBase;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.util.functional.LazyAtomicReference;
import org.apache.hadoop.util.functional.LazyAutoCloseableReference;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.Test;

public class TestLazyReferences
extends AbstractHadoopTestBase {
    private static final String GENERATED = "generated[%d]";
    private final AtomicInteger counter = new AtomicInteger();

    private void assertCounterValue(int val) {
        TestLazyReferences.assertAtomicIntValue(this.counter, val);
    }

    private static void assertAtomicIntValue(AtomicInteger ai, int val) {
        ((AbstractIntegerAssert)Assertions.assertThat((int)ai.get()).describedAs("value of atomic integer %s", new Object[]{ai})).isEqualTo(val);
    }

    @Test
    public void testLazyAtomicReference() throws Throwable {
        LazyAtomicReference ref = new LazyAtomicReference(this.counter::incrementAndGet);
        this.assertCounterValue(0);
        TestLazyReferences.assertSetState(ref, false);
        ((AbstractIntegerAssert)Assertions.assertThat((Integer)((Integer)ref.eval())).describedAs("first eval()", new Object[0])).isEqualTo(1);
        this.assertCounterValue(1);
        TestLazyReferences.assertSetState(ref, true);
        ((AbstractIntegerAssert)Assertions.assertThat((Integer)((Integer)ref.apply())).describedAs("second get of %s", new Object[]{ref})).isEqualTo(1);
        this.assertCounterValue(1);
    }

    private static <T> void assertSetState(LazyAtomicReference<T> ref, boolean expected) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)ref.isSet()).describedAs("isSet() of %s", new Object[]{ref})).isEqualTo(expected);
    }

    @Test
    public void testSupplierIntegration() throws Throwable {
        LazyAtomicReference ref = LazyAtomicReference.lazyAtomicReferenceFromSupplier(this.counter::incrementAndGet);
        this.assertCounterValue(0);
        TestLazyReferences.assertSetState(ref, false);
        ((AbstractIntegerAssert)Assertions.assertThat((Integer)((Integer)ref.get())).describedAs("first get()", new Object[0])).isEqualTo(1);
        this.assertCounterValue(1);
        ((AbstractIntegerAssert)Assertions.assertThat((Integer)((Integer)ref.apply())).describedAs("second get of %s", new Object[]{ref})).isEqualTo(1);
        this.assertCounterValue(1);
    }

    @Test
    public void testSupplierIntegrationFailureHandling() throws Throwable {
        LazyAtomicReference ref = new LazyAtomicReference(() -> {
            throw new UnknownHostException(String.format(GENERATED, this.counter.incrementAndGet()));
        });
        LambdaTestUtils.verifyCause(UnknownHostException.class, LambdaTestUtils.intercept(UncheckedIOException.class, "[1]", () -> ((LazyAtomicReference)ref).get()));
        TestLazyReferences.assertSetState(ref, false);
        LambdaTestUtils.intercept(UncheckedIOException.class, "[2]", () -> ((LazyAtomicReference)ref).get());
    }

    @Test
    public void testAutoCloseable() throws Throwable {
        LazyAutoCloseableReference ref = LazyAutoCloseableReference.lazyAutoCloseablefromSupplier(() -> new CloseableClass());
        TestLazyReferences.assertSetState(ref, false);
        ref.eval();
        CloseableClass closeable = (CloseableClass)ref.get();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)closeable.isClosed()).describedAs("closed flag of %s", new Object[]{closeable})).isFalse();
        ref.close();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)ref.isClosed()).describedAs("closed flag of %s", new Object[]{ref})).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)closeable.isClosed()).describedAs("closed flag of %s", new Object[]{closeable})).isTrue();
        ref.close();
        LambdaTestUtils.intercept(IllegalStateException.class, "Reference is closed", () -> ((LazyAutoCloseableReference)ref).eval());
        LambdaTestUtils.intercept(IllegalStateException.class, "Reference is closed", () -> ((LazyAutoCloseableReference)ref).get());
        LambdaTestUtils.intercept(IllegalStateException.class, "Reference is closed", () -> ((LazyAutoCloseableReference)ref).apply());
        ((ObjectAssert)Assertions.assertThat((Object)((CloseableClass)ref.getReference().get())).describedAs("inner referece of %s", new Object[]{ref})).isNull();
    }

    @Test
    public void testCloseableUnevaluated() throws Throwable {
        LazyAutoCloseableReference ref = new LazyAutoCloseableReference(() -> new CloseableRaisingException());
        ref.close();
        ref.close();
    }

    @Test
    public void testAutoCloseableFailureHandling() throws Throwable {
        LazyAutoCloseableReference ref = new LazyAutoCloseableReference(() -> new CloseableRaisingException());
        ref.eval();
        LambdaTestUtils.intercept(IOException.class, "raised", () -> ((LazyAutoCloseableReference)ref).close());
        TestLazyReferences.assertSetState(ref, false);
        ref.close();
    }

    private static final class CloseableClass
    implements AutoCloseable {
        private boolean closed;

        private CloseableClass() {
        }

        @Override
        public void close() {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Already closed");
            this.closed = true;
        }

        private boolean isClosed() {
            return this.closed;
        }
    }

    private static final class CloseableRaisingException
    implements AutoCloseable {
        private CloseableRaisingException() {
        }

        @Override
        public void close() throws Exception {
            throw new IOException("raised");
        }
    }
}

